/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem.forge;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.forge.IEnergyStorageModifiable;

public class ForgePowerItemManager
implements IEnergyStorage,
IEnergyStorageModifiable {
    ItemStack stack;
    IEnergyItemInfo itemPowerInfo;

    public ForgePowerItemManager(ItemStack stack) {
        this.stack = stack;
        if (stack.func_77973_b() instanceof IEnergyItemInfo) {
            this.itemPowerInfo = (IEnergyItemInfo)stack.func_77973_b();
        }
        this.validateNBT();
    }

    public ForgePowerItemManager(ItemStack stack, IEnergyItemInfo itemPowerInfo) {
        this.stack = stack;
        this.itemPowerInfo = itemPowerInfo;
        this.validateNBT();
    }

    private int getEnergyInStack() {
        this.validateNBT();
        return this.stack.func_77978_p().func_74762_e("energy");
    }

    private void setEnergyInStack(int energy) {
        this.validateNBT();
        this.stack.func_77978_p().func_74768_a("energy", energy);
    }

    private void validateNBT() {
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new NBTTagCompound());
            this.stack.func_77978_p().func_74768_a("energy", 0);
        } else if (this.stack.func_77978_p().func_74764_b("charge")) {
            this.stack.func_77978_p().func_74768_a("energy", this.stack.func_77978_p().func_74762_e("charge") * RebornCoreConfig.euPerFU);
            this.stack.func_77978_p().func_82580_o("charge");
        }
    }

    public void setEnergyStored(int value) {
        this.setEnergyInStack(value);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.itemPowerInfo.canAcceptEnergy(this.stack)) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min((int)this.itemPowerInfo.getMaxTransfer(this.stack), maxReceive));
        if (!simulate) {
            this.setEnergyInStack(this.getEnergyInStack() + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.itemPowerInfo.canAcceptEnergy(this.stack)) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), maxExtract);
        if (!simulate) {
            this.setEnergyInStack(this.getEnergyInStack() - energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.getEnergyInStack();
    }

    public int getMaxEnergyStored() {
        return (int)this.itemPowerInfo.getMaxPower(this.stack);
    }

    public boolean canExtract() {
        return this.itemPowerInfo.canProvideEnergy(this.stack);
    }

    public boolean canReceive() {
        return this.itemPowerInfo.canAcceptEnergy(this.stack);
    }

    @Override
    public void setEnergy(int energy) {
        this.setEnergyInStack(energy);
    }
}

