/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.containerBuilder.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.client.containerBuilder.IRightClickHandler;
import reborncore.client.containerBuilder.builder.IExtendedContainerListener;
import reborncore.client.gui.slots.SlotFake;
import reborncore.common.tile.RebornMachineTile;
import reborncore.common.util.ItemUtils;

public class BuiltContainer
extends Container
implements IExtendedContainerListener {
    private final String name;
    private final Predicate<EntityPlayer> canInteract;
    private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Short>> shortValues;
    private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Integer>> integerValues;
    private final ArrayList<MutableTriple<LongSupplier, LongConsumer, Long>> longValues;
    private final ArrayList<MutableTriple<Supplier<FluidStack>, Consumer<FluidStack>, FluidStack>> fluidStackValues;
    private final ArrayList<MutableTriple<Supplier<Object>, Consumer<Object>, Object>> objectValues;
    private List<Consumer<InventoryCrafting>> craftEvents;
    private Integer[] integerParts;
    private final RebornMachineTile tile;

    public BuiltContainer(String name, Predicate<EntityPlayer> canInteract, RebornMachineTile tile) {
        this.name = name;
        this.canInteract = canInteract;
        this.shortValues = new ArrayList();
        this.integerValues = new ArrayList();
        this.longValues = new ArrayList();
        this.fluidStackValues = new ArrayList();
        this.objectValues = new ArrayList();
        this.tile = tile;
    }

    public void addShortSync(List<Pair<IntSupplier, IntConsumer>> syncables) {
        for (Pair<IntSupplier, IntConsumer> syncable : syncables) {
            this.shortValues.add((MutableTriple<IntSupplier, IntConsumer, Short>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), (Object)0));
        }
        this.shortValues.trimToSize();
    }

    public void addLongSync(List<Pair<LongSupplier, LongConsumer>> syncables) {
        for (Pair<LongSupplier, LongConsumer> syncable : syncables) {
            this.longValues.add((MutableTriple<LongSupplier, LongConsumer, Long>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), (Object)0L));
        }
        this.longValues.trimToSize();
    }

    public void addIntegerSync(List<Pair<IntSupplier, IntConsumer>> syncables) {
        for (Pair<IntSupplier, IntConsumer> syncable : syncables) {
            this.integerValues.add((MutableTriple<IntSupplier, IntConsumer, Integer>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), (Object)0));
        }
        this.integerValues.trimToSize();
        this.integerParts = new Integer[this.integerValues.size()];
    }

    public void addFluidStackSync(List<Pair<Supplier<FluidStack>, Consumer<FluidStack>>> syncables) {
        for (Pair<Supplier<FluidStack>, Consumer<FluidStack>> syncable : syncables) {
            this.fluidStackValues.add((MutableTriple<Supplier<FluidStack>, Consumer<FluidStack>, FluidStack>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), null));
        }
        this.fluidStackValues.trimToSize();
    }

    public void addObjectSync(List<Pair<Supplier<Object>, Consumer<Object>>> syncables) {
        for (Pair<Supplier<Object>, Consumer<Object>> syncable : syncables) {
            this.objectValues.add((MutableTriple<Supplier<Object>, Consumer<Object>, Object>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), null));
        }
        this.objectValues.trimToSize();
    }

    public void addCraftEvents(List<Consumer<InventoryCrafting>> craftEvents) {
        this.craftEvents = craftEvents;
    }

    public void addSlot(Slot slot) {
        this.func_75146_a(slot);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tile != null ? this.tile.func_70300_a(playerIn) : this.canInteract.test(playerIn);
    }

    public final void func_75130_a(IInventory inv) {
        if (!this.craftEvents.isEmpty()) {
            this.craftEvents.forEach(consumer -> consumer.accept((InventoryCrafting)inv));
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        Slot slot;
        if (dragType == 1 && slotId > 0 && slotId < 1000 && (slot = (Slot)this.field_75151_b.get(slotId)) instanceof IRightClickHandler && ((IRightClickHandler)slot).handleRightClick(slot.getSlotIndex(), player, this)) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    /*
     * Could not resolve type clashes
     */
    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            int supplied;
            int i = 0;
            if (!this.shortValues.isEmpty()) {
                for (MutableTriple value : this.shortValues) {
                    supplied = ((IntSupplier)value.getLeft()).getAsInt();
                    if (supplied != (Short)value.getRight()) {
                        listener.func_71112_a((Container)this, i, supplied);
                        value.setRight((Object)((short)supplied));
                    }
                    ++i;
                }
            }
            if (!this.integerValues.isEmpty()) {
                for (MutableTriple value : this.integerValues) {
                    supplied = ((IntSupplier)value.getLeft()).getAsInt();
                    if (supplied != (Integer)value.getRight()) {
                        listener.func_71112_a((Container)this, i, supplied >> 16);
                        listener.func_71112_a((Container)this, i + 1, (int)((short)(supplied & 0xFFFF)));
                        value.setRight((Object)supplied);
                    }
                    i += 2;
                }
            }
            if (!this.longValues.isEmpty()) {
                int longs = 0;
                for (MutableTriple<LongSupplier, LongConsumer, Long> value : this.longValues) {
                    long supplied2 = ((LongSupplier)value.getLeft()).getAsLong();
                    if (supplied2 != (Long)value.getRight()) {
                        this.sendLong(listener, this, longs, supplied2);
                        value.setRight((Object)supplied2);
                    }
                    ++longs;
                }
            }
            if (!this.fluidStackValues.isEmpty()) {
                int fluidStacks = 0;
                for (MutableTriple value : this.fluidStackValues) {
                    FluidStack supplied3 = (FluidStack)((Supplier)value.getLeft()).get();
                    this.sendFluidStack(listener, this, fluidStacks, supplied3);
                    value.setRight((Object)supplied3);
                    ++fluidStacks;
                }
            }
            if (this.objectValues.isEmpty()) continue;
            int objects = 0;
            for (MutableTriple value : this.objectValues) {
                Object supplied4 = value.getLeft();
                if (((Supplier)supplied4).get() != value.getRight()) {
                    this.sendObject(listener, this, objects, ((Supplier)supplied4).get());
                    value.setRight(((Supplier)supplied4).get());
                }
                ++objects;
            }
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        int i = 0;
        if (!this.shortValues.isEmpty()) {
            for (MutableTriple<IntSupplier, IntConsumer, Short> mutableTriple : this.shortValues) {
                short s2 = (short)((IntSupplier)mutableTriple.getLeft()).getAsInt();
                listener.func_71112_a((Container)this, i, (int)s2);
                mutableTriple.setRight((Object)s2);
                ++i;
            }
        }
        if (!this.integerValues.isEmpty()) {
            for (MutableTriple mutableTriple : this.integerValues) {
                int n = ((IntSupplier)mutableTriple.getLeft()).getAsInt();
                listener.func_71112_a((Container)this, i, n >> 16);
                listener.func_71112_a((Container)this, i + 1, (int)((short)(n & 0xFFFF)));
                mutableTriple.setRight((Object)n);
                i += 2;
            }
        }
        if (!this.longValues.isEmpty()) {
            int longs = 0;
            for (MutableTriple<LongSupplier, LongConsumer, Long> mutableTriple : this.longValues) {
                long supplied2 = ((LongSupplier)mutableTriple.getLeft()).getAsLong();
                this.sendLong(listener, this, longs, supplied2);
                mutableTriple.setRight((Object)supplied2);
                ++longs;
            }
        }
        if (!this.fluidStackValues.isEmpty()) {
            int fluidStacks = 0;
            for (MutableTriple<Supplier<FluidStack>, Consumer<FluidStack>, FluidStack> mutableTriple : this.fluidStackValues) {
                FluidStack supplied3 = (FluidStack)((Supplier)mutableTriple.getLeft()).get();
                this.sendFluidStack(listener, this, fluidStacks, supplied3);
                mutableTriple.setRight((Object)supplied3);
                ++fluidStacks;
            }
        }
        if (!this.objectValues.isEmpty()) {
            int objects = 0;
            for (MutableTriple<Supplier<Object>, Consumer<Object>, Object> mutableTriple : this.objectValues) {
                Object supplied4 = mutableTriple.getLeft();
                this.sendObject(listener, this, objects, ((Supplier)supplied4).get());
                mutableTriple.setRight(supplied4);
                ++objects;
            }
        }
    }

    @Override
    public void handleLong(int var, long value) {
        ((LongConsumer)this.longValues.get(var).getMiddle()).accept(value);
    }

    @Override
    public void handleFluidStack(int var, FluidStack value) {
        ((Consumer)this.fluidStackValues.get(var).getMiddle()).accept(value);
    }

    @Override
    public void handleObject(int var, Object value) {
        ((Consumer)this.objectValues.get(var).getMiddle()).accept(value);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        if (id < this.shortValues.size()) {
            ((IntConsumer)this.shortValues.get(id).getMiddle()).accept((short)value);
            this.shortValues.get(id).setRight((Object)((short)value));
        } else if (id - this.shortValues.size() < this.integerValues.size() * 2) {
            if ((id - this.shortValues.size()) % 2 == 0) {
                this.integerParts[(id - this.shortValues.size()) / 2] = value;
            } else {
                ((IntConsumer)this.integerValues.get((id - this.shortValues.size()) / 2).getMiddle()).accept((this.integerParts[(id - this.shortValues.size()) / 2] & 0xFFFF) << 16 | value & 0xFFFF);
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.func_75216_d()) {
            ItemStack destinationStack;
            ItemStack sourceItemStack = sourceSlot.func_75211_c();
            int oldSourceItemStackSize = ItemUtils.getSize(sourceItemStack);
            ItemStack itemStack = destinationStack = sourceSlot.field_75224_c == player.field_71071_by ? this.handlePlayerSlotShiftClick(player, sourceItemStack) : this.handleGUISlotShiftClick(player, sourceItemStack);
            if (ItemUtils.isEmpty(destinationStack) || ItemUtils.getSize(destinationStack) != oldSourceItemStackSize) {
                sourceSlot.func_75215_d(destinationStack);
                sourceSlot.func_190901_a(player, sourceItemStack);
                if (!player.func_130014_f_().field_72995_K) {
                    this.func_75142_b();
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public String getName() {
        return this.name;
    }

    protected ItemStack handlePlayerSlotShiftClick(EntityPlayer player, ItemStack sourceItemStack) {
        block0: for (int pass = 0; pass < 4 && !ItemUtils.isEmpty(sourceItemStack); ++pass) {
            for (Slot targetSlot : this.field_75151_b) {
                if (targetSlot.field_75224_c == player.field_71071_by || !BuiltContainer.isValidTargetSlot(targetSlot, sourceItemStack, pass % 2 == 1, pass < 2) || !ItemUtils.isEmpty(sourceItemStack = BuiltContainer.transfer(sourceItemStack, targetSlot))) continue;
                continue block0;
            }
        }
        return sourceItemStack;
    }

    protected ItemStack handleGUISlotShiftClick(EntityPlayer player, ItemStack sourceItemStack) {
        block0: for (int pass = 0; pass < 2 && !ItemUtils.isEmpty(sourceItemStack); ++pass) {
            ListIterator it = this.field_75151_b.listIterator(this.field_75151_b.size());
            while (it.hasPrevious()) {
                Slot targetSlot = (Slot)it.previous();
                if (targetSlot.field_75224_c != player.field_71071_by || !BuiltContainer.isValidTargetSlot(targetSlot, sourceItemStack, pass == 1, false) || !ItemUtils.isEmpty(sourceItemStack = BuiltContainer.transfer(sourceItemStack, targetSlot))) continue;
                continue block0;
            }
        }
        return sourceItemStack;
    }

    protected static boolean isValidTargetSlot(Slot slot, ItemStack itemStack, boolean allowEmpty, boolean requireInputOnly) {
        if (slot instanceof SlotFake) {
            return false;
        }
        if (!slot.func_75214_a(itemStack)) {
            return false;
        }
        if (!allowEmpty && !slot.func_75216_d()) {
            return false;
        }
        return !requireInputOnly || slot.func_75214_a(itemStack);
    }

    protected static ItemStack transfer(ItemStack itemStack, Slot destination) {
        int amount = BuiltContainer.getTransferAmount(itemStack, destination);
        if (amount <= 0) {
            return itemStack;
        }
        ItemStack destinationStack = destination.func_75211_c();
        destination.func_75215_d(ItemUtils.isEmpty(destinationStack) ? ItemUtils.copyWithSize(itemStack, amount) : ItemUtils.increaseSize(destinationStack, amount));
        return ItemUtils.decreaseSize(itemStack, amount);
    }

    protected static int getTransferAmount(ItemStack itemStack, Slot destination) {
        int maxAmount = Math.min(destination.field_75224_c.func_70297_j_(), destination.func_75219_a());
        maxAmount = Math.min(maxAmount, itemStack.func_77985_e() ? itemStack.func_77976_d() : 1);
        ItemStack destinationStack = destination.func_75211_c();
        if (!ItemUtils.isEmpty(destinationStack)) {
            if (!ItemUtils.isItemEqual(itemStack, destinationStack, true, true)) {
                return 0;
            }
            maxAmount -= ItemUtils.getSize(destinationStack);
        }
        return Math.min(maxAmount, ItemUtils.getSize(itemStack));
    }
}

