/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.tileentity.device;

import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.inventory.InventoryProcessor;
import growthcraft.core.shared.item.ItemUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class DeviceInventorySlot {
    public final int index;
    private IInventory inventory;

    public DeviceInventorySlot(IInventory inv, int idx) {
        this.inventory = inv;
        this.index = idx;
    }

    public ItemStack get() {
        return this.inventory.func_70301_a(this.index);
    }

    public int getSize() {
        ItemStack stack = this.get();
        if (ItemUtils.isEmpty(stack)) {
            return 0;
        }
        return stack.func_190916_E();
    }

    public int getCapacity() {
        ItemStack stack = this.get();
        if (!ItemUtils.isEmpty(stack)) {
            return stack.func_77976_d();
        }
        return this.inventory.func_70297_j_();
    }

    public int getAvailableCapacity() {
        return this.getCapacity() - this.getSize();
    }

    public void set(ItemStack newStack) {
        this.inventory.func_70299_a(this.index, newStack);
    }

    public boolean hasContent() {
        return this.getSize() > 0;
    }

    public boolean isEmpty() {
        return !this.hasContent();
    }

    public boolean isFull() {
        return this.getAvailableCapacity() <= 0;
    }

    public boolean hasMatching(ItemStack stack) {
        ItemStack s = this.get();
        if (ItemUtils.isEmpty(stack)) {
            return ItemUtils.isEmpty(s);
        }
        if (!ItemUtils.isEmpty(stack) && !ItemUtils.isEmpty(s)) {
            return stack.func_77969_a(s);
        }
        return false;
    }

    public boolean hasMatching(IMultiItemStacks stack) {
        ItemStack s = this.get();
        if (ItemUtils.isEmpty(stack)) {
            return ItemUtils.isEmpty(s);
        }
        if (!ItemUtils.isEmpty(stack) && !ItemUtils.isEmpty(s)) {
            return stack.containsItemStack(s);
        }
        return false;
    }

    public boolean hasMatchingWithCapacity(ItemStack stack) {
        if (ItemUtils.isEmpty(stack)) {
            return true;
        }
        if (!this.isEmpty() && !this.hasMatching(stack)) {
            return false;
        }
        return this.getAvailableCapacity() >= stack.func_190916_E();
    }

    public boolean hasCapacityFor(ItemStack stack) {
        if (ItemUtils.isEmpty(stack)) {
            return true;
        }
        if (this.hasContent() && !this.hasMatching(stack)) {
            return false;
        }
        return this.getAvailableCapacity() >= stack.func_190916_E();
    }

    public boolean hasEnough(ItemStack stack) {
        if (this.hasMatching(stack)) {
            if (!ItemUtils.isEmpty(stack)) {
                ItemStack s = this.get();
                if (s.func_190916_E() >= stack.func_190916_E()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean hasEnough(IMultiItemStacks stack) {
        if (this.hasMatching(stack)) {
            if (!ItemUtils.isEmpty(stack)) {
                ItemStack s = this.get();
                if (s.func_190916_E() >= stack.getStackSize()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public ItemStack consume(int count) {
        return this.inventory.func_70298_a(this.index, count);
    }

    public ItemStack consume(ItemStack stack) {
        if (this.hasEnough(stack)) {
            return this.consume(stack.func_190916_E());
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack consume(IMultiItemStacks stack) {
        if (this.hasEnough(stack)) {
            return this.consume(stack.getStackSize());
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack increaseStack(ItemStack stack) {
        ItemStack result = ItemUtils.mergeStacks(this.get(), stack);
        if (!ItemUtils.isEmpty(result)) {
            this.set(result);
        }
        return result;
    }

    public ItemStack yank() {
        return InventoryProcessor.instance().yankSlot(this.inventory, this.index);
    }
}

