/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.item.recipes;

import growthcraft.core.shared.definition.IMultiFluidStacks;
import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.item.MultiItemStacks;
import growthcraft.core.shared.item.MultiStacksUtil;
import growthcraft.core.shared.item.OreItemStacks;
import growthcraft.core.shared.legacy.FluidContainerRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShapelessMultiRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private ItemStack output;
    private ArrayList<IMultiItemStacks> input = new ArrayList();
    private ArrayList<IMultiFluidStacks> fluids = new ArrayList();
    private final String group;

    public ShapelessMultiRecipe(String group, Block result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public ShapelessMultiRecipe(String group, Item result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public ShapelessMultiRecipe(String group, ItemStack result, Object ... recipe) {
        this.group = group;
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(new MultiItemStacks(((ItemStack)in).func_77946_l()));
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new MultiItemStacks(new ItemStack((Item)in)));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new MultiItemStacks(new ItemStack((Block)in)));
                continue;
            }
            if (in instanceof String) {
                this.input.add(new OreItemStacks((String)in));
                continue;
            }
            if (in instanceof IMultiItemStacks) {
                this.input.add((IMultiItemStacks)in);
                continue;
            }
            if (in instanceof FluidStack) {
                this.fluids.add(MultiStacksUtil.toMultiFluidStacks(in));
                continue;
            }
            if (in instanceof IMultiFluidStacks) {
                this.fluids.add((IMultiFluidStacks)in);
                continue;
            }
            String ret = "Invalid shapeless multi recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        HashMap<IMultiFluidStacks, Integer> aggregateFluids = new HashMap<IMultiFluidStacks, Integer>();
        for (IMultiFluidStacks fluid : this.fluids) {
            aggregateFluids.put(fluid, fluid.getAmount());
        }
        ArrayList<IMultiItemStacks> required = new ArrayList<IMultiItemStacks>(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (ItemUtils.isEmpty(slot)) continue;
            boolean inRecipe = false;
            Iterator<IMultiItemStacks> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                IMultiItemStacks next = req.next();
                Iterator<ItemStack> itr = next.getItemStacks().iterator();
                while (itr.hasNext() && !match) {
                    match = OreDictionary.itemMatches((ItemStack)itr.next(), (ItemStack)slot, (boolean)false);
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            boolean fluidConsumed = false;
            if (FluidContainerRegistry.isFilledContainer(slot)) {
                FluidStack containerFluid = FluidContainerRegistry.getFluidForFilledItem(slot).copy();
                for (IMultiFluidStacks fluidStacks : this.fluids) {
                    int aggregateAmount;
                    int n = aggregateAmount = aggregateFluids.containsKey(fluidStacks) ? (Integer)aggregateFluids.get(fluidStacks) : 0;
                    if (!fluidStacks.containsFluidStack(containerFluid) || aggregateAmount <= 0) continue;
                    int leftover = Math.max(0, aggregateAmount - containerFluid.amount);
                    if (leftover <= 1) {
                        aggregateFluids.remove(fluidStacks);
                    } else {
                        aggregateFluids.put(fluidStacks, leftover);
                    }
                    fluidConsumed = true;
                }
            }
            if (fluidConsumed) continue;
            return false;
        }
        return required.isEmpty() && aggregateFluids.isEmpty();
    }

    public ArrayList<IMultiItemStacks> getInput() {
        return this.input;
    }

    public List<IMultiFluidStacks> getFluids() {
        return this.fluids;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)FluidContainerRegistry.getContainerItemWithFallback(itemstack));
        }
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.input.size() + this.fluids.size();
    }

    @Nonnull
    public String func_193358_e() {
        return this.group;
    }
}

