/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.pressing;

import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.cellar.shared.processing.pressing.IPressingRecipe;
import growthcraft.cellar.shared.processing.pressing.PressingRecipe;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.item.MultiStacksUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class PressingRegistry {
    private List<IPressingRecipe> recipes = new ArrayList<IPressingRecipe>();

    public void addRecipe(@Nonnull IPressingRecipe recipe) {
        this.recipes.add(recipe);
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Added new Pressing Recipe recipe={%s}", (Object)recipe);
    }

    public void addRecipe(@Nonnull Object inputStack, @Nonnull FluidStack resultFluid, int time, @Nullable Residue residue) {
        this.addRecipe(new PressingRecipe(MultiStacksUtil.toMultiItemStacks(inputStack), resultFluid, time, residue));
    }

    public IPressingRecipe getPressingRecipe(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        for (IPressingRecipe recipe : this.recipes) {
            if (!recipe.matchesRecipe(itemstack)) continue;
            return recipe;
        }
        return null;
    }

    public boolean hasPressingRecipe(ItemStack itemstack) {
        return this.getPressingRecipe(itemstack) != null;
    }
}

