/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.compat.waila;

import growthcraft.cellar.common.tileentity.TileEntityFermentBarrel;
import growthcraft.core.shared.tileentity.GrowthcraftTileDeviceBase;
import growthcraft.core.shared.tileentity.feature.ITileProgressiveDevice;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidTank;

public class WailaDataProvider
implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)new WailaDataProvider(), GrowthcraftTileDeviceBase.class);
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        float progress;
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof ITileProgressiveDevice && (progress = (float)((ITileProgressiveDevice)tileEntity).getDeviceProgressScaled(100)) > 0.0f) {
            tooltip.add(TextFormatting.GREEN + "Progress: " + progress + "%");
        }
        if (tileEntity instanceof TileEntityFermentBarrel) {
            FluidTank fluidTank = ((TileEntityFermentBarrel)tileEntity).getFluidTank(0);
            if (fluidTank.getFluidAmount() > 0) {
                tooltip.add(TextFormatting.GREEN + String.format("%dmb %s", fluidTank.getFluidAmount(), fluidTank.getFluid().getLocalizedName()));
            } else {
                tooltip.add("Empty");
            }
        }
        return tooltip;
    }
}

