/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees;

import growthcraft.bees.common.CommonProxy;
import growthcraft.bees.common.Init;
import growthcraft.bees.common.lib.config.user.UserBeesConfig;
import growthcraft.bees.common.lib.config.user.UserFlowersConfig;
import growthcraft.bees.shared.config.GrowthcraftBeesConfig;
import growthcraft.core.shared.inventory.GrowthcraftGuiProvider;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="growthcraft_bees", name="Growthcraft Bees", version="4.1.3.100", dependencies="required-after:growthcraft_cellar", acceptedMinecraftVersions="[1.12.2]")
public class GrowthcraftBees {
    static final String CLIENT_PROXY_CLASS = "growthcraft.bees.client.ClientProxy";
    static final String SERVER_PROXY_CLASS = "growthcraft.bees.common.CommonProxy";
    @Mod.Instance(value="growthcraft_bees")
    public static GrowthcraftBees instance;
    @SidedProxy(serverSide="growthcraft.bees.common.CommonProxy", clientSide="growthcraft.bees.client.ClientProxy")
    public static CommonProxy proxy;
    public static GrowthcraftGuiProvider guiProvider;
    public static final UserBeesConfig userBeesConfig;
    public static final UserFlowersConfig userFlowersConfig;
    public static Logger logger;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        GrowthcraftBeesConfig.preInit(event);
        logger = event.getModLog();
        Init.preInitItems();
        Init.preInitBlocks();
        Init.preInitFluids();
        userBeesConfig.setConfigFile(event.getModConfigurationDirectory(), "growthcraft/bees/bees.json");
        userBeesConfig.preInit();
        userBeesConfig.register();
        userFlowersConfig.setConfigFile(event.getModConfigurationDirectory(), "growthcraft/bees/flowers.json");
        userFlowersConfig.preInit();
        Init.initUserApisDefaults();
        userFlowersConfig.register();
        proxy.preInit();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        userBeesConfig.init();
        userFlowersConfig.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)"growthcraft_bees", (IGuiHandler)guiProvider);
        proxy.init();
        Init.initBoozes();
        Init.registerRecipes();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        userBeesConfig.loadUserConfig();
        userBeesConfig.postInit();
        userFlowersConfig.loadUserConfig();
        userFlowersConfig.postInit();
        Init.registerItemOres();
        Init.registerFluidOres();
    }

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerBlocks((IForgeRegistry<Block>)registry);
        Init.registerFluidBlocks((IForgeRegistry<Block>)registry);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerItems((IForgeRegistry<Item>)registry);
        Init.registerBlockItems((IForgeRegistry<Item>)registry);
        Init.registerFluidItems((IForgeRegistry<Item>)registry);
        proxy.postRegisterItems();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        Init.registerItemRenders();
        Init.registerBlockRender();
        Init.registerFluidRender();
    }

    @SubscribeEvent
    public void registerCraftingRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerCraftingRecipes((IForgeRegistry<IRecipe>)registry);
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent evt) {
        Init.lootLoad(evt);
    }

    static {
        guiProvider = new GrowthcraftGuiProvider();
        userBeesConfig = new UserBeesConfig();
        userFlowersConfig = new UserFlowersConfig();
    }
}

