/*
 * Decompiled with CFR 0.152.
 */
package openblocks;

import codechicken.nei.api.IConfigureNEI;
import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;
import openblocks.OpenBlocks;
import openmods.Log;

public class NEIOpenBlocksConfig
implements IConfigureNEI {
    private static final String API = "codechicken.nei.api.API";
    private static final String HIDE_ITEM = "hideItem";
    private Method hideItem;

    public void loadConfig() {
        if (OpenBlocks.Blocks.canvasGlass != null) {
            this.API$hideItem(new ItemStack(OpenBlocks.Blocks.canvasGlass));
        }
        if (OpenBlocks.Items.heightMap != null) {
            this.API$hideItem(new ItemStack(OpenBlocks.Items.heightMap, 1, Short.MAX_VALUE));
        }
        Log.info((String)"OpenBlocks NEI Integration loaded successfully", (Object[])new Object[0]);
    }

    public String getName() {
        return "OpenBlocks-ItemHider";
    }

    public String getVersion() {
        return "0.0";
    }

    private void API$hideItem(ItemStack stack) {
        try {
            if (this.hideItem == null) {
                this.hideItem = Class.forName(API).getMethod(HIDE_ITEM, ItemStack.class);
            }
            this.hideItem.invoke(null, stack);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

