/*
 * Decompiled with CFR 0.152.
 */
package lumien.loadingprofiler.profiler;

import java.util.ArrayList;
import lumien.loadingprofiler.profiler.ModProfileResult;
import lumien.loadingprofiler.profiler.TransformerProfiler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModProfiler {
    Logger logger = LogManager.getLogger((String)"LoadingProfiler");
    static ModProfiler INSTANCE;
    public ArrayList<ModProfileResult> constructing = new ArrayList();
    public ArrayList<ModProfileResult> preInit = new ArrayList();
    public ArrayList<ModProfileResult> init = new ArrayList();
    public ArrayList<ModProfileResult> postInit = new ArrayList();
    ModContainer currentContainer;
    long savedTime;

    private ModProfiler() {
    }

    private void logPre(FMLEvent event, ModContainer modContainer) {
        this.currentContainer = modContainer;
        this.savedTime = System.nanoTime();
    }

    private void logPost(FMLEvent event, ModContainer modContainer) {
        TransformerProfiler transformerProfiler = TransformerProfiler.getProfiler();
        if (transformerProfiler.transformerRan) {
            transformerProfiler.transformerRan = false;
            this.savedTime += transformerProfiler.nestedTime;
        }
        if (this.currentContainer != modContainer) {
            this.logger.log(Level.INFO, "Changed Mod Container WOT");
        } else if (event instanceof FMLConstructionEvent) {
            this.constructing.add(new ModProfileResult(modContainer, System.nanoTime() - this.savedTime));
        } else if (event instanceof FMLPreInitializationEvent) {
            this.preInit.add(new ModProfileResult(modContainer, System.nanoTime() - this.savedTime));
        } else if (event instanceof FMLInitializationEvent) {
            this.init.add(new ModProfileResult(modContainer, System.nanoTime() - this.savedTime));
        } else if (event instanceof FMLPostInitializationEvent) {
            this.postInit.add(new ModProfileResult(modContainer, System.nanoTime() - this.savedTime));
        }
    }

    public static void preEvent(FMLEvent event, ModContainer modContainer) {
        ModProfiler.getProfiler().logPre(event, modContainer);
    }

    public static void postEvent(FMLEvent event, ModContainer modContainer) {
        ModProfiler.getProfiler().logPost(event, modContainer);
    }

    public static ModProfiler getProfiler() {
        if (INSTANCE == null) {
            INSTANCE = new ModProfiler();
        }
        return INSTANCE;
    }
}

