/*
 * Decompiled with CFR 0.152.
 */
package lumien.loadingprofiler.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    Logger logger = LogManager.getLogger((String)"LoadingProfiler");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        if (classNode.superName.equals("net/minecraftforge/fml/common/asm/ASMTransformerWrapper$TransformerWrapper")) {
            return this.patchClassTransformer(basicClass);
        }
        if (transformedName.equals("net.minecraftforge.fml.common.LoadController")) {
            return this.patchLoadController(basicClass);
        }
        return basicClass;
    }

    private byte[] patchClassTransformer(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Patching Class Transformer: " + classNode.name);
        ClassWriter writer = new ClassWriter(2);
        classNode.accept((ClassVisitor)writer);
        MethodVisitor mv = writer.visitMethod(1, "transform", "(Ljava/lang/String;Ljava/lang/String;[B)[B", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(11, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(184, "lumien/loadingprofiler/profiler/TransformerProfiler", "preTransform", "(Lnet/minecraftforge/fml/common/asm/ASMTransformerWrapper$TransformerWrapper;Ljava/lang/String;)V", false);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(12, l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, "net/minecraftforge/fml/common/asm/ASMTransformerWrapper$TransformerWrapper", "transform", "(Ljava/lang/String;Ljava/lang/String;[B)[B", false);
        mv.visitVarInsn(58, 4);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(13, l2);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(184, "lumien/loadingprofiler/profiler/TransformerProfiler", "postTransform", "(Lnet/minecraftforge/fml/common/asm/ASMTransformerWrapper$TransformerWrapper;Ljava/lang/String;)V", false);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLineNumber(14, l3);
        mv.visitVarInsn(25, 4);
        mv.visitInsn(176);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "L" + classNode.name + ";", null, l0, l4, 0);
        mv.visitLocalVariable("name", "Ljava/lang/String;", null, l0, l4, 1);
        mv.visitLocalVariable("transformedName", "Ljava/lang/String;", null, l0, l4, 2);
        mv.visitLocalVariable("basicClass", "[B", null, l0, l4, 3);
        mv.visitLocalVariable("superTransform", "[B", null, l2, l4, 4);
        mv.visitMaxs(4, 5);
        mv.visitEnd();
        return writer.toByteArray();
    }

    private byte[] patchLoadController(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.INFO, "Patching FML Load Controller");
        this.logger.log(Level.INFO, "If you get any crashes while using this mod try to remove Loading Profiler before reporting them to the respective author.");
        MethodNode propogate = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals("propogateStateMessage")) continue;
            propogate = mn;
            break;
        }
        if (propogate != null) {
            this.logger.log(Level.DEBUG, "- Found propogateStateMessage");
            for (int i = 0; i < propogate.instructions.size(); ++i) {
                AbstractInsnNode node = propogate.instructions.get(i);
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)node;
                if (!min.name.equals("sendEventToModContainer")) continue;
                this.logger.log(Level.DEBUG, "- Found sendEventToModContainer");
                InsnList insertBefore = new InsnList();
                InsnList insertAfter = new InsnList();
                insertBefore.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insertBefore.add((AbstractInsnNode)new VarInsnNode(25, 4));
                insertBefore.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/loadingprofiler/profiler/ModProfiler", "preEvent", "(Lnet/minecraftforge/fml/common/event/FMLEvent;Lnet/minecraftforge/fml/common/ModContainer;)V", false));
                insertAfter.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insertAfter.add((AbstractInsnNode)new VarInsnNode(25, 4));
                insertAfter.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/loadingprofiler/profiler/ModProfiler", "postEvent", "(Lnet/minecraftforge/fml/common/event/FMLEvent;Lnet/minecraftforge/fml/common/ModContainer;)V", false));
                propogate.instructions.insertBefore((AbstractInsnNode)min, insertBefore);
                propogate.instructions.insert((AbstractInsnNode)min, insertAfter);
                break;
            }
        } else {
            this.logger.log(Level.DEBUG, "- Did not find propogateStateMessage");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchDummyClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.INFO, "Found Dummy Class: " + classNode.name);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

