/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.DebugStringsKt;
import kotlinx.coroutines.TimeSource;
import kotlinx.coroutines.TimeSourceKt;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.internal.SystemPropsKt;
import kotlinx.coroutines.scheduling.CoroutineScheduler$WhenMappings;
import kotlinx.coroutines.scheduling.GlobalQueue;
import kotlinx.coroutines.scheduling.NonBlockingContext;
import kotlinx.coroutines.scheduling.Task;
import kotlinx.coroutines.scheduling.TaskContext;
import kotlinx.coroutines.scheduling.TaskImpl;
import kotlinx.coroutines.scheduling.TaskMode;
import kotlinx.coroutines.scheduling.TasksKt;
import kotlinx.coroutines.scheduling.WorkQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0000\u0018\u0000 U2\u00020\u00012\u00020\u0002:\u0003UVWB+\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0006H\u0082\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u001c\u001a\u00020\u00192\n\u0010\u0016\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0018\u0010\u001d\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0006H\u0082\b\u00a2\u0006\u0004\b\u001d\u0010\u000eJ\u0015\u0010\u001f\u001a\b\u0018\u00010\u001eR\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010!\u001a\u00020\u000fH\u0082\b\u00a2\u0006\u0004\b!\u0010\u0011J\u0010\u0010\"\u001a\u00020\u0003H\u0082\b\u00a2\u0006\u0004\b\"\u0010\u0013J-\u0010%\u001a\u00020\u000f2\n\u0010\u0016\u001a\u00060\u0014j\u0002`\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J\u001b\u0010(\u001a\u00020\u000f2\n\u0010'\u001a\u00060\u0014j\u0002`\u0015H\u0016\u00a2\u0006\u0004\b(\u0010)J\u0010\u0010*\u001a\u00020\u000fH\u0082\b\u00a2\u0006\u0004\b*\u0010\u0011J\u0010\u0010+\u001a\u00020\u0003H\u0082\b\u00a2\u0006\u0004\b+\u0010\u0013J\u001b\u0010-\u001a\u00020\u00032\n\u0010,\u001a\u00060\u001eR\u00020\u0000H\u0002\u00a2\u0006\u0004\b-\u0010.J\u0015\u0010/\u001a\b\u0018\u00010\u001eR\u00020\u0000H\u0002\u00a2\u0006\u0004\b/\u0010 J\u001b\u00100\u001a\u00020\u000f2\n\u0010,\u001a\u00060\u001eR\u00020\u0000H\u0002\u00a2\u0006\u0004\b0\u00101J+\u00104\u001a\u00020\u000f2\n\u0010,\u001a\u00060\u001eR\u00020\u00002\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b4\u00105J\u000f\u00106\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b6\u0010\u0011J\u0017\u00108\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b8\u00109J\u0015\u0010;\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u0006\u00a2\u0006\u0004\b;\u0010<J\u001f\u0010=\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00192\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b=\u0010>J\u000f\u0010?\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b?\u0010@J\u000f\u0010A\u001a\u00020#H\u0002\u00a2\u0006\u0004\bA\u0010BR\u0017\u0010\r\u001a\u00020\u00038\u00c2\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0013R\u0016\u0010\u0004\u001a\u00020\u00038\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010DR\u0016\u0010F\u001a\u00020E8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0017\u0010\u001d\u001a\u00020\u00038\u00c2\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0013R\u0016\u0010J\u001a\u00020I8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0016\u0010\u0007\u001a\u00020\u00068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010LR\u0016\u0010M\u001a\u00020#8B@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010BR\u0016\u0010\u0005\u001a\u00020\u00038\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010DR\u0016\u0010O\u001a\u00020N8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bO\u0010PR\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010QR\"\u0010S\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u001eR\u00020\u00000R8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010T\u00a8\u0006X"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "Ljava/util/concurrent/Executor;", "Ljava/io/Closeable;", "", "corePoolSize", "maxPoolSize", "", "idleWorkerKeepAliveNs", "", "schedulerName", "<init>", "(IIJLjava/lang/String;)V", "state", "blockingWorkers", "(J)I", "", "close", "()V", "createNewWorker", "()I", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "block", "Lkotlinx/coroutines/scheduling/TaskContext;", "taskContext", "Lkotlinx/coroutines/scheduling/Task;", "createTask$kotlinx_coroutines_core", "(Ljava/lang/Runnable;Lkotlinx/coroutines/scheduling/TaskContext;)Lkotlinx/coroutines/scheduling/Task;", "createTask", "createdWorkers", "Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "currentWorker", "()Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "decrementBlockingWorkers", "decrementCreatedWorkers", "", "fair", "dispatch", "(Ljava/lang/Runnable;Lkotlinx/coroutines/scheduling/TaskContext;Z)V", "command", "execute", "(Ljava/lang/Runnable;)V", "incrementBlockingWorkers", "incrementCreatedWorkers", "worker", "parkedWorkersStackNextIndex", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;)I", "parkedWorkersStackPop", "parkedWorkersStackPush", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;)V", "oldIndex", "newIndex", "parkedWorkersStackTopUpdate", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;II)V", "requestCpuWorker", "task", "runSafely", "(Lkotlinx/coroutines/scheduling/Task;)V", "timeout", "shutdown", "(J)V", "submitToLocalQueue", "(Lkotlinx/coroutines/scheduling/Task;Z)I", "toString", "()Ljava/lang/String;", "tryUnpark", "()Z", "getBlockingWorkers", "I", "Ljava/util/concurrent/Semaphore;", "cpuPermits", "Ljava/util/concurrent/Semaphore;", "getCreatedWorkers", "Lkotlinx/coroutines/scheduling/GlobalQueue;", "globalQueue", "Lkotlinx/coroutines/scheduling/GlobalQueue;", "J", "isTerminated", "Ljava/util/Random;", "random", "Ljava/util/Random;", "Ljava/lang/String;", "", "workers", "[Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "Companion", "Worker", "WorkerState", "kotlinx-coroutines-core"})
public final class CoroutineScheduler
implements Executor,
Closeable {
    private final GlobalQueue globalQueue;
    private final Semaphore cpuPermits;
    private volatile long parkedWorkersStack;
    private static final AtomicLongFieldUpdater parkedWorkersStack$FU;
    private final Worker[] workers;
    volatile long controlState;
    static final AtomicLongFieldUpdater controlState$FU;
    private final Random random;
    private volatile int _isTerminated;
    private static final AtomicIntegerFieldUpdater _isTerminated$FU;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final long idleWorkerKeepAliveNs;
    private final String schedulerName;
    private static final int MAX_SPINS;
    private static final int MAX_YIELDS;
    private static final int MAX_PARK_TIME_NS;
    private static final int MIN_PARK_TIME_NS;
    private static final Symbol NOT_IN_STACK;
    private static final int ADDED = -1;
    private static final int ADDED_REQUIRES_HELP = 0;
    private static final int NOT_ADDED = 1;
    private static final int FORBIDDEN = -1;
    private static final int ALLOWED = 0;
    private static final int TERMINATED = 1;
    private static final int BLOCKING_SHIFT = 21;
    private static final long CREATED_MASK = 0x1FFFFFL;
    private static final long BLOCKING_MASK = 4398044413952L;
    public static final int MIN_SUPPORTED_POOL_SIZE = 1;
    public static final int MAX_SUPPORTED_POOL_SIZE = 0x1FFFFE;
    private static final long PARKED_INDEX_MASK = 0x1FFFFFL;
    private static final long PARKED_VERSION_MASK = -2097152L;
    private static final long PARKED_VERSION_INC = 0x200000L;
    public static final Companion Companion;

    private final void parkedWorkersStackTopUpdate(Worker worker, int oldIndex, int newIndex) {
        long updVersion;
        long top;
        int n;
        int updIndex;
        CoroutineScheduler $this$loop$iv = this;
        boolean $i$f$loop = false;
        do {
            top = $this$loop$iv.parkedWorkersStack;
            boolean bl = false;
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            if (index == oldIndex) {
                if (newIndex == 0) {
                    n = this.parkedWorkersStackNextIndex(worker);
                    continue;
                }
                n = newIndex;
                continue;
            }
            n = index;
        } while ((updIndex = n) < 0 || !parkedWorkersStack$FU.compareAndSet(this, top, updVersion | (long)updIndex));
    }

    private final void parkedWorkersStackPush(Worker worker) {
        int updIndex;
        long updVersion;
        long top;
        if (worker.getNextParkedWorker() != NOT_IN_STACK) {
            return;
        }
        CoroutineScheduler $this$loop$iv = this;
        boolean $i$f$loop = false;
        do {
            top = $this$loop$iv.parkedWorkersStack;
            boolean bl = false;
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            updIndex = worker.getIndexInArray();
            boolean bl2 = false;
            if (DebugKt.getASSERTIONS_ENABLED()) {
                boolean bl3 = false;
                if (!(updIndex != 0)) {
                    throw (Throwable)((Object)new AssertionError());
                }
            }
            worker.setNextParkedWorker(this.workers[index]);
        } while (!parkedWorkersStack$FU.compareAndSet(this, top, updVersion | (long)updIndex));
    }

    private final Worker parkedWorkersStackPop() {
        long updVersion;
        long top;
        Worker worker;
        int updIndex;
        CoroutineScheduler $this$loop$iv = this;
        boolean $i$f$loop = false;
        do {
            top = $this$loop$iv.parkedWorkersStack;
            boolean bl = false;
            int index = (int)(top & 0x1FFFFFL);
            if (this.workers[index] == null) {
                return null;
            }
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
        } while ((updIndex = this.parkedWorkersStackNextIndex(worker)) < 0 || !parkedWorkersStack$FU.compareAndSet(this, top, updVersion | (long)updIndex));
        worker.setNextParkedWorker(NOT_IN_STACK);
        return worker;
    }

    private final int parkedWorkersStackNextIndex(Worker worker) {
        Object next = worker.getNextParkedWorker();
        while (next != NOT_IN_STACK) {
            if (next == null) {
                return 0;
            }
            Worker nextWorker = (Worker)next;
            int updIndex = nextWorker.getIndexInArray();
            if (updIndex != 0) {
                return updIndex;
            }
            next = nextWorker.getNextParkedWorker();
        }
        return -1;
    }

    private final int getCreatedWorkers() {
        int $i$f$getCreatedWorkers = 0;
        return (int)(this.controlState & 0x1FFFFFL);
    }

    private final int getBlockingWorkers() {
        int $i$f$getBlockingWorkers = 0;
        return (int)((this.controlState & 0x3FFFFE00000L) >> 21);
    }

    private final int createdWorkers(long state) {
        int $i$f$createdWorkers = 0;
        return (int)(state & 0x1FFFFFL);
    }

    private final int blockingWorkers(long state) {
        int $i$f$blockingWorkers = 0;
        return (int)((state & 0x3FFFFE00000L) >> 21);
    }

    private final int incrementCreatedWorkers() {
        int $i$f$incrementCreatedWorkers = 0;
        CoroutineScheduler coroutineScheduler = this;
        long state$iv = controlState$FU.incrementAndGet(this);
        boolean $i$f$createdWorkers = false;
        return (int)(state$iv & 0x1FFFFFL);
    }

    private final int decrementCreatedWorkers() {
        int $i$f$decrementCreatedWorkers = 0;
        CoroutineScheduler coroutineScheduler = this;
        long state$iv = controlState$FU.getAndDecrement(this);
        boolean $i$f$createdWorkers = false;
        return (int)(state$iv & 0x1FFFFFL);
    }

    private final void incrementBlockingWorkers() {
        int $i$f$incrementBlockingWorkers = 0;
        controlState$FU.addAndGet(this, 0x200000L);
    }

    private final void decrementBlockingWorkers() {
        int $i$f$decrementBlockingWorkers = 0;
        controlState$FU.addAndGet(this, -2097152L);
    }

    private final boolean isTerminated() {
        return this._isTerminated != 0;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkParameterIsNotNull(command, "command");
        CoroutineScheduler.dispatch$default(this, command, null, false, 6, null);
    }

    @Override
    public void close() {
        this.shutdown(10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void shutdown(long timeout) {
        if (!_isTerminated$FU.compareAndSet(this, 0, 1)) {
            return;
        }
        Worker currentWorker = this.currentWorker();
        Worker[] lock$iv22 = this.workers;
        int $i$f$synchronized = 0;
        boolean bl = false;
        int n = 0;
        synchronized (lock$iv22) {
            boolean bl2 = false;
            CoroutineScheduler this_$iv = this;
            boolean $i$f$getCreatedWorkers = false;
            n = (int)(this_$iv.controlState & 0x1FFFFFL);
        }
        int created = n;
        int lock$iv22 = 1;
        $i$f$synchronized = created;
        if (lock$iv22 <= $i$f$synchronized) {
            while (true) {
                Worker worker;
                void i;
                if (this.workers[i] == null) {
                    Intrinsics.throwNpe();
                }
                if (worker != currentWorker) {
                    while (worker.isAlive()) {
                        LockSupport.unpark(worker);
                        worker.join(timeout);
                    }
                    WorkerState state = worker.getState();
                    boolean bl3 = false;
                    if (DebugKt.getASSERTIONS_ENABLED()) {
                        boolean bl4 = false;
                        if (!(state == WorkerState.TERMINATED)) {
                            throw (Throwable)((Object)new AssertionError());
                        }
                    }
                    worker.getLocalQueue().offloadAllWork$kotlinx_coroutines_core(this.globalQueue);
                }
                if (i == $i$f$synchronized) break;
                ++i;
            }
        }
        this.globalQueue.close();
        while (true) {
            Runnable runnable;
            if ((runnable = currentWorker) == null || (runnable = runnable.findTask$kotlinx_coroutines_core()) == null) {
                runnable = (Task)this.globalQueue.removeFirstOrNull();
            }
            if (runnable == null) {
                break;
            }
            Runnable task = runnable;
            this.runSafely((Task)task);
        }
        Worker worker = currentWorker;
        if (worker != null) {
            worker.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.TERMINATED);
        }
        boolean bl5 = false;
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl6 = false;
            if (!(this.cpuPermits.availablePermits() == this.corePoolSize)) {
                throw (Throwable)((Object)new AssertionError());
            }
        }
        this.parkedWorkersStack = 0L;
        this.controlState = 0L;
    }

    public final void dispatch(@NotNull Runnable block, @NotNull TaskContext taskContext, boolean fair) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        Intrinsics.checkParameterIsNotNull(taskContext, "taskContext");
        boolean bl = false;
        TimeSource timeSource = TimeSourceKt.getTimeSource();
        if (timeSource != null) {
            timeSource.trackTask();
        }
        Task task = this.createTask$kotlinx_coroutines_core(block, taskContext);
        switch (this.submitToLocalQueue(task, fair)) {
            case -1: {
                return;
            }
            case 1: {
                if (!this.globalQueue.addLast(task)) {
                    throw (Throwable)new RejectedExecutionException(this.schedulerName + " was terminated");
                }
                this.requestCpuWorker();
                break;
            }
            default: {
                this.requestCpuWorker();
            }
        }
    }

    public static /* synthetic */ void dispatch$default(CoroutineScheduler coroutineScheduler, Runnable runnable, TaskContext taskContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            taskContext = NonBlockingContext.INSTANCE;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        coroutineScheduler.dispatch(runnable, taskContext, bl);
    }

    @NotNull
    public final Task createTask$kotlinx_coroutines_core(@NotNull Runnable block, @NotNull TaskContext taskContext) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        Intrinsics.checkParameterIsNotNull(taskContext, "taskContext");
        long nanoTime = TasksKt.schedulerTimeSource.nanoTime();
        if (block instanceof Task) {
            ((Task)block).submissionTime = nanoTime;
            ((Task)block).taskContext = taskContext;
            return (Task)block;
        }
        return new TaskImpl(block, nanoTime, taskContext);
    }

    private final void requestCpuWorker() {
        if (this.cpuPermits.availablePermits() == 0) {
            this.tryUnpark();
            return;
        }
        if (this.tryUnpark()) {
            return;
        }
        long state = this.controlState;
        CoroutineScheduler this_$iv = this;
        boolean $i$f$createdWorkers = false;
        int created = (int)(state & 0x1FFFFFL);
        CoroutineScheduler this_$iv2 = this;
        boolean $i$f$blockingWorkers = false;
        int blocking = (int)((state & 0x3FFFFE00000L) >> 21);
        int cpuWorkers = created - blocking;
        if (cpuWorkers < this.corePoolSize) {
            int newCpuWorkers = this.createNewWorker();
            if (newCpuWorkers == 1 && this.corePoolSize > 1) {
                this.createNewWorker();
            }
            if (newCpuWorkers > 0) {
                return;
            }
        }
        this.tryUnpark();
    }

    private final boolean tryUnpark() {
        Worker worker;
        boolean wasParking;
        do {
            if (this.parkedWorkersStackPop() == null) {
                return false;
            }
            worker.idleResetBeforeUnpark();
            wasParking = worker.isParking();
            LockSupport.unpark(worker);
        } while (!wasParking || !worker.tryForbidTermination());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final int createNewWorker() {
        Worker[] lock$iv = this.workers;
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            void this_$iv;
            int cpuWorkers;
            block10: {
                int created;
                block9: {
                    block8: {
                        boolean bl3 = false;
                        if (!this.isTerminated()) break block8;
                        int n = -1;
                        return n;
                    }
                    long state = this.controlState;
                    CoroutineScheduler this_$iv2 = this;
                    boolean $i$f$createdWorkers = false;
                    created = (int)(state & 0x1FFFFFL);
                    CoroutineScheduler this_$iv3 = this;
                    boolean $i$f$blockingWorkers = false;
                    int blocking = (int)((state & 0x3FFFFE00000L) >> 21);
                    cpuWorkers = created - blocking;
                    if (cpuWorkers < this.corePoolSize) break block9;
                    int n = 0;
                    return n;
                }
                if (created < this.maxPoolSize && this.cpuPermits.availablePermits() != 0) break block10;
                int n = 0;
                return n;
            }
            CoroutineScheduler this_$iv22 = this;
            boolean $i$f$getCreatedWorkers22 = false;
            int newIndex = (int)(this_$iv22.controlState & 0x1FFFFFL) + 1;
            boolean this_$iv22 = newIndex > 0 && this.workers[newIndex] == null;
            $i$f$getCreatedWorkers22 = false;
            boolean bl4 = false;
            bl4 = false;
            boolean bl5 = false;
            if (!this_$iv22) {
                boolean bl6 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Object $i$f$getCreatedWorkers22 = new Worker(newIndex);
            bl4 = false;
            bl5 = false;
            Worker $this$apply = $i$f$getCreatedWorkers22;
            boolean bl7 = false;
            $this$apply.start();
            Worker worker = $i$f$getCreatedWorkers22;
            $i$f$getCreatedWorkers22 = this;
            int n = newIndex;
            boolean $i$f$incrementCreatedWorkers = false;
            void var15_27 = this_$iv;
            long state$iv$iv = controlState$FU.incrementAndGet(this_$iv);
            boolean $i$f$createdWorkers = false;
            int n2 = (int)(state$iv$iv & 0x1FFFFFL);
            boolean bl8 = n == n2;
            bl4 = false;
            boolean bl9 = false;
            bl9 = false;
            boolean bl10 = false;
            if (!bl8) {
                boolean bl11 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.workers[newIndex] = worker;
            int n3 = cpuWorkers + 1;
            return n3;
        }
    }

    private final int submitToLocalQueue(Task task, boolean fair) {
        boolean noOffloadingHappened;
        Worker worker = this.currentWorker();
        if (worker == null) {
            return 1;
        }
        Worker worker2 = worker;
        if (worker2.getState() == WorkerState.TERMINATED) {
            return 1;
        }
        int result2 = -1;
        if (task.getMode() == TaskMode.NON_BLOCKING) {
            if (worker2.isBlocking()) {
                result2 = 0;
            } else {
                boolean hasPermit = worker2.tryAcquireCpuPermit();
                if (!hasPermit) {
                    return 1;
                }
            }
        }
        boolean bl = noOffloadingHappened = fair ? worker2.getLocalQueue().addLast(task, this.globalQueue) : worker2.getLocalQueue().add(task, this.globalQueue);
        if (noOffloadingHappened) {
            if (worker2.getLocalQueue().getBufferSize$kotlinx_coroutines_core() > TasksKt.QUEUE_SIZE_OFFLOAD_THRESHOLD) {
                return 0;
            }
            return result2;
        }
        return 0;
    }

    private final Worker currentWorker() {
        Worker worker;
        Thread thread2 = Thread.currentThread();
        if (!(thread2 instanceof Worker)) {
            thread2 = null;
        }
        Worker worker2 = (Worker)thread2;
        if (worker2 != null) {
            Worker worker3 = worker2;
            boolean bl = false;
            boolean bl2 = false;
            Worker it = worker3;
            boolean bl3 = false;
            worker = Intrinsics.areEqual(it.getScheduler(), this) ? worker3 : null;
        } else {
            worker = null;
        }
        return worker;
    }

    @NotNull
    public String toString() {
        int parkedWorkers = 0;
        int blockingWorkers = 0;
        int cpuWorkers = 0;
        int retired = 0;
        int terminated = 0;
        boolean bl = false;
        ArrayList queueSizes = new ArrayList();
        block7: for (Worker worker : this.workers) {
            if (worker == null) continue;
            int queueSize = worker.getLocalQueue().size$kotlinx_coroutines_core();
            switch (CoroutineScheduler$WhenMappings.$EnumSwitchMapping$0[worker.getState().ordinal()]) {
                case 1: {
                    ++parkedWorkers;
                    continue block7;
                }
                case 2: {
                    ++blockingWorkers;
                    Collection collection = queueSizes;
                    String string = String.valueOf(queueSize) + "b";
                    boolean bl2 = false;
                    collection.add(string);
                    continue block7;
                }
                case 3: {
                    ++cpuWorkers;
                    Collection collection = queueSizes;
                    String string = String.valueOf(queueSize) + "c";
                    boolean bl2 = false;
                    collection.add(string);
                    continue block7;
                }
                case 4: {
                    ++retired;
                    if (queueSize <= 0) continue block7;
                    Collection collection = queueSizes;
                    String string = String.valueOf(queueSize) + "r";
                    boolean bl2 = false;
                    collection.add(string);
                    continue block7;
                }
                case 5: {
                    ++terminated;
                }
            }
        }
        long state = this.controlState;
        CoroutineScheduler coroutineScheduler = this;
        StringBuilder stringBuilder = new StringBuilder().append(this.schedulerName).append('@').append(DebugStringsKt.getHexAddress(this)).append('[').append("Pool Size {").append("core = ").append(this.corePoolSize).append(", ").append("max = ").append(this.maxPoolSize).append("}, ").append("Worker States {").append("CPU = ").append(cpuWorkers).append(", ").append("blocking = ").append(blockingWorkers).append(", ").append("parked = ").append(parkedWorkers).append(", ").append("retired = ").append(retired).append(", ").append("terminated = ").append(terminated).append("}, ").append("running workers queues = ").append(queueSizes).append(", ").append("global queue size = ").append(this.globalQueue.getSize()).append(", ").append("Control State Workers {").append("created = ");
        boolean $i$f$createdWorkers = false;
        int n = (int)(state & 0x1FFFFFL);
        CoroutineScheduler coroutineScheduler2 = this;
        stringBuilder = stringBuilder.append(n).append(", ").append("blocking = ");
        boolean $i$f$blockingWorkers = false;
        n = (int)((state & 0x3FFFFE00000L) >> 21);
        return stringBuilder.append(n).append('}').append("]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runSafely(Task task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            Thread thread2;
            Thread thread3 = thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread3, "thread");
            thread3.getUncaughtExceptionHandler().uncaughtException(thread2, e);
        }
        finally {
            boolean bl = false;
            TimeSource timeSource = TimeSourceKt.getTimeSource();
            if (timeSource != null) {
                timeSource.unTrackTask();
            }
        }
    }

    public CoroutineScheduler(int corePoolSize, int maxPoolSize, long idleWorkerKeepAliveNs, @NotNull String schedulerName) {
        Intrinsics.checkParameterIsNotNull(schedulerName, "schedulerName");
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.idleWorkerKeepAliveNs = idleWorkerKeepAliveNs;
        this.schedulerName = schedulerName;
        boolean bl = this.corePoolSize >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Core pool size " + this.corePoolSize + " should be at least 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.maxPoolSize >= this.corePoolSize;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Max pool size " + this.maxPoolSize + " should be greater than or equals to core pool size " + this.corePoolSize;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.maxPoolSize <= 0x1FFFFE;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Max pool size " + this.maxPoolSize + " should not exceed maximal supported number of threads 2097150";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.idleWorkerKeepAliveNs > 0L;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl7 = false;
            String string = "Idle worker keep alive time " + this.idleWorkerKeepAliveNs + " must be positive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.globalQueue = new GlobalQueue();
        this.cpuPermits = new Semaphore(this.corePoolSize, false);
        this.parkedWorkersStack = 0L;
        this.workers = new Worker[this.maxPoolSize + 1];
        this.controlState = 0L;
        this.random = new Random();
        this._isTerminated = 0;
    }

    public /* synthetic */ CoroutineScheduler(int n, int n2, long l, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            l = TasksKt.IDLE_WORKER_KEEP_ALIVE_NS;
        }
        if ((n3 & 8) != 0) {
            string = "DefaultDispatcher";
        }
        this(n, n2, l, string);
    }

    public static final /* synthetic */ void access$incrementBlockingWorkers(CoroutineScheduler $this) {
        $this.incrementBlockingWorkers();
    }

    public static final /* synthetic */ void access$decrementBlockingWorkers(CoroutineScheduler $this) {
        $this.decrementBlockingWorkers();
    }

    public static final /* synthetic */ int access$decrementCreatedWorkers(CoroutineScheduler $this) {
        return $this.decrementCreatedWorkers();
    }

    public static final /* synthetic */ int access$createdWorkers(CoroutineScheduler $this, long state) {
        return $this.createdWorkers(state);
    }

    static {
        Companion = new Companion(null);
        MAX_SPINS = SystemPropsKt.systemProp$default("kotlinx.coroutines.scheduler.spins", 1000, 1, 0, 8, null);
        MAX_YIELDS = MAX_SPINS + SystemPropsKt.systemProp$default("kotlinx.coroutines.scheduler.yields", 0, 0, 0, 8, null);
        MAX_PARK_TIME_NS = (int)TimeUnit.SECONDS.toNanos(1L);
        MIN_PARK_TIME_NS = (int)RangesKt.coerceAtMost(RangesKt.coerceAtLeast(TasksKt.WORK_STEALING_TIME_RESOLUTION_NS / (long)4, 10L), (long)MAX_PARK_TIME_NS);
        NOT_IN_STACK = new Symbol("NOT_IN_STACK");
        parkedWorkersStack$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "parkedWorkersStack");
        controlState$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "controlState");
        _isTerminated$FU = AtomicIntegerFieldUpdater.newUpdater(CoroutineScheduler.class, "_isTerminated");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0011\u0010\u001c\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0011\u0010\u001d\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001bJ\u0017\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u000bJ\r\u0010 \u001a\u00020\t\u00a2\u0006\u0004\b \u0010\u0014J\u0017\u0010$\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010%\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b%\u0010\u0014J\r\u0010&\u001a\u00020\u0010\u00a2\u0006\u0004\b&\u0010\u0012J\r\u0010'\u001a\u00020\u0010\u00a2\u0006\u0004\b'\u0010\u0012J\u0017\u0010,\u001a\u00020\u00102\u0006\u0010)\u001a\u00020(H\u0000\u00a2\u0006\u0004\b*\u0010+J\u0011\u0010-\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0004\b-\u0010\u001bJ\u000f\u0010.\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b.\u0010\u0014R*\u0010/\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00028\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0013\u00105\u001a\u00020\u00108F@\u0006\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0012R\u0013\u00106\u001a\u00020\u00108F@\u0006\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0012R\u0016\u00107\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0016\u00109\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u00100R\u0019\u0010;\u001a\u00020:8\u0006@\u0006\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>R$\u0010@\u001a\u0004\u0018\u00010?8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010A\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u0016\u0010F\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u00100R\u0016\u0010G\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u00100R\u0013\u0010K\u001a\u00020H8F@\u0006\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0016\u0010L\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u00100R\"\u0010M\u001a\u00020(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u0016\u0010S\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bS\u00108\u00a8\u0006T"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "Ljava/lang/Thread;", "", "index", "<init>", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler;I)V", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler;)V", "Lkotlinx/coroutines/scheduling/TaskMode;", "taskMode", "", "afterTask", "(Lkotlinx/coroutines/scheduling/TaskMode;)V", "", "taskSubmissionTime", "beforeTask", "(Lkotlinx/coroutines/scheduling/TaskMode;J)V", "", "blockingQuiescence", "()Z", "blockingWorkerIdle", "()V", "cpuWorkerIdle", "nanos", "doPark", "(J)Z", "Lkotlinx/coroutines/scheduling/Task;", "findTask$kotlinx_coroutines_core", "()Lkotlinx/coroutines/scheduling/Task;", "findTask", "findTaskWithCpuPermit", "mode", "idleReset", "idleResetBeforeUnpark", "upperBound", "nextInt$kotlinx_coroutines_core", "(I)I", "nextInt", "run", "tryAcquireCpuPermit", "tryForbidTermination", "Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "newState", "tryReleaseCpu$kotlinx_coroutines_core", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;)Z", "tryReleaseCpu", "trySteal", "tryTerminateWorker", "indexInArray", "I", "getIndexInArray", "()I", "setIndexInArray", "(I)V", "isBlocking", "isParking", "lastExhaustionTime", "J", "lastStealIndex", "Lkotlinx/coroutines/scheduling/WorkQueue;", "localQueue", "Lkotlinx/coroutines/scheduling/WorkQueue;", "getLocalQueue", "()Lkotlinx/coroutines/scheduling/WorkQueue;", "", "nextParkedWorker", "Ljava/lang/Object;", "getNextParkedWorker", "()Ljava/lang/Object;", "setNextParkedWorker", "(Ljava/lang/Object;)V", "parkTimeNs", "rngState", "Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "getScheduler", "()Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "scheduler", "spins", "state", "Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "getState", "()Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "setState", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;)V", "terminationDeadline", "kotlinx-coroutines-core"})
    public final class Worker
    extends Thread {
        private volatile int indexInArray;
        @NotNull
        private final WorkQueue localQueue;
        @NotNull
        private volatile WorkerState state;
        private volatile int terminationState;
        private static final AtomicIntegerFieldUpdater terminationState$FU = AtomicIntegerFieldUpdater.newUpdater(Worker.class, "terminationState");
        private long terminationDeadline;
        @Nullable
        private volatile Object nextParkedWorker;
        private long lastExhaustionTime;
        private volatile int spins;
        private int parkTimeNs;
        private int rngState;
        private int lastStealIndex;

        public final int getIndexInArray() {
            return this.indexInArray;
        }

        public final void setIndexInArray(int index) {
            this.setName(CoroutineScheduler.this.schedulerName + "-worker-" + (index == 0 ? "TERMINATED" : String.valueOf(index)));
            this.indexInArray = index;
        }

        @NotNull
        public final CoroutineScheduler getScheduler() {
            return CoroutineScheduler.this;
        }

        @NotNull
        public final WorkQueue getLocalQueue() {
            return this.localQueue;
        }

        @NotNull
        public final WorkerState getState() {
            return this.state;
        }

        public final void setState(@NotNull WorkerState workerState) {
            Intrinsics.checkParameterIsNotNull((Object)workerState, "<set-?>");
            this.state = workerState;
        }

        public final boolean isParking() {
            return this.state == WorkerState.PARKING;
        }

        public final boolean isBlocking() {
            return this.state == WorkerState.BLOCKING;
        }

        @Nullable
        public final Object getNextParkedWorker() {
            return this.nextParkedWorker;
        }

        public final void setNextParkedWorker(@Nullable Object object) {
            this.nextParkedWorker = object;
        }

        public final boolean tryForbidTermination() {
            boolean bl;
            int state = this.terminationState;
            if (state == 1) {
                bl = false;
            } else if (state == -1) {
                bl = false;
            } else if (state == 0) {
                bl = terminationState$FU.compareAndSet(this, 0, -1);
            } else {
                String string = "Invalid terminationState = " + state;
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return bl;
        }

        public final boolean tryAcquireCpuPermit() {
            boolean bl;
            if (this.state == WorkerState.CPU_ACQUIRED) {
                bl = true;
            } else if (CoroutineScheduler.this.cpuPermits.tryAcquire()) {
                this.state = WorkerState.CPU_ACQUIRED;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean tryReleaseCpu$kotlinx_coroutines_core(@NotNull WorkerState newState) {
            boolean hadCpu;
            Intrinsics.checkParameterIsNotNull((Object)newState, "newState");
            WorkerState previousState = this.state;
            boolean bl = hadCpu = previousState == WorkerState.CPU_ACQUIRED;
            if (hadCpu) {
                CoroutineScheduler.this.cpuPermits.release();
            }
            if (previousState != newState) {
                this.state = newState;
            }
            return hadCpu;
        }

        @Override
        public void run() {
            boolean wasIdle = false;
            while (!CoroutineScheduler.this.isTerminated() && this.state != WorkerState.TERMINATED) {
                Task task = this.findTask$kotlinx_coroutines_core();
                if (task == null) {
                    if (this.state == WorkerState.CPU_ACQUIRED) {
                        this.cpuWorkerIdle();
                    } else {
                        this.blockingWorkerIdle();
                    }
                    wasIdle = true;
                    continue;
                }
                TaskMode taskMode = task.getMode();
                if (wasIdle) {
                    this.idleReset(taskMode);
                    wasIdle = false;
                }
                this.beforeTask(taskMode, task.submissionTime);
                CoroutineScheduler.this.runSafely(task);
                this.afterTask(taskMode);
            }
            this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.TERMINATED);
        }

        private final void beforeTask(TaskMode taskMode, long taskSubmissionTime) {
            if (taskMode != TaskMode.NON_BLOCKING) {
                CoroutineScheduler this_$iv = CoroutineScheduler.this;
                boolean $i$f$incrementBlockingWorkers = false;
                controlState$FU.addAndGet(this_$iv, 0x200000L);
                if (this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.BLOCKING)) {
                    CoroutineScheduler.this.requestCpuWorker();
                }
                return;
            }
            if (CoroutineScheduler.this.cpuPermits.availablePermits() == 0) {
                return;
            }
            long now = TasksKt.schedulerTimeSource.nanoTime();
            if (now - taskSubmissionTime >= TasksKt.WORK_STEALING_TIME_RESOLUTION_NS && now - this.lastExhaustionTime >= TasksKt.WORK_STEALING_TIME_RESOLUTION_NS * (long)5) {
                this.lastExhaustionTime = now;
                CoroutineScheduler.this.requestCpuWorker();
            }
        }

        private final void afterTask(TaskMode taskMode) {
            if (taskMode != TaskMode.NON_BLOCKING) {
                CoroutineScheduler this_$iv = CoroutineScheduler.this;
                boolean $i$f$decrementBlockingWorkers = false;
                controlState$FU.addAndGet(this_$iv, -2097152L);
                WorkerState currentState = this.state;
                if (currentState != WorkerState.TERMINATED) {
                    boolean bl = false;
                    if (DebugKt.getASSERTIONS_ENABLED()) {
                        boolean bl2 = false;
                        if (!(currentState == WorkerState.BLOCKING)) {
                            throw (Throwable)((Object)new AssertionError());
                        }
                    }
                    this.state = WorkerState.RETIRING;
                }
            }
        }

        public final int nextInt$kotlinx_coroutines_core(int upperBound) {
            this.rngState ^= this.rngState << 13;
            this.rngState ^= this.rngState >> 17;
            this.rngState ^= this.rngState << 5;
            int mask = upperBound - 1;
            if ((mask & upperBound) == 0) {
                return this.rngState & mask;
            }
            return (this.rngState & Integer.MAX_VALUE) % upperBound;
        }

        private final void cpuWorkerIdle() {
            int spins = this.spins;
            if (spins <= MAX_YIELDS) {
                this.spins = spins + 1;
                if (spins >= MAX_SPINS) {
                    Thread.yield();
                }
            } else {
                if (this.parkTimeNs < MAX_PARK_TIME_NS) {
                    this.parkTimeNs = RangesKt.coerceAtMost(this.parkTimeNs * 3 >>> 1, MAX_PARK_TIME_NS);
                }
                this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.PARKING);
                this.doPark(this.parkTimeNs);
            }
        }

        private final void blockingWorkerIdle() {
            this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.PARKING);
            if (!this.blockingQuiescence()) {
                return;
            }
            this.terminationState = 0;
            if (this.terminationDeadline == 0L) {
                this.terminationDeadline = System.nanoTime() + CoroutineScheduler.this.idleWorkerKeepAliveNs;
            }
            if (!this.doPark(CoroutineScheduler.this.idleWorkerKeepAliveNs)) {
                return;
            }
            if (System.nanoTime() - this.terminationDeadline >= 0L) {
                this.terminationDeadline = 0L;
                this.tryTerminateWorker();
            }
        }

        private final boolean doPark(long nanos) {
            CoroutineScheduler.this.parkedWorkersStackPush(this);
            if (!this.blockingQuiescence()) {
                return false;
            }
            LockSupport.parkNanos(nanos);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void tryTerminateWorker() {
            Worker[] lock$iv = CoroutineScheduler.this.workers;
            boolean $i$f$synchronized = false;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (lock$iv) {
                boolean bl3 = false;
                if (CoroutineScheduler.this.isTerminated()) {
                    return;
                }
                if (CoroutineScheduler.this.getCreatedWorkers() <= CoroutineScheduler.this.corePoolSize) {
                    return;
                }
                if (!this.blockingQuiescence()) {
                    return;
                }
                if (!terminationState$FU.compareAndSet(this, 0, 1)) {
                    return;
                }
                int oldIndex = this.indexInArray;
                this.setIndexInArray(0);
                CoroutineScheduler.this.parkedWorkersStackTopUpdate(this, oldIndex, 0);
                CoroutineScheduler this_$iv = CoroutineScheduler.this;
                boolean $i$f$decrementCreatedWorkers = false;
                CoroutineScheduler coroutineScheduler = this_$iv;
                long state$iv$iv = controlState$FU.getAndDecrement(this_$iv);
                boolean $i$f$createdWorkers = false;
                int lastIndex = (int)(state$iv$iv & 0x1FFFFFL);
                if (lastIndex != oldIndex) {
                    Worker lastWorker;
                    Worker worker = CoroutineScheduler.this.workers[lastIndex];
                    if (worker == null) {
                        Intrinsics.throwNpe();
                    }
                    ((CoroutineScheduler)CoroutineScheduler.this).workers[oldIndex] = lastWorker = worker;
                    lastWorker.setIndexInArray(oldIndex);
                    CoroutineScheduler.this.parkedWorkersStackTopUpdate(lastWorker, lastIndex, oldIndex);
                }
                ((CoroutineScheduler)CoroutineScheduler.this).workers[lastIndex] = null;
                Unit unit = Unit.INSTANCE;
            }
            this.state = WorkerState.TERMINATED;
        }

        private final boolean blockingQuiescence() {
            Task task = CoroutineScheduler.this.globalQueue.removeFirstWithModeOrNull(TaskMode.PROBABLY_BLOCKING);
            if (task != null) {
                Task task2 = task;
                boolean bl = false;
                boolean bl2 = false;
                Task it = task2;
                boolean bl3 = false;
                this.localQueue.add(it, CoroutineScheduler.this.globalQueue);
                return false;
            }
            return true;
        }

        private final void idleReset(TaskMode mode) {
            this.terminationDeadline = 0L;
            this.lastStealIndex = 0;
            if (this.state == WorkerState.PARKING) {
                boolean bl = false;
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl2 = false;
                    if (!(mode == TaskMode.PROBABLY_BLOCKING)) {
                        throw (Throwable)((Object)new AssertionError());
                    }
                }
                this.state = WorkerState.BLOCKING;
                this.parkTimeNs = MIN_PARK_TIME_NS;
            }
            this.spins = 0;
        }

        public final void idleResetBeforeUnpark() {
            this.parkTimeNs = MIN_PARK_TIME_NS;
            this.spins = 0;
        }

        @Nullable
        public final Task findTask$kotlinx_coroutines_core() {
            if (this.tryAcquireCpuPermit()) {
                return this.findTaskWithCpuPermit();
            }
            Task task = this.localQueue.poll();
            if (task == null) {
                task = CoroutineScheduler.this.globalQueue.removeFirstWithModeOrNull(TaskMode.PROBABLY_BLOCKING);
            }
            return task;
        }

        private final Task findTaskWithCpuPermit() {
            boolean globalFirst;
            boolean bl = globalFirst = this.nextInt$kotlinx_coroutines_core(2 * CoroutineScheduler.this.corePoolSize) == 0;
            if (globalFirst) {
                Task task = CoroutineScheduler.this.globalQueue.removeFirstWithModeOrNull(TaskMode.NON_BLOCKING);
                if (task != null) {
                    Task task2 = task;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Task it = task2;
                    boolean bl4 = false;
                    return it;
                }
            }
            Task task = this.localQueue.poll();
            if (task != null) {
                Task task3 = task;
                boolean bl5 = false;
                boolean bl6 = false;
                Task it = task3;
                boolean bl7 = false;
                return it;
            }
            if (!globalFirst) {
                Task task4 = (Task)CoroutineScheduler.this.globalQueue.removeFirstOrNull();
                if (task4 != null) {
                    Task task5 = task4;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    Task it = task5;
                    boolean bl10 = false;
                    return it;
                }
            }
            return this.trySteal();
        }

        private final Task trySteal() {
            int created = CoroutineScheduler.this.getCreatedWorkers();
            if (created < 2) {
                return null;
            }
            int stealIndex = this.lastStealIndex;
            if (stealIndex == 0) {
                stealIndex = this.nextInt$kotlinx_coroutines_core(created);
            }
            if (++stealIndex > created) {
                stealIndex = 1;
            }
            this.lastStealIndex = stealIndex;
            Worker worker = CoroutineScheduler.this.workers[stealIndex];
            if (worker != null && worker != this && this.localQueue.trySteal(worker.localQueue, CoroutineScheduler.this.globalQueue)) {
                return this.localQueue.poll();
            }
            return null;
        }

        private Worker() {
            this.setDaemon(true);
            this.localQueue = new WorkQueue();
            this.state = WorkerState.RETIRING;
            this.terminationState = 0;
            this.nextParkedWorker = NOT_IN_STACK;
            this.parkTimeNs = MIN_PARK_TIME_NS;
            this.rngState = CoroutineScheduler.this.random.nextInt();
        }

        public Worker(int index) {
            this();
            this.setIndexInArray(index);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "", "(Ljava/lang/String;I)V", "CPU_ACQUIRED", "BLOCKING", "PARKING", "RETIRING", "TERMINATED", "kotlinx-coroutines-core"})
    public static final class WorkerState
    extends Enum<WorkerState> {
        public static final /* enum */ WorkerState CPU_ACQUIRED;
        public static final /* enum */ WorkerState BLOCKING;
        public static final /* enum */ WorkerState PARKING;
        public static final /* enum */ WorkerState RETIRING;
        public static final /* enum */ WorkerState TERMINATED;
        private static final /* synthetic */ WorkerState[] $VALUES;

        static {
            WorkerState[] workerStateArray = new WorkerState[5];
            WorkerState[] workerStateArray2 = workerStateArray;
            workerStateArray[0] = CPU_ACQUIRED = new WorkerState();
            workerStateArray[1] = BLOCKING = new WorkerState();
            workerStateArray[2] = PARKING = new WorkerState();
            workerStateArray[3] = RETIRING = new WorkerState();
            workerStateArray[4] = TERMINATED = new WorkerState();
            $VALUES = workerStateArray;
        }

        public static WorkerState[] values() {
            return (WorkerState[])$VALUES.clone();
        }

        public static WorkerState valueOf(String string) {
            return Enum.valueOf(WorkerState.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0002R\u000e\u0010\u0013\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler$Companion;", "", "()V", "ADDED", "", "ADDED_REQUIRES_HELP", "ALLOWED", "BLOCKING_MASK", "", "BLOCKING_SHIFT", "CREATED_MASK", "FORBIDDEN", "MAX_PARK_TIME_NS", "MAX_PARK_TIME_NS$annotations", "MAX_SPINS", "MAX_SUPPORTED_POOL_SIZE", "MAX_YIELDS", "MIN_PARK_TIME_NS", "MIN_PARK_TIME_NS$annotations", "MIN_SUPPORTED_POOL_SIZE", "NOT_ADDED", "NOT_IN_STACK", "Lkotlinx/coroutines/internal/Symbol;", "PARKED_INDEX_MASK", "PARKED_VERSION_INC", "PARKED_VERSION_MASK", "TERMINATED", "kotlinx-coroutines-core"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void MAX_PARK_TIME_NS$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void MIN_PARK_TIME_NS$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

