/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.energy.systems;

import cofh.redstoneflux.api.IEnergyContainerItem;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.modcrafters.mclib.energy.IGenericEnergyStorage;
import net.ndrei.teslacorelib.compatibility.RFPowerProxy;
import net.ndrei.teslacorelib.energy.IEnergySystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J+\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/RFSystem;", "Lnet/ndrei/teslacorelib/energy/IEnergySystem;", "()V", "ModId", "", "getModId", "()Ljava/lang/String;", "hasCapability", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "wrapCapability", "T", "energy", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;)Ljava/lang/Object;", "wrapItemStack", "stack", "Lnet/minecraft/item/ItemStack;", "wrapTileEntity", "te", "Lnet/minecraft/tileentity/TileEntity;", "side", "Lnet/minecraft/util/EnumFacing;", "ReverseItemWrapper", "ReverseWrapper", "tesla-core-lib"})
public final class RFSystem
implements IEnergySystem {
    public static final RFSystem INSTANCE;

    @Override
    @NotNull
    public String getModId() {
        return "redstoneflux";
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        return false;
    }

    @Override
    @Nullable
    public <T> T wrapCapability(@NotNull Capability<T> capability, @NotNull IGenericEnergyStorage energy) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
        return null;
    }

    @Override
    @Nullable
    public IGenericEnergyStorage wrapTileEntity(@NotNull TileEntity te, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull((Object)te, (String)"te");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        if (RFPowerProxy.INSTANCE.isRFAvailable() && RFPowerProxy.INSTANCE.isRFAcceptor(te, side)) {
            return new ReverseWrapper(te, side);
        }
        return null;
    }

    @Override
    @Nullable
    public IGenericEnergyStorage wrapItemStack(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (RFPowerProxy.INSTANCE.isRFAvailable() && !stack.func_190926_b() && stack.func_77973_b() instanceof IEnergyContainerItem) {
            Item item = stack.func_77973_b();
            if (item == null) {
                throw new TypeCastException("null cannot be cast to non-null type cofh.redstoneflux.api.IEnergyContainerItem");
            }
            return new ReverseItemWrapper(stack, (IEnergyContainerItem)item);
        }
        return null;
    }

    private RFSystem() {
    }

    static {
        RFSystem rFSystem;
        INSTANCE = rFSystem = new RFSystem();
    }

    @Override
    public boolean isAvailable() {
        return IEnergySystem.DefaultImpls.isAvailable(this);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/RFSystem$ReverseWrapper;", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "rf", "Lnet/minecraft/tileentity/TileEntity;", "side", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/util/EnumFacing;)V", "canGive", "", "getCanGive", "()Z", "canTake", "getCanTake", "capacity", "", "getCapacity", "()J", "getRf", "()Lnet/minecraft/tileentity/TileEntity;", "getSide", "()Lnet/minecraft/util/EnumFacing;", "stored", "getStored", "givePower", "power", "simulated", "takePower", "tesla-core-lib"})
    public static final class ReverseWrapper
    implements IGenericEnergyStorage {
        @NotNull
        private final TileEntity rf;
        @NotNull
        private final EnumFacing side;

        @Override
        public long getCapacity() {
            return RFPowerProxy.INSTANCE.getMaxEnergyStored(this.rf, this.side);
        }

        @Override
        public long getStored() {
            return RFPowerProxy.INSTANCE.getEnergyStored(this.rf, this.side);
        }

        @Override
        public boolean getCanGive() {
            return true;
        }

        @Override
        public long givePower(long power, boolean simulated) {
            return RFPowerProxy.INSTANCE.givePowerTo(this.rf, this.side, power, simulated);
        }

        @Override
        public boolean getCanTake() {
            return false;
        }

        @Override
        public long takePower(long power, boolean simulated) {
            return 0L;
        }

        @NotNull
        public final TileEntity getRf() {
            return this.rf;
        }

        @NotNull
        public final EnumFacing getSide() {
            return this.side;
        }

        public ReverseWrapper(@NotNull TileEntity rf, @NotNull EnumFacing side) {
            Intrinsics.checkParameterIsNotNull((Object)rf, (String)"rf");
            Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
            this.rf = rf;
            this.side = side;
        }

        @Override
        public boolean tryGive() {
            return IGenericEnergyStorage.DefaultImpls.tryGive(this);
        }

        @Override
        public boolean tryTake() {
            return IGenericEnergyStorage.DefaultImpls.tryTake(this);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/RFSystem$ReverseItemWrapper;", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "stack", "Lnet/minecraft/item/ItemStack;", "item", "Lcofh/redstoneflux/api/IEnergyContainerItem;", "(Lnet/minecraft/item/ItemStack;Lcofh/redstoneflux/api/IEnergyContainerItem;)V", "canGive", "", "getCanGive", "()Z", "canTake", "getCanTake", "capacity", "", "getCapacity", "()J", "getItem", "()Lcofh/redstoneflux/api/IEnergyContainerItem;", "getStack", "()Lnet/minecraft/item/ItemStack;", "stored", "getStored", "givePower", "power", "simulated", "takePower", "tesla-core-lib"})
    public static final class ReverseItemWrapper
    implements IGenericEnergyStorage {
        @NotNull
        private final ItemStack stack;
        @NotNull
        private final IEnergyContainerItem item;

        @Override
        public long getCapacity() {
            return this.item.getMaxEnergyStored(this.stack);
        }

        @Override
        public long getStored() {
            return this.item.getEnergyStored(this.stack);
        }

        @Override
        public boolean getCanGive() {
            return true;
        }

        @Override
        public boolean getCanTake() {
            return true;
        }

        @Override
        public long givePower(long power, boolean simulated) {
            return this.item.receiveEnergy(this.stack, (int)power, simulated);
        }

        @Override
        public long takePower(long power, boolean simulated) {
            return this.item.extractEnergy(this.stack, (int)power, simulated);
        }

        @NotNull
        public final ItemStack getStack() {
            return this.stack;
        }

        @NotNull
        public final IEnergyContainerItem getItem() {
            return this.item;
        }

        public ReverseItemWrapper(@NotNull ItemStack stack, @NotNull IEnergyContainerItem item) {
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            this.stack = stack;
            this.item = item;
        }

        @Override
        public boolean tryGive() {
            return IGenericEnergyStorage.DefaultImpls.tryGive(this);
        }

        @Override
        public boolean tryTake() {
            return IGenericEnergyStorage.DefaultImpls.tryTake(this);
        }
    }
}

