/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.states.loader;

import com.carpentersblocks.util.ModLogger;
import com.carpentersblocks.util.states.DummyStateMap;
import com.carpentersblocks.util.states.StateMap;
import com.carpentersblocks.util.states.StateMapConverter;
import com.carpentersblocks.util.states.loader.dto.StateDTO;
import com.carpentersblocks.util.states.loader.dto.StateMapDTO;
import com.carpentersblocks.util.states.loader.dto.StatePartDTO;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class StateLoader {
    public static final Map<String, String[]> _stateDescriptors = new HashMap<String, String[]>();
    private static final String MOD_RESOURCE_PATH = "/assets/carpentersblocks/states/";
    private static final String MC_RESOURCE_PATH = "/assets/minecraft/models/block/";
    private static final String JSON_EXT = ".json";
    private String _registryName;
    private StateMap _stateMap;
    private StateMapDTO _stateMapDto;
    private boolean _error;

    public StateLoader(String registryName) {
        this._registryName = registryName;
        try {
            this._stateMapDto = this.parseJson();
            this.fillChildStates();
            this._stateMap = new StateMapConverter(this._stateMapDto).convert();
        }
        catch (Exception ex) {
            ModLogger.warning("Exception encountered while loading state data for " + this._registryName + ", check JSON formatting.", new Object[0]);
            this._stateMap = new DummyStateMap();
            ex.printStackTrace();
        }
    }

    private StateMapDTO parseJson() throws InstantiationException, IllegalAccessException, JsonSyntaxException, JsonIOException {
        StateMapDTO stateContainerDto = null;
        InputStream inputStream = null;
        Gson gson = new Gson();
        try {
            inputStream = this.getClass().getResourceAsStream(MOD_RESOURCE_PATH + this._registryName + JSON_EXT);
            stateContainerDto = (StateMapDTO)gson.fromJson((Reader)new InputStreamReader(inputStream), StateMapDTO.class);
            if (!stateContainerDto.containsKey("default")) {
                throw new Exception("Default state is missing");
            }
        }
        catch (Exception ex) {
            ModLogger.warning("Exception encountered while loading state data for " + this._registryName, new Object[0]);
            ex.printStackTrace();
        }
        return stateContainerDto;
    }

    private void fillChildStates() {
        StateDTO defaultState = (StateDTO)this._stateMapDto.get("default");
        for (Map.Entry stateDtoEntry : this._stateMapDto.entrySet()) {
            String stateDtoKey = (String)stateDtoEntry.getKey();
            StateDTO stateDto = (StateDTO)stateDtoEntry.getValue();
            for (Map.Entry<String, StatePartDTO> statePartDtoEntry : stateDto.getParts().entrySet()) {
                String statePartDtoKey = statePartDtoEntry.getKey();
                StatePartDTO statePartDto = statePartDtoEntry.getValue();
                StatePartDTO defaultStatePartDto = defaultState.getParts().get(statePartDtoKey);
                if (defaultStatePartDto == null) continue;
                statePartDto.setMaxBrightness(defaultStatePartDto.isMaxBrightness());
                if (statePartDto.getRenderFaces() == null || statePartDto.getRenderFaces().isEmpty()) {
                    statePartDto.setRenderFaces(defaultStatePartDto.getRenderFaces());
                }
                if (statePartDto.getRenderLayer() == null) {
                    statePartDto.setRenderLayer(defaultStatePartDto.getRenderLayer());
                }
                if (statePartDto.getRgb() == null) {
                    statePartDto.setRgb(defaultStatePartDto.getRgb());
                }
                if (statePartDto.getIconName() == null) {
                    statePartDto.setIconName(defaultStatePartDto.getIconName());
                }
                if (statePartDto.getVertexMax() == null) {
                    statePartDto.setVertexMax(defaultStatePartDto.getVertexMax());
                }
                if (statePartDto.getVertexMin() != null) continue;
                statePartDto.setVertexMin(defaultStatePartDto.getVertexMin());
            }
        }
    }

    public StateMap getStateMap() {
        return this._stateMap;
    }

    public boolean isValid() {
        return !this._error;
    }

    static {
        _stateDescriptors.put("carpenters_pressure_plate", new String[]{"depressed"});
    }
}

