/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.reencryption;

import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.BuildEncryptionOutputStreamAPI;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.reencryption.ExplodeAndReencrypt;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.reencryption.ZipEntityStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReencryptExplodedZipMultithreaded {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReencryptExplodedZipMultithreaded.class);

    public void explodeAndReencrypt(final InputStream plainTextStreamOfZip, final ZipEntityStrategy zipEntityStrategy, final BuildEncryptionOutputStreamAPI.Build encryptionFactory) throws Exception {
        Callable<Boolean> encryptionTask = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    LOGGER.trace("Unziping started");
                    ExplodeAndReencrypt reencrypt = new ExplodeAndReencrypt(plainTextStreamOfZip, zipEntityStrategy, encryptionFactory);
                    reencrypt.explodeAndReencrypt();
                    LOGGER.debug("Unziping stopped");
                }
                catch (Exception e) {
                    LOGGER.warn("Unziping stopped with error", e);
                    throw e;
                }
                return true;
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> encryptionDoneFuture = executor.submit(encryptionTask);
        LOGGER.debug("Decryption done");
        LOGGER.trace("Waiting for Encryption Thread");
        encryptionDoneFuture.get();
        LOGGER.info("Done");
        executor.shutdown();
    }
}

