/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.utils;

import com.austinv11.collectiveframework.utils.FileUtils;
import com.austinv11.collectiveframework.utils.StringUtils;
import com.austinv11.peripheralsplusplus.utils.JSONFileList;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.oredict.OreDictionary;

public class Util {
    public static HashMap<Integer, Object> iteratorToMap(Iterator iterator) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        int i = 1;
        while (iterator.hasNext()) {
            map.put(i + 1, iterator.next());
            ++i;
        }
        return map;
    }

    public static HashMap<Integer, Object> EnumSetToMap(EnumSet<EnumPlantType> iterable) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        Iterator types = iterable.iterator();
        for (int i = 0; i < iterable.size(); ++i) {
            map.put(i + 1, types.next());
        }
        return map;
    }

    public static HashMap<Integer, Object> collectionToMap(Collection iterable) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        Iterator types = iterable.iterator();
        for (int i = 0; i < iterable.size(); ++i) {
            map.put(i + 1, types.next());
        }
        return map;
    }

    public static HashMap<Integer, Integer> arrayToMap(int[] array) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < array.length; ++i) {
            map.put(i + 1, array[i]);
        }
        return map;
    }

    public static HashMap<Integer, Byte> arrayToMap(byte[] array) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        for (int i = 0; i < array.length; ++i) {
            map.put(i + 1, array[i]);
        }
        return map;
    }

    public static HashMap<Integer, Object> arrayToMap(Object[] array) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        for (int i = 0; i < array.length; ++i) {
            map.put(i + 1, array[i]);
        }
        return map;
    }

    public static HashMap<Integer, String> getOreDictEntries(ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        HashMap<Integer, String> entries = new HashMap<Integer, String>();
        for (int i = 0; i < ids.length; ++i) {
            entries.put(i + 1, OreDictionary.getOreName((int)ids[i]));
        }
        return entries;
    }

    public static boolean compareItemStacksViaOreDict(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_190926_b() && !stack2.func_190926_b()) {
            for (String key : Util.getOreDictEntries(stack1).values()) {
                if (!Util.getOreDictEntries(stack2).containsValue(key)) continue;
                return true;
            }
        }
        return false;
    }

    public static NBTTagCompound writeToBookNBT(String title, String author, List<String> pageText) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("author", author);
        String titleTranslated = I18n.func_74838_a((String)title);
        if (titleTranslated.length() > 32) {
            titleTranslated = titleTranslated.substring(0, 29) + "...";
        }
        tag.func_74778_a("title", titleTranslated);
        NBTTagList list = new NBTTagList();
        for (String s : pageText) {
            JsonObject page = new JsonObject();
            page.addProperty("text", I18n.func_74838_a((String)s));
            list.func_74742_a((NBTBase)new NBTTagString(page.toString()));
        }
        tag.func_74782_a("pages", (NBTBase)list);
        return tag;
    }

    public static NBTTagCompound writeToBookNBT(String title, List<String> pageText) {
        return Util.writeToBookNBT(title, "PeripheralsPlusOne", pageText);
    }

    public static double getDamageAttribute(EntityEquipmentSlot slot, ItemStack item) {
        double val = 0.0;
        Multimap multimap = item.func_77973_b().getAttributeModifiers(slot, item);
        if (multimap.containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
            for (Object o : multimap.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
                if (!(o instanceof AttributeModifier)) continue;
                val = ((AttributeModifier)o).func_111164_d();
                break;
            }
        }
        return val;
    }

    public static String listToString(List<String> list) {
        String returnVal = "";
        for (String s : list) {
            returnVal = returnVal + s + "\n";
        }
        return returnVal;
    }

    public static boolean checkFileVersion(String dir, JSONFileList json) throws IOException {
        File file = new File(dir + "/index.json");
        if (!file.exists()) {
            return true;
        }
        Gson gson = new Gson();
        String localJson = StringUtils.stringFromList((List)FileUtils.readAll((File)file));
        JSONFileList localFile = gson.fromJson(localJson, JSONFileList.class);
        return localFile != null && !localFile.ver.equals(json.ver);
    }

    public static Object keyFromVal(HashMap map, Object val) {
        for (Object key : map.keySet()) {
            if (!map.get(key).equals(val)) continue;
            return key;
        }
        return null;
    }

    public static EntityPlayer getPlayer(String ign) {
        ArrayList players = new ArrayList();
        for (WorldServer worldServer : DimensionManager.getWorlds()) {
            players.addAll(worldServer.field_73010_i);
        }
        for (EntityPlayer p : players) {
            if (!p.getDisplayNameString().equalsIgnoreCase(ign)) continue;
            return p;
        }
        return null;
    }

    public static String[] stringToArray(String array) {
        String[] array_ = array.replace("]", "").replace("[", "").split(",");
        for (int i = 0; i < array_.length; ++i) {
            array_[i] = array_[i].trim();
        }
        return array_;
    }

    public static List<String> getPlayers(World world) {
        ArrayList<String> list = new ArrayList<String>();
        if (world != null) {
            for (EntityPlayer player : world.field_73010_i) {
                list.add(player.getDisplayNameString());
            }
        } else {
            for (WorldServer worldServer : DimensionManager.getWorlds()) {
                for (EntityPlayer player : worldServer.field_73010_i) {
                    list.add(player.getDisplayNameString());
                }
            }
        }
        return list;
    }

    public static Entity getEntityFromId(UUID entityId) {
        for (WorldServer worldServer : DimensionManager.getWorlds()) {
            Entity entity = worldServer.func_175733_a(entityId);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public static int[] byteArraytoUnsignedIntArray(byte[] bytes) {
        int[] intArray = new int[bytes.length];
        for (int byteIndex = 0; byteIndex < bytes.length; ++byteIndex) {
            intArray[byteIndex] = Byte.toUnsignedInt(bytes[byteIndex]);
        }
        return intArray;
    }

    @Nullable
    public static EntityPlayer getPlayer(UUID persistentID) {
        ArrayList players = new ArrayList();
        for (WorldServer worldServer : DimensionManager.getWorlds()) {
            players.addAll(worldServer.field_73010_i);
        }
        for (EntityPlayer p : players) {
            if (!p.getPersistentID().equals(persistentID)) continue;
            return p;
        }
        return null;
    }
}

