/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.utils;

import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.utils.FakeTurtlePlayer;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TurtleUtil {
    public static List<ItemStack> harvestBlock(ITurtleAccess turtle, FakeTurtlePlayer player, EnumFacing dir, ItemStack itemToUse) {
        int x = turtle.getPosition().func_177958_n() + dir.func_82601_c();
        int y = turtle.getPosition().func_177956_o() + dir.func_96559_d();
        int z = turtle.getPosition().func_177952_p() + dir.func_82599_e();
        if (!turtle.getWorld().func_175623_d(new BlockPos(x, y, z))) {
            IBlockState blockState = turtle.getWorld().func_180495_p(new BlockPos(x, y, z));
            player.func_184611_a(EnumHand.MAIN_HAND, itemToUse);
            BlockPos blockPos = new BlockPos(x, y, z);
            if (blockState.func_185887_b(turtle.getWorld(), blockPos) >= 0.0f && blockState.func_177230_c().canHarvestBlock((IBlockAccess)turtle.getWorld(), new BlockPos(x, y, z), (EntityPlayer)player)) {
                NonNullList items = NonNullList.func_191196_a();
                blockState.func_177230_c().getDrops(items, (IBlockAccess)turtle.getWorld(), new BlockPos(x, y, z), blockState, 0);
                turtle.getWorld().func_175698_g(new BlockPos(x, y, z));
                return items;
            }
        }
        return null;
    }

    public static List<Entity> getEntitiesNearTurtle(ITurtleAccess turtle, FakeTurtlePlayer player, EnumFacing dir) {
        int x = turtle.getPosition().func_177958_n() + dir.func_82601_c();
        int y = turtle.getPosition().func_177956_o() + dir.func_96559_d();
        int z = turtle.getPosition().func_177952_p() + dir.func_82599_e();
        AxisAlignedBB box = new AxisAlignedBB((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0);
        return turtle.getWorld().func_72839_b((Entity)player, box);
    }

    public static Entity getClosestShearableEntity(List<Entity> list, Entity ent) {
        Vec3d from = new Vec3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
        Entity returnVal = null;
        double lastDistance = Double.MAX_VALUE;
        for (Entity entity : list) {
            Vec3d to;
            if (!(entity instanceof IShearable) || !((to = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_72438_d(from) < lastDistance)) continue;
            returnVal = entity;
        }
        return returnVal;
    }

    public static Entity getClosestEntity(List<Entity> list, Entity ent) {
        Vec3d from = new Vec3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
        Entity returnVal = null;
        double lastDistance = Double.MAX_VALUE;
        for (Entity entity : list) {
            Vec3d to = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(to.func_72438_d(from) < lastDistance)) continue;
            returnVal = entity;
        }
        return returnVal;
    }

    public static void addItemListToInv(List<ItemStack> items, ITurtleAccess turtle) {
        for (ItemStack item : items) {
            TurtleUtil.addToInv(turtle, item);
        }
    }

    public static ArrayList<ItemStack> entityItemsToItemStack(ArrayList<EntityItem> entities) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (EntityItem e : entities) {
            stacks.add(e.func_92059_d());
        }
        return stacks;
    }

    public static void addToInv(ITurtleAccess turtle, ItemStack stack) {
        boolean drop = true;
        IInventory inv = turtle.getInventory();
        BlockPos coords = turtle.getPosition();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack currentStack = inv.func_70301_a(i);
            if (currentStack.func_190926_b()) {
                inv.func_70299_a(i, stack);
                drop = false;
                break;
            }
            if (!currentStack.func_77985_e() || !currentStack.func_77969_a(stack)) continue;
            int space = currentStack.func_77976_d() - currentStack.func_190916_E();
            if (stack.func_190916_E() > space) {
                currentStack.func_190920_e(currentStack.func_77976_d());
                stack.func_190920_e(stack.func_190916_E() - space);
                drop = true;
                continue;
            }
            currentStack.func_190920_e(currentStack.func_190916_E() + stack.func_190916_E());
            stack.func_190920_e(0);
            drop = false;
            break;
        }
        if (drop) {
            EnumFacing dir = turtle.getDirection();
            turtle.getWorld().func_72838_d((Entity)new EntityItem(turtle.getWorld(), (double)(coords.func_177958_n() + dir.func_82601_c()), (double)(coords.func_177956_o() + dir.func_96559_d() + 1), (double)(coords.func_177952_p() + dir.func_82599_e()), stack.func_77946_l()));
        }
    }

    public static ItemStack getTurtle(boolean isAdvanced, ITurtleUpgrade upgradeLeft, ITurtleUpgrade upgradeRight) {
        if (upgradeLeft == null && upgradeRight == null) {
            return GameRegistry.makeItemStack((String)String.format("%s:%s", "computercraft", isAdvanced ? "turtle_advanced" : "turtle"), (int)0, (int)1, (String)"");
        }
        ItemStack turtle = GameRegistry.makeItemStack((String)String.format("%s:%s", "computercraft", isAdvanced ? "turtle_advanced" : "turtle_expanded"), (int)0, (int)1, (String)"");
        if (upgradeLeft != null) {
            NBTHelper.setString((ItemStack)turtle, (String)"leftUpgrade", (String)upgradeLeft.getUpgradeID().toString());
        }
        if (upgradeRight != null) {
            NBTHelper.setString((ItemStack)turtle, (String)"rightUpgrade", (String)upgradeRight.getUpgradeID().toString());
        }
        return turtle;
    }

    public static ItemStack getTurtle(boolean isAdvanced, ITurtleUpgrade upgrade) {
        return TurtleUtil.getTurtle(isAdvanced, upgrade, null);
    }

    public static ItemStack getTurtle(boolean isAdvanced) {
        return TurtleUtil.getTurtle(isAdvanced, null);
    }

    public static <T> T getPeripheral(ITurtleAccess turtle, Class<T> clazz) {
        for (TurtleSide side : EnumSet.allOf(TurtleSide.class)) {
            IPeripheral peripheral = turtle.getPeripheral(side);
            if (peripheral == null || !clazz.isAssignableFrom(peripheral.getClass())) continue;
            return (T)peripheral;
        }
        return null;
    }

    public static TurtleSide getPeripheralSide(ITurtleAccess turtle, Class clazz) {
        for (TurtleSide side : EnumSet.allOf(TurtleSide.class)) {
            IPeripheral peripheral = turtle.getPeripheral(side);
            if (peripheral == null || !clazz.isAssignableFrom(peripheral.getClass())) continue;
            return side;
        }
        return null;
    }

    public static ItemStack getPocket(boolean advanced) {
        return TurtleUtil.getPocket(advanced, null);
    }

    public static ItemStack getPocketServerItemStack(IPocketAccess access) {
        try {
            Class<?> pocketServer = Class.forName("dan200.computercraft.shared.pocket.core.PocketServerComputer");
            if (!pocketServer.isInstance(access)) {
                return ItemStack.field_190927_a;
            }
            Field stack = pocketServer.getDeclaredField("m_stack");
            stack.setAccessible(true);
            ItemStack itemStack = (ItemStack)stack.get(access);
            if (itemStack == null) {
                return ItemStack.field_190927_a;
            }
            return itemStack;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            return ItemStack.field_190927_a;
        }
    }

    public static ItemStack getPocket(boolean advanced, IPocketUpgrade pocketUpgrade) {
        ItemStack pocket = GameRegistry.makeItemStack((String)"computercraft:pocket_computer", (int)(advanced ? 1 : 0), (int)1, (String)"");
        if (pocketUpgrade != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("upgrade", pocketUpgrade.getUpgradeID().toString());
            pocket.func_77982_d(tag);
        }
        return pocket;
    }
}

