/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.utils;

import javax.annotation.Nullable;
import li.cil.oc.api.API;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.Loader;

public class OpenComputersUtil {
    public static final String EVENT = "computer.signal";

    @Nullable
    public static Node createNode(TileEntity host, String name) {
        if (Loader.isModLoaded((String)"opencomputers|core") && API.network != null && host instanceof Environment) {
            return API.network.newNode((Environment)host, Visibility.Network).withComponent(name).create();
        }
        return null;
    }

    public static void updateNode(TileEntity tileEntity, @Nullable Node node) {
        if (node != null && node.network() == null) {
            API.network.joinOrCreateNetwork(tileEntity);
        }
    }

    public static void removeNode(@Nullable Node node) {
        if (node != null) {
            node.remove();
        }
    }

    public static void readFromNbt(NBTTagCompound compound, @Nullable Node node) {
        if (node != null && compound.func_74764_b("oc_node")) {
            node.load(compound.func_74775_l("oc_node"));
        }
    }

    public static void writeToNbt(NBTTagCompound compound, @Nullable Node node) {
        NBTTagCompound nodeTag = new NBTTagCompound();
        if (node != null) {
            node.save(nodeTag);
        }
        compound.func_74782_a("oc_node", (NBTBase)nodeTag);
    }

    public static void sendToReachable(@Nullable Node node, String eventName, Object ... eventData) {
        if (node == null) {
            return;
        }
        Object[] ocEvent = new Object[eventData.length + 1];
        ocEvent[0] = eventName;
        System.arraycopy(eventData, 0, ocEvent, 1, eventData.length);
        node.sendToReachable(EVENT, ocEvent);
    }
}

