/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles;

import com.austinv11.collectiveframework.minecraft.utils.ModelManager;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.FakeTurtlePlayer;
import com.austinv11.peripheralsplusplus.utils.ModelUtil;
import com.austinv11.peripheralsplusplus.utils.TurtleUtil;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import org.apache.commons.lang3.tuple.Pair;

public class TurtleShear
implements ITurtleUpgrade,
ModelManager.ModelRegistrar {
    public ResourceLocation getUpgradeID() {
        return new ResourceLocation("peripheralsplusone:shear");
    }

    public int getLegacyUpgradeID() {
        return 107;
    }

    public String getUnlocalisedAdjective() {
        return "peripheralsplusone.turtle_upgrade.shears";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public ItemStack getCraftingItem() {
        if (Config.enableShearTurtle) {
            return new ItemStack((Item)Items.field_151097_aZ);
        }
        return ItemStack.field_190927_a;
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull EnumFacing direction) {
        if (!Config.enableShearTurtle) {
            return TurtleCommandResult.failure((String)"Shearing turtles have been disabled");
        }
        FakeTurtlePlayer player = new FakeTurtlePlayer(turtle);
        switch (verb) {
            case Attack: {
                List<Entity> entities = TurtleUtil.getEntitiesNearTurtle(turtle, player, direction);
                Entity ent = TurtleUtil.getClosestShearableEntity(entities, (Entity)player);
                if (ent != null && ((IShearable)ent).isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)ent.field_70170_p, ent.func_180425_c())) {
                    TurtleUtil.addItemListToInv(((IShearable)ent).onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)ent.field_70170_p, ent.func_180425_c(), 0), turtle);
                    return TurtleCommandResult.success();
                }
                return TurtleCommandResult.failure();
            }
            case Dig: {
                List<ItemStack> items = TurtleUtil.harvestBlock(turtle, player, direction, new ItemStack((Item)Items.field_151097_aZ));
                if (items != null) {
                    TurtleUtil.addItemListToInv(items, turtle);
                    return TurtleCommandResult.success();
                }
                return TurtleCommandResult.failure();
            }
        }
        return TurtleCommandResult.failure((String)"An unknown error has occurred, please tell the mod author");
    }

    @Nonnull
    public Pair<IBakedModel, Matrix4f> getModel(@Nullable ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return ModelUtil.getTurtleUpgradeModel("turtle_shear", side, true);
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
    }

    public void registerModels(IRegistry<ModelResourceLocation, IBakedModel> iRegistry) {
        ModelUtil.registerTurtleUpgradeModels(iRegistry, "turtle_shear");
    }
}

