/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles;

import com.austinv11.collectiveframework.minecraft.utils.ModelManager;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.TileEntityChatBox;
import com.austinv11.peripheralsplusplus.utils.ModelUtil;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class TurtleChatBox
implements ITurtleUpgrade,
ModelManager.ModelRegistrar {
    @Nonnull
    public ResourceLocation getUpgradeID() {
        return new ResourceLocation("peripheralsplusone:chat_box");
    }

    public int getLegacyUpgradeID() {
        return 101;
    }

    public String getUnlocalisedAdjective() {
        return "peripheralsplusone.turtle_upgrade.chat_box";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public ItemStack getCraftingItem() {
        if (Config.enableChatBox) {
            return new ItemStack((Block)ModBlocks.CHAT_BOX);
        }
        return ItemStack.field_190927_a;
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new TileEntityChatBox(turtle);
    }

    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull EnumFacing direction) {
        return TurtleCommandResult.failure();
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
        IPeripheral peripheral = turtle.getPeripheral(side);
        if (peripheral instanceof TileEntityChatBox) {
            ((TileEntityChatBox)peripheral).update(true);
        }
    }

    @Nonnull
    public Pair<IBakedModel, Matrix4f> getModel(@Nullable ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return ModelUtil.getTurtleUpgradeModel("turtle_chat_box", side);
    }

    public void registerModels(IRegistry<ModelResourceLocation, IBakedModel> registry) {
        ModelUtil.registerTurtleUpgradeModels(registry, "turtle_chat_box");
    }
}

