/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.collectiveframework.minecraft.tiles.TileEntityInventory;
import com.austinv11.peripheralsplusplus.capabilities.rfid.CapabilityRfid;
import com.austinv11.peripheralsplusplus.capabilities.rfid.RfidTagHolder;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.init.ModItems;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.OpenComputersPeripheral;
import com.austinv11.peripheralsplusplus.utils.OpenComputersUtil;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import com.austinv11.peripheralsplusplus.utils.Util;
import com.austinv11.peripheralsplusplus.utils.rfid.RfidAuthentication;
import com.austinv11.peripheralsplusplus.utils.rfid.RfidTag;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Node;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Optional;

public class TileEntityRfidReaderWriter
extends TileEntityInventory
implements IPlusPlusPeripheral,
OpenComputersPeripheral {
    private byte[] selectedId;
    private RfidAuthentication authentication;
    private Node node;

    public TileEntityRfidReaderWriter() {
        this.invName = "peripheralsplusone:tile_entity_rfid_reader_writer";
        this.node = OpenComputersUtil.createNode((TileEntity)this, this.getType());
    }

    public int getSize() {
        return 1;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(ModBlocks.RFID_READER_WRITER.func_149739_a() + ".name", new Object[0]);
    }

    @Nonnull
    public String getType() {
        return "rfid_reader_writer";
    }

    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"search", "select", "auth", "deauth", "read", "write"};
    }

    @Nullable
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableRfidItems) {
            throw new LuaException("RFID items are not enabled in the config");
        }
        switch (method) {
            case 0: {
                return this.searchLua();
            }
            case 1: {
                return this.selectLua(arguments);
            }
            case 2: {
                return this.authLua(arguments);
            }
            case 3: {
                return this.deauthLua();
            }
            case 4: {
                return this.readLua(arguments);
            }
            case 5: {
                return this.writeLua(arguments);
            }
            case 6: {
                return this.incrementLua(arguments);
            }
            case 7: {
                return this.decrementLua(arguments);
            }
            case 8: {
                return this.restoreLua(arguments);
            }
            case 9: {
                return this.transferLua(arguments);
            }
        }
        throw new LuaException("Unexpected error");
    }

    private Object[] transferLua(Object[] arguments) {
        return new Object[0];
    }

    private Object[] restoreLua(Object[] arguments) {
        return new Object[0];
    }

    private Object[] decrementLua(Object[] arguments) {
        return new Object[0];
    }

    private Object[] incrementLua(Object[] arguments) {
        return new Object[0];
    }

    private Object[] writeLua(Object[] arguments) throws LuaException {
        if (arguments.length < 2) {
            throw new LuaException("Not enough arguments");
        }
        if (!(arguments[0] instanceof Double)) {
            throw new LuaException("Argument 1 expected to be an int");
        }
        if (this.selectedId == null || this.authentication == null) {
            return new Object[]{false};
        }
        int block = ((Double)arguments[0]).intValue();
        byte[] data = this.parseLuaIdArg(arguments[1], 16);
        ItemStack chip = this.getRfidItem(this.selectedId);
        if (chip.func_190926_b()) {
            return new Object[]{false};
        }
        RfidTag rfidTag = new RfidTag(chip);
        this.authentication.writeBlock(rfidTag, block, data);
        RfidTag.removeTag(chip);
        RfidTag.addTag(chip, rfidTag);
        return new Object[]{true};
    }

    private Object[] readLua(Object[] arguments) throws LuaException {
        if (arguments.length < 1) {
            throw new LuaException("Not enough arguments");
        }
        if (!(arguments[0] instanceof Double)) {
            throw new LuaException("Argument 1 expected to be an integer");
        }
        if (this.selectedId == null || this.authentication == null) {
            return new Object[0];
        }
        int block = ((Double)arguments[0]).intValue();
        ItemStack chip = this.getRfidItem(this.selectedId);
        if (chip.func_190926_b()) {
            return new Object[0];
        }
        RfidTag rfidTag = new RfidTag(chip);
        byte[] blockBytes = this.authentication.readBlock(rfidTag, block);
        return new Object[]{Util.arrayToMap(Util.byteArraytoUnsignedIntArray(blockBytes))};
    }

    private Object[] deauthLua() {
        this.authentication = null;
        return new Object[0];
    }

    private Object[] authLua(Object[] arguments) throws LuaException {
        if (arguments.length < 3) {
            throw new LuaException("Not enough arguments");
        }
        if (!(arguments[0] instanceof Double)) {
            throw new LuaException("Argument 1 expected to be an integer");
        }
        if (!(arguments[1] instanceof Double)) {
            throw new LuaException("Argument 2 expected to be an integer");
        }
        int type = ((Double)arguments[0]).intValue();
        if (type != RfidTag.KeyType.A.ordinal() && type != RfidTag.KeyType.B.ordinal()) {
            throw new LuaException("Invalid key type");
        }
        int block = ((Double)arguments[1]).intValue();
        if (block < 0 || block >= 64) {
            throw new LuaException("Block index out of range");
        }
        this.authentication = new RfidAuthentication(RfidTag.KeyType.values()[type], block, this.parseLuaIdArg(arguments[2], RfidTag.DEFAULT_KEY.length));
        return new Object[0];
    }

    private byte[] parseLuaIdArg(Object argument, int size) throws LuaException {
        List<Double> passedId;
        String argOneError = "Expected an array of unsigned integers";
        if (!(argument instanceof Map)) {
            throw new LuaException(argOneError);
        }
        try {
            passedId = this.doubleMapToList((Map)argument);
        }
        catch (NumberFormatException e) {
            throw new LuaException(argOneError);
        }
        if (passedId.size() != size) {
            throw new LuaException(String.format("Table size is incorrect. Found: %d Expected: %d", passedId.size(), size));
        }
        return this.doubleListToByteArray(passedId);
    }

    private Object[] selectLua(Object[] arguments) throws LuaException {
        if (arguments.length < 1) {
            throw new LuaException("Not enough arguments");
        }
        byte[] id = this.parseLuaIdArg(arguments[0], 7);
        ItemStack rfidItem = this.getRfidItem(id);
        if (!rfidItem.func_190926_b()) {
            this.selectedId = id;
        }
        return new Object[0];
    }

    private List<Double> doubleMapToList(Map<Double, Double> map) throws NumberFormatException {
        ArrayList<Double> list = new ArrayList<Double>();
        Double index = 1.0;
        while (index <= (double)map.size()) {
            if (!map.containsKey(index)) {
                throw new NumberFormatException();
            }
            list.add(map.get(index));
            Double d = index;
            Double d2 = index = Double.valueOf(index + 1.0);
        }
        return list;
    }

    @Nonnull
    private ItemStack getRfidItem(@Nullable byte[] id) {
        ItemStack foundRfidItem = this.getRfidItemFromInventory((IInventory)this, id);
        if (!foundRfidItem.func_190926_b()) {
            return foundRfidItem;
        }
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v());
        if (te != null) {
            try {
                ITurtleAccess turtle = ReflectionHelper.getTurtle(te);
                foundRfidItem = this.getRfidItemFromInventory(turtle.getInventory(), id);
                if (!foundRfidItem.func_190926_b()) {
                    return foundRfidItem;
                }
            }
            catch (Exception turtle) {
                // empty catch block
            }
        }
        for (int currentRadius = 1; currentRadius <= 3; ++currentRadius) {
            BlockPos start = this.func_174877_v().func_177985_f(currentRadius).func_177964_d(currentRadius).func_177979_c(currentRadius);
            int diameter = currentRadius * 2 + 1;
            for (int y = 0; y < diameter; ++y) {
                for (int x = 0; x < diameter; ++x) {
                    for (int z = 0; z < diameter; ++z) {
                        BlockPos pos = start.func_177965_g(x).func_177970_e(z).func_177981_b(y);
                        List entities = this.func_145831_w().func_72872_a(Entity.class, new AxisAlignedBB(pos));
                        for (Entity entity : entities) {
                            RfidTagHolder tagHolder;
                            if (entity instanceof EntityPlayer ? !(foundRfidItem = this.getRfidItemFromInventory((IInventory)((EntityPlayer)entity).field_71071_by, id)).func_190926_b() : !(!(entity instanceof EntityItem) || !RfidTag.hasTag(foundRfidItem = ((EntityItem)entity).func_92059_d()) && !foundRfidItem.func_77969_a(new ItemStack(ModItems.RFID_CHIP)) || foundRfidItem.func_190916_E() != 1 || id != null && !RfidTag.itemIdEquals(foundRfidItem, id))) {
                                return foundRfidItem;
                            }
                            Iterable items = entity.func_184209_aF();
                            for (ItemStack item : items) {
                                if (!RfidTag.hasTag(item) && !item.func_77969_a(new ItemStack(ModItems.RFID_CHIP)) || item.func_190916_E() != 1) continue;
                                foundRfidItem = item;
                                if (!foundRfidItem.func_190926_b() && (id == null || RfidTag.itemIdEquals(foundRfidItem, id))) {
                                    return foundRfidItem;
                                }
                                foundRfidItem = ItemStack.field_190927_a;
                            }
                            if (!entity.hasCapability(CapabilityRfid.INSTANCE, null) || (tagHolder = (RfidTagHolder)entity.getCapability(CapabilityRfid.INSTANCE, null)) == null || tagHolder.getTag().func_190926_b() || id != null && !RfidTag.itemIdEquals(tagHolder.getTag(), id)) continue;
                            return tagHolder.getTag();
                        }
                        TileEntity tileEntity = this.func_145831_w().func_175625_s(pos);
                        if (!foundRfidItem.func_190926_b() || !(tileEntity instanceof IInventory) || (foundRfidItem = this.getRfidItemFromInventory((IInventory)tileEntity, id)).func_190926_b()) continue;
                        return foundRfidItem;
                    }
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    private byte[] doubleListToByteArray(List<Double> doubleList) {
        byte[] byteArray = new byte[doubleList.size()];
        for (int number = 0; number < doubleList.size(); ++number) {
            byteArray[number] = (byte)Math.floor(doubleList.get(number));
        }
        return byteArray;
    }

    private Object[] searchLua() {
        ItemStack foundRfidItem = this.getRfidItem(null);
        if (!foundRfidItem.func_190926_b()) {
            RfidTag tag = new RfidTag(foundRfidItem);
            if (!RfidTag.hasTag(foundRfidItem) || tag.getIdLong() <= 0L) {
                RfidTag.addTag(foundRfidItem, tag);
            }
            return new Object[]{Util.arrayToMap(Util.byteArraytoUnsignedIntArray(tag.getId()))};
        }
        return new Object[0];
    }

    @Nonnull
    private ItemStack getRfidItemFromInventory(IInventory inventory, @Nullable byte[] id) {
        for (int itemIndex = 0; itemIndex < inventory.func_70302_i_(); ++itemIndex) {
            ItemStack item = inventory.func_70301_a(itemIndex);
            if (!RfidTag.hasTag(item) && !item.func_77969_a(new ItemStack(ModItems.RFID_CHIP)) || item.func_190916_E() != 1 || id != null && !RfidTag.itemIdEquals(item, id)) continue;
            return item;
        }
        return ItemStack.field_190927_a;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @Optional.Method(modid="opencomputers|core")
    public String[] methods() {
        return this.getMethodNames();
    }

    @Optional.Method(modid="opencomputers|core")
    public Object[] invoke(String method, Context context, Arguments arguments) throws Exception {
        if (!Config.enableRfidItems) {
            throw new LuaException("RFID items are not enabled in the config");
        }
        switch (method) {
            case "search": {
                return this.searchLua();
            }
            case "select": {
                return this.selectLua(arguments.toArray());
            }
            case "auth": {
                return this.authLua(arguments.toArray());
            }
            case "deauth": {
                return this.deauthLua();
            }
            case "read": {
                return this.readLua(arguments.toArray());
            }
            case "write": {
                return this.writeLua(arguments.toArray());
            }
            case "increment": {
                return this.incrementLua(arguments.toArray());
            }
            case "decrement": {
                return this.decrementLua(arguments.toArray());
            }
            case "restore": {
                return this.restoreLua(arguments.toArray());
            }
            case "transfer": {
                return this.transferLua(arguments.toArray());
            }
        }
        throw new LuaException("Unexpected error");
    }

    @Optional.Method(modid="opencomputers|core")
    public Node node() {
        return this.node;
    }

    public void func_73660_a() {
        super.func_73660_a();
        OpenComputersUtil.updateNode((TileEntity)this, this.node);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        OpenComputersUtil.removeNode(this.node);
    }

    public void func_145843_s() {
        super.func_145843_s();
        OpenComputersUtil.removeNode(this.node);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        OpenComputersUtil.readFromNbt(compound, this.node);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        OpenComputersUtil.writeToNbt(compound, this.node);
        return compound;
    }
}

