/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.collectiveframework.minecraft.utils.Location;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.Util;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityPlayerSensor
extends TileEntity
implements IPlusPlusPeripheral {
    private HashMap<IComputerAccess, Boolean> computers = new HashMap();
    private Location location;
    private ITurtleAccess turtle;

    public TileEntityPlayerSensor() {
    }

    public TileEntityPlayerSensor(ITurtleAccess turtle) {
        this.location = new Location((double)turtle.getPosition().func_177958_n(), (double)turtle.getPosition().func_177956_o(), (double)turtle.getPosition().func_177952_p(), turtle.getWorld());
        this.turtle = turtle;
        this.func_174878_a(turtle.getPosition());
        this.func_145834_a(turtle.getWorld());
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b != null) {
            this.location = new Location((TileEntity)this);
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    public String getType() {
        return "playerSensor";
    }

    public String[] getMethodNames() {
        if (Config.additionalMethods) {
            return new String[]{"getNearbyPlayers", "getAllPlayers"};
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enablePlayerSensor) {
            throw new LuaException("Player sensors have been disabled");
        }
        if (!Config.additionalMethods) {
            throw new LuaException("Additional methods for player sensors have been disabled");
        }
        if (method == 0) {
            try {
                if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                TileEntityPlayerSensor tileEntityPlayerSensor = this;
                synchronized (tileEntityPlayerSensor) {
                    double range = Config.sensorRange;
                    if (arguments.length > 0) {
                        range = (Double)arguments[0];
                    }
                    HashMap map = new Location((TileEntity)this).getPlayers(range);
                    HashMap returnVal = new HashMap();
                    int i = 1;
                    for (String player : map.keySet()) {
                        HashMap<String, String> table = new HashMap<String, String>();
                        table.put("player", player);
                        table.put("distance", (String)map.get(player));
                        returnVal.put(i, table);
                        ++i;
                    }
                    return new Object[]{returnVal};
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (method == 1) {
            if (arguments.length > 0 && !(arguments[0] instanceof Boolean)) {
                throw new LuaException("Bad argument #1 (expected boolean)");
            }
            boolean inWorld = false;
            if (arguments.length > 0) {
                inWorld = (Boolean)arguments[0];
            }
            TileEntityPlayerSensor tileEntityPlayerSensor = this;
            synchronized (tileEntityPlayerSensor) {
                HashMap<Integer, String> map = new HashMap<Integer, String>();
                int i = 1;
                for (String p : Util.getPlayers(inWorld ? this.func_145831_w() : null)) {
                    map.put(i, p);
                    ++i;
                }
                return new Object[]{map};
            }
        }
        return new Object[0];
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computers.put(computer, true);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    public void update() {
        this.func_174878_a(this.turtle.getPosition());
    }

    public void blockActivated(String player) {
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("player", new Object[]{player});
        }
    }
}

