/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.pocket.peripherals;

import com.austinv11.collectiveframework.minecraft.utils.Location;
import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.TurtleUtil;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PeripheralMotionDetector
implements IPlusPlusPeripheral {
    private Location oldLocation = null;
    private IComputerAccess computer;
    private float pitch;
    private float yaw;

    public PeripheralMotionDetector(Entity entity) {
        if (entity != null) {
            this.oldLocation = new Location(entity);
            this.setPitchAndYaw(entity);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setPitchAndYaw(Entity entity) {
        this.pitch = entity.field_70125_A;
        this.yaw = entity.field_70177_z;
    }

    public String getType() {
        return "motionDetector";
    }

    public String[] getMethodNames() {
        return new String[0];
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    public void update(Entity entity) {
        if (!Config.enableMotionDetector) {
            return;
        }
        if (this.computer != null) {
            Location newLocation = new Location(entity);
            if (this.oldLocation == null) {
                this.oldLocation = new Location(newLocation);
            }
            if (!newLocation.equals((Object)this.oldLocation)) {
                if (!newLocation.getWorld().equals(this.oldLocation.getWorld())) {
                    this.computer.queueEvent("worldChanged", new Object[]{this.oldLocation.getWorld().field_73011_w.getDimension(), newLocation.getWorld().field_73011_w.getDimension()});
                }
                this.computer.queueEvent("locationChanged", new Object[]{newLocation.getX() - this.oldLocation.getX(), newLocation.getY() - this.oldLocation.getY(), newLocation.getZ() - this.oldLocation.getZ()});
                this.oldLocation = newLocation;
            }
            if (entity.field_70125_A != this.pitch || entity.field_70177_z != this.yaw) {
                this.computer.queueEvent("rotationChanged", new Object[]{Float.valueOf(entity.field_70177_z), Float.valueOf(entity.field_70125_A)});
                this.setPitchAndYaw(entity);
            }
        }
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computer = computer;
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computer = null;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack heldItem;
        if (!Config.enableMotionDetector) {
            return;
        }
        if (this.computer == null) {
            return;
        }
        if (!event.isCanceled() && !(heldItem = event.getEntityPlayer().func_184614_ca()).func_190926_b()) {
            ItemStack pocket = TurtleUtil.getPocket(true);
            if (heldItem.func_77973_b() == pocket.func_77973_b() && NBTHelper.hasTag((ItemStack)heldItem, (String)"upgrade")) {
                String upgrade = "";
                if (NBTHelper.hasTag((ItemStack)heldItem, (String)"peripheralsplusone:pocket_container")) {
                    NBTTagList list = NBTHelper.getList((ItemStack)heldItem, (String)"peripheralsplusone:pocket_container", (int)8);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        if (!list.func_150307_f(i).equals("peripheralsplusone:pocket_motion_detector")) continue;
                        upgrade = "peripheralsplusone:pocket_motion_detector";
                        break;
                    }
                } else {
                    upgrade = NBTHelper.getString((ItemStack)heldItem, (String)"upgrade");
                }
                if (upgrade.equals("peripheralsplusone:pocket_motion_detector")) {
                    if (event instanceof PlayerInteractEvent.LeftClickBlock) {
                        this.computer.queueEvent("blockHit", new Object[0]);
                    } else {
                        this.computer.queueEvent("rightClick", new Object[0]);
                    }
                }
            }
        }
    }
}

