/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.util.AEColor;
import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.ItemRenderingCustomizer;
import appeng.client.render.StaticItemColor;
import appeng.client.render.cablebus.P2PTunnelFrequencyModel;
import appeng.core.features.registries.PartModels;
import appeng.items.parts.ItemPart;
import appeng.items.parts.PartType;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPartRendering
extends ItemRenderingCustomizer {
    private final PartModels partModels;
    private final ItemPart item;

    public ItemPartRendering(PartModels partModels, ItemPart item) {
        this.partModels = partModels;
        this.item = item;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void customize(IItemRendering rendering) {
        rendering.meshDefinition(this::getItemMeshDefinition);
        rendering.color(new StaticItemColor(AEColor.TRANSPARENT));
        rendering.variants(Arrays.stream(PartType.values()).filter(f -> f != PartType.INVALID_TYPE).flatMap(part -> part.getItemModels().stream()).collect(Collectors.toList()));
        ResourceLocation annihilationPlaneTexture = new ResourceLocation("appliedenergistics2", "items/part/annihilation_plane");
        ResourceLocation annihilationPlaneOnTexture = new ResourceLocation("appliedenergistics2", "parts/annihilation_plane_on");
        ResourceLocation fluidAnnihilationPlaneTexture = new ResourceLocation("appliedenergistics2", "items/part/fluid_annihilation_plane");
        ResourceLocation fluidAnnihilationPlaneOnTexture = new ResourceLocation("appliedenergistics2", "parts/fluid_annihilation_plane_on");
        ResourceLocation identityAnnihilationPlaneTexture = new ResourceLocation("appliedenergistics2", "items/part/identity_annihilation_plane");
        ResourceLocation identityAnnihilationPlaneOnTexture = new ResourceLocation("appliedenergistics2", "parts/identity_annihilation_plane_on");
        ResourceLocation formationPlaneTexture = new ResourceLocation("appliedenergistics2", "items/part/formation_plane");
        ResourceLocation formationPlaneOnTexture = new ResourceLocation("appliedenergistics2", "parts/formation_plane_on");
        ResourceLocation fluidFormationPlaneTexture = new ResourceLocation("appliedenergistics2", "items/part/fluid_formation_plane");
        ResourceLocation fluidFormationPlaneOnTexture = new ResourceLocation("appliedenergistics2", "parts/fluid_formation_plane_on");
        ResourceLocation sidesTexture = new ResourceLocation("appliedenergistics2", "parts/plane_sides");
        ResourceLocation backTexture = new ResourceLocation("appliedenergistics2", "parts/transition_plane_back");
        ArrayList<String> modelNames = new ArrayList<String>();
        for (PlaneConnections connection : PlaneConnections.PERMUTATIONS) {
            PlaneModel model = new PlaneModel(annihilationPlaneTexture, sidesTexture, backTexture, connection);
            rendering.builtInModel("models/part/annihilation_plane_" + connection.getFilenameSuffix(), model);
            modelNames.add("part/annihilation_plane_" + connection.getFilenameSuffix());
            model = new PlaneModel(annihilationPlaneOnTexture, sidesTexture, backTexture, connection);
            rendering.builtInModel("models/part/annihilation_plane_on_" + connection.getFilenameSuffix(), model);
            modelNames.add("part/annihilation_plane_on_" + connection.getFilenameSuffix());
            model = new PlaneModel(fluidAnnihilationPlaneTexture, sidesTexture, backTexture, connection);
            rendering.builtInModel("models/part/fluid_annihilation_plane_" + connection.getFilenameSuffix(), model);
            modelNames.add("part/fluid_annihilation_plane_" + connection.getFilenameSuffix());
            model = new PlaneModel(fluidAnnihilationPlaneOnTexture, sidesTexture, backTexture, connection);
            rendering.builtInModel("models/part/fluid_annihilation_plane_on_" + connection.getFilenameSuffix(), model);
            modelNames.add("part/fluid_annihilation_plane_on_" + connection.getFilenameSuffix());
            model = new PlaneModel(identityAnnihilationPlaneTexture, sidesTexture, backTexture, connection);
            rendering.builtInModel("models/part/identity_annihilation_plane_" + connection.getFilenameSuffix(), model);
            modelNames.add("part/identity_annihilation_plane_" + connection.getFilenameSuffix());
            model = new PlaneModel(identityAnnihilationPlaneOnTexture, sidesTexture, backTexture, connection);
            rendering.builtInModel("models/part/identity_annihilation_plane_on_" + connection.getFilenameSuffix(), model);
            modelNames.add("part/identity_annihilation_plane_on_" + connection.getFilenameSuffix());
            model = new PlaneModel(formationPlaneTexture, sidesTexture, backTexture, connection);
            rendering.builtInModel("models/part/formation_plane_" + connection.getFilenameSuffix(), model);
            modelNames.add("part/formation_plane_" + connection.getFilenameSuffix());
            model = new PlaneModel(formationPlaneOnTexture, sidesTexture, backTexture, connection);
            rendering.builtInModel("models/part/formation_plane_on_" + connection.getFilenameSuffix(), model);
            modelNames.add("part/formation_plane_on_" + connection.getFilenameSuffix());
            model = new PlaneModel(fluidFormationPlaneTexture, sidesTexture, backTexture, connection);
            rendering.builtInModel("models/part/fluid_formation_plane_" + connection.getFilenameSuffix(), model);
            modelNames.add("part/fluid_formation_plane_" + connection.getFilenameSuffix());
            model = new PlaneModel(fluidFormationPlaneOnTexture, sidesTexture, backTexture, connection);
            rendering.builtInModel("models/part/fluid_formation_plane_on_" + connection.getFilenameSuffix(), model);
            modelNames.add("part/fluid_formation_plane_on_" + connection.getFilenameSuffix());
        }
        rendering.builtInModel("models/part/builtin/p2p_tunnel_frequency", new P2PTunnelFrequencyModel());
        List<ResourceLocation> partResourceLocs = modelNames.stream().map(name -> new ResourceLocation("appliedenergistics2", name)).collect(Collectors.toList());
        this.partModels.registerModels(partResourceLocs);
    }

    private ModelResourceLocation getItemMeshDefinition(ItemStack is) {
        PartType partType = this.item.getTypeByStack(is);
        int variant = this.item.variantOf(is.func_77952_i());
        return partType.getItemModels().get(variant);
    }
}

