/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.SlotRestrictedInput;
import appeng.tile.misc.TileVibrationChamber;
import appeng.util.Platform;
import net.minecraft.entity.player.InventoryPlayer;

public class ContainerVibrationChamber
extends AEBaseContainer
implements IProgressProvider {
    private final TileVibrationChamber vibrationChamber;
    @GuiSync(value=0)
    public int burnSpeed = 0;
    @GuiSync(value=1)
    public int remainingBurnTime = 0;

    public ContainerVibrationChamber(InventoryPlayer ip, TileVibrationChamber vibrationChamber) {
        super(ip, vibrationChamber, null);
        this.vibrationChamber = vibrationChamber;
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.FUEL, vibrationChamber.getInternalInventory(), 0, 80, 37, this.getInventoryPlayer()));
        this.bindPlayerInventory(ip, 0, 84);
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            this.remainingBurnTime = this.vibrationChamber.getMaxBurnTime() <= 0.0 ? 0 : (int)(100.0 * this.vibrationChamber.getBurnTime() / this.vibrationChamber.getMaxBurnTime());
            this.burnSpeed = this.remainingBurnTime <= 0 ? 0 : this.vibrationChamber.getBurnSpeed();
        }
        super.func_75142_b();
    }

    @Override
    public int getCurrentProgress() {
        return this.burnSpeed;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    @Override
    public int getMaxProgress() {
        return 200;
    }
}

