/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import forestry.core.fluids.ITankManager;
import forestry.core.triggers.Trigger;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarmHatch;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.IFluidTank;

public class TriggerLowLiquid
extends Trigger {
    private final float threshold;

    public TriggerLowLiquid(String tag, float threshold) {
        super(tag, "lowLiquid", "low_liquid");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold * 100.0f + "%";
    }

    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        if (!(tile instanceof TileFarmHatch)) {
            return false;
        }
        TileFarmHatch tileHatch = (TileFarmHatch)tile;
        ITankManager tankManager = ((MultiblockLogicFarm)tileHatch.getMultiblockLogic()).getController().getTankManager();
        IFluidTank tank = tankManager.getTank(0);
        if (tank.getCapacity() == 0) {
            return false;
        }
        return (float)tank.getFluidAmount() / (float)tank.getCapacity() <= this.threshold;
    }
}

