/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.tileentity;

import com.google.common.eventbus.Subscribe;
import net.malisis.blocks.MalisisBlocks;
import net.malisis.blocks.block.VanishingBlock;
import net.malisis.blocks.tileentity.VanishingTileEntity;
import net.malisis.blocks.vanishingoption.VanishingOptions;
import net.malisis.blocks.vanishingoption.VanishingOptionsGui;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.InventoryEvent;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.util.ItemUtils;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VanishingDiamondTileEntity
extends VanishingTileEntity
implements IInventoryProvider.IDirectInventoryProvider {
    protected int changedPowerStateTimer;
    protected VanishingOptions vanishingOptions = new VanishingOptions();

    public VanishingDiamondTileEntity() {
        super(VanishingBlock.Type.DIAMOND);
        this.vanishingOptions.getSlot().register((Object)this);
    }

    public VanishingOptions getVanishingOptions() {
        return this.vanishingOptions;
    }

    public void setDuration(int duration) {
        this.vanishingOptions.setDuration(duration);
    }

    @Override
    public int getDuration() {
        return this.vanishingOptions.getDuration();
    }

    public void copyOptions(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() != MalisisBlocks.Items.vanishingCopierItem) {
            return;
        }
        VanishingOptions isOptions = MalisisBlocks.Items.vanishingCopierItem.getVanishingOptions(itemStack);
        isOptions.copy(this.vanishingOptions);
        if (!this.vanishingOptions.getSlot().isEmpty() && !isOptions.getSlot().isFull()) {
            isOptions.getInventory().transfer(this.vanishingOptions.getInventory());
        }
        isOptions.save();
    }

    public void pasteOptions(ItemStack itemStack, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (itemStack == null || itemStack.func_77973_b() != MalisisBlocks.Items.vanishingCopierItem) {
            return;
        }
        VanishingOptions isOptions = MalisisBlocks.Items.vanishingCopierItem.getVanishingOptions(itemStack);
        this.vanishingOptions.copy(isOptions);
        TileEntityUtils.notifyUpdate((TileEntity)this);
        ItemStack isItemStack = isOptions.getSlot().getItemStack();
        ItemStack teItemStack = this.vanishingOptions.getSlot().getItemStack();
        if (isItemStack == null) {
            return;
        }
        if (!this.applyItemStack(isItemStack, player, EnumHand.MAIN_HAND, side, hitX, hitY, hitZ)) {
            return;
        }
        isOptions.save();
        if (ItemUtils.areItemStacksStackable((ItemStack)isItemStack, (ItemStack)teItemStack)) {
            return;
        }
        ItemStack copy = isItemStack.func_77946_l();
        copy.func_190920_e(1);
        this.vanishingOptions.getSlot().setItemStack(copy);
    }

    @Override
    public boolean setPowerState(boolean powered) {
        if (!super.setPowerState(powered)) {
            return false;
        }
        this.changedPowerStateTimer = 0;
        this.vanishingOptions.setPowerState(this.field_145850_b, this.field_174879_c, this.changedPowerStateTimer, powered);
        return true;
    }

    public MalisisInventory getInventory() {
        return this.vanishingOptions.getInventory();
    }

    @SideOnly(value=Side.CLIENT)
    public MalisisGui getGui(MalisisInventoryContainer container) {
        return new VanishingOptionsGui(this.vanishingOptions, container, this);
    }

    @Override
    public void func_73660_a() {
        ++this.changedPowerStateTimer;
        this.vanishingOptions.propagateState(this.field_145850_b, this.field_174879_c, this.changedPowerStateTimer, this.powered);
        super.func_73660_a();
    }

    @Subscribe
    public void onSlotChanged(InventoryEvent.SlotChanged event) {
        this.setBlockState(event.getSlot().getItemStack(), null, null, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
        TileEntityUtils.notifyUpdate((TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.vanishingOptions.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.vanishingOptions.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        TileEntityUtils.updateGui((TileEntity)this);
        TileEntityUtils.notifyUpdate((TileEntity)this);
    }
}

