/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.fog;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.capabilities.CapabilitySeasonInfo;
import org.orecruncher.dsurround.capabilities.season.ISeasonInfo;
import org.orecruncher.dsurround.capabilities.season.SeasonType;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.handlers.fog.MorningFogRangeCalculator;

@SideOnly(value=Side.CLIENT)
public class SeasonFogRangeCalculator
extends MorningFogRangeCalculator {
    private static final Map<SeasonKey, MorningFogRangeCalculator.FogType> MAPPING = new Object2ReferenceOpenHashMap();

    @Override
    public MorningFogRangeCalculator.FogType getFogType() {
        SeasonType.SubType st;
        SeasonType t;
        MorningFogRangeCalculator.FogType type;
        World world = EnvironStateHandler.EnvironState.getWorld();
        ISeasonInfo cap = CapabilitySeasonInfo.getCapability(world);
        if (cap != null && (type = MAPPING.get(new SeasonKey(t = cap.getSeasonType(), st = cap.getSeasonSubType()))) != null) {
            return type;
        }
        return super.getFogType();
    }

    static {
        MAPPING.put(new SeasonKey(SeasonType.AUTUMN, SeasonType.SubType.EARLY), MorningFogRangeCalculator.FogType.NORMAL);
        MAPPING.put(new SeasonKey(SeasonType.AUTUMN, SeasonType.SubType.MID), MorningFogRangeCalculator.FogType.MEDIUM);
        MAPPING.put(new SeasonKey(SeasonType.AUTUMN, SeasonType.SubType.LATE), MorningFogRangeCalculator.FogType.HEAVY);
        MAPPING.put(new SeasonKey(SeasonType.WINTER, SeasonType.SubType.EARLY), MorningFogRangeCalculator.FogType.MEDIUM);
        MAPPING.put(new SeasonKey(SeasonType.WINTER, SeasonType.SubType.MID), MorningFogRangeCalculator.FogType.LIGHT);
        MAPPING.put(new SeasonKey(SeasonType.WINTER, SeasonType.SubType.LATE), MorningFogRangeCalculator.FogType.NORMAL);
        MAPPING.put(new SeasonKey(SeasonType.SPRING, SeasonType.SubType.EARLY), MorningFogRangeCalculator.FogType.MEDIUM);
        MAPPING.put(new SeasonKey(SeasonType.SPRING, SeasonType.SubType.MID), MorningFogRangeCalculator.FogType.HEAVY);
        MAPPING.put(new SeasonKey(SeasonType.SPRING, SeasonType.SubType.LATE), MorningFogRangeCalculator.FogType.NORMAL);
        MAPPING.put(new SeasonKey(SeasonType.SUMMER, SeasonType.SubType.EARLY), MorningFogRangeCalculator.FogType.LIGHT);
        MAPPING.put(new SeasonKey(SeasonType.SUMMER, SeasonType.SubType.MID), MorningFogRangeCalculator.FogType.NONE);
        MAPPING.put(new SeasonKey(SeasonType.SUMMER, SeasonType.SubType.LATE), MorningFogRangeCalculator.FogType.LIGHT);
    }

    private static class SeasonKey
    implements Map.Entry<SeasonType, SeasonType.SubType> {
        private final SeasonType season;
        private final SeasonType.SubType subType;

        public SeasonKey(@Nonnull SeasonType s, @Nonnull SeasonType.SubType st) {
            this.season = s;
            this.subType = st;
        }

        @Override
        @Nonnull
        public SeasonType getKey() {
            return this.season;
        }

        @Override
        @Nonnull
        public SeasonType.SubType getValue() {
            return this.subType;
        }

        @Override
        public SeasonType.SubType setValue(@Nonnull SeasonType.SubType value) {
            return null;
        }

        @Override
        public int hashCode() {
            return this.season.hashCode() ^ 31 * this.subType.hashCode();
        }

        @Override
        public boolean equals(@Nonnull Object key) {
            SeasonKey sk = (SeasonKey)key;
            return this.season == sk.season && this.subType == sk.subType;
        }
    }
}

