/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.effects.EntityEffect;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactory;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactoryFilter;
import org.orecruncher.dsurround.client.sound.ISoundInstance;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.registry.effect.EntityEffectInfo;
import org.orecruncher.dsurround.registry.item.IItemData;
import org.orecruncher.dsurround.registry.item.ItemClass;
import org.orecruncher.dsurround.registry.item.ItemUtils;
import org.orecruncher.lib.ItemStackUtil;

@SideOnly(value=Side.CLIENT)
public class EntityBowSoundEffect
extends EntityEffect {
    protected ItemStack lastActiveStack;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER = (e, eei) -> eei.effects.contains("bow");

    @Override
    public String name() {
        return "Bow Sound";
    }

    @Override
    public void update(@Nonnull Entity subject) {
        EntityLivingBase entity = (EntityLivingBase)subject;
        ItemStack currentStack = entity.func_184607_cu();
        if (ItemStackUtil.isValidItemStack((ItemStack)currentStack)) {
            if (this.lastActiveStack == null || !ItemStack.func_77989_b((ItemStack)currentStack, (ItemStack)this.lastActiveStack)) {
                SoundEffect soundEffect;
                IItemData data = ItemUtils.getItemData(currentStack.func_77973_b());
                ItemClass itemClass = data.getItemClass();
                if ((itemClass == ItemClass.BOW || itemClass == ItemClass.SHIELD) && (soundEffect = data.getUseSound(currentStack)) != null) {
                    ISoundInstance fx = this.getState().createSound(soundEffect, (Entity)entity);
                    this.getState().playSound(fx);
                }
                this.lastActiveStack = currentStack;
            }
        } else {
            this.lastActiveStack = null;
        }
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new EntityBowSoundEffect());
        }
    }
}

