/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public class GuiFilteredConfigEntries
extends GuiConfigEntries {
    private static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    private static final String searchLabel = I18n.func_135052_a((String)"fml.menu.mods.search", (Object[])new Object[0]);
    private static final int searchLabelWidth = fontRenderer.func_78256_a(searchLabel);
    private static final int renderColor = 0xFFDD00;
    private GuiTextField search;
    private String lastFilterText = "";
    private List<GuiConfigEntries.IConfigEntry> filteredList;
    private final GuiConfig parent;

    public GuiFilteredConfigEntries(GuiConfig parent, Minecraft mc) {
        super(parent, mc);
        this.parent = parent;
        this.filteredList = this.listEntries;
    }

    public void initGui() {
        super.initGui();
        int w = 240;
        int y = (this.parent.field_146294_l - 240 - searchLabelWidth - 10) / 2 + searchLabelWidth + 5;
        this.search = new GuiTextField(0, fontRenderer, y, this.field_148153_b, 240, 14);
        this.search.func_146180_a(this.lastFilterText);
        this.search.func_146195_b(false);
        this.search.func_146205_d(true);
        this.field_148153_b = this.owningScreen.titleLine2 != null ? 53 : 43;
    }

    protected void filterText() {
        this.lastFilterText = this.search.func_146179_b();
        if (StringUtils.isEmpty((CharSequence)this.lastFilterText)) {
            this.filteredList = this.listEntries;
        } else {
            this.filteredList = new ArrayList<GuiConfigEntries.IConfigEntry>();
            String filter = this.lastFilterText.toLowerCase();
            for (GuiConfigEntries.IConfigEntry e : this.listEntries) {
                IConfigElement ce = e.getConfigElement();
                String trans = I18n.func_135052_a((String)ce.getLanguageKey(), (Object[])new Object[0]);
                if (trans.equals(ce.getLanguageKey())) {
                    trans = ce.getName();
                }
                if (!trans.toLowerCase().contains(filter)) continue;
                this.filteredList.add(e);
            }
        }
    }

    public boolean func_148179_a(int x, int y, int button) {
        boolean result = super.func_148179_a(x, y, button);
        result |= this.search.func_146192_a(x, y, button);
        if (button == 1 && x >= this.search.field_146209_f && x < this.search.field_146209_f + this.search.field_146218_h && y >= this.search.field_146210_g && y < this.search.field_146210_g + this.search.field_146219_i) {
            this.search.func_146180_a("");
        }
        return result;
    }

    public void mouseClickedPassThru(int mouseX, int mouseY, int mouseEvent) {
        for (GuiConfigEntries.IConfigEntry entry : this.filteredList) {
            entry.mouseClicked(mouseX, mouseY, mouseEvent);
        }
    }

    public void keyTyped(char c, int keyCode) {
        for (GuiConfigEntries.IConfigEntry entry : this.filteredList) {
            entry.keyTyped(c, keyCode);
        }
        this.search.func_146201_a(c, keyCode);
    }

    public void updateScreen() {
        for (GuiConfigEntries.IConfigEntry entry : this.filteredList) {
            entry.updateCursorCounter();
        }
        this.search.func_146178_a();
        if (!this.search.func_146179_b().equals(this.lastFilterText)) {
            this.filterText();
        }
    }

    public int func_148127_b() {
        return this.filteredList.size();
    }

    public GuiConfigEntries.IConfigEntry getListEntry(int index) {
        return this.filteredList.get(index);
    }

    public void func_148128_a(int mouseX, int mouseY, float partialTicks) {
        super.func_148128_a(mouseX, mouseY, partialTicks);
        int w = 240;
        int x = (this.parent.field_146294_l - 240 - searchLabelWidth - 10) / 2;
        fontRenderer.func_78276_b(searchLabel, x, this.field_148153_b - 18, 0xFFDD00);
        this.search.func_146194_f();
    }

    public void drawScreenPost(int mouseX, int mouseY, float partialTicks) {
        for (GuiConfigEntries.IConfigEntry entry : this.filteredList) {
            entry.drawToolTip(mouseX, mouseY);
        }
    }
}

