/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.enums.EnumPowerStage;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.MjAPI;
import buildcraft.energy.BCEnergyGuis;
import buildcraft.lib.delta.DeltaInt;
import buildcraft.lib.delta.DeltaManager;
import buildcraft.lib.engine.EngineConnector;
import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEngineStone_BC8
extends TileEngineBase_BC8 {
    private static final long MAX_OUTPUT = MjAPI.MJ;
    private static final long MIN_OUTPUT = MAX_OUTPUT / 3L;
    private static final float kp = 1.0f;
    private static final float ki = 0.05f;
    private static final long eLimit = (MAX_OUTPUT - MIN_OUTPUT) * 20L;
    public final DeltaInt deltaFuelLeft;
    public final ItemHandlerSimple invFuel;
    int burnTime;
    int totalBurnTime;
    long esum;
    private boolean isForceInserting;

    public TileEngineStone_BC8() {
        this.deltaFuelLeft = this.deltaManager.addDelta("fuel_left", DeltaManager.EnumNetworkVisibility.GUI_ONLY);
        this.burnTime = 0;
        this.totalBurnTime = 0;
        this.esum = 0L;
        this.isForceInserting = false;
        this.invFuel = this.itemManager.addInvHandler("fuel", 1, this::isValidFuel, ItemHandlerManager.EnumAccess.BOTH, EnumPipePart.VALUES);
    }

    private boolean isValidFuel(int slot, ItemStack stack) {
        return this.isForceInserting || TileEngineStone_BC8.getItemBurnTime(stack) > 0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.burnTime = nbt.func_74762_e("burnTime");
        this.totalBurnTime = nbt.func_74762_e("totalBurnTime");
        this.esum = nbt.func_74763_f("esum");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("totalBurnTime", this.totalBurnTime);
        nbt.func_74772_a("esum", this.esum);
        return nbt;
    }

    protected void onSlotChange(IItemHandlerModifiable handler, int slot, @Nonnull ItemStack before, @Nonnull ItemStack after) {
        if (handler == this.invFuel && this.isForceInserting && after.func_190926_b()) {
            this.isForceInserting = false;
        }
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K) {
            BCEnergyGuis.ENGINE_STONE.openGUI(player, this.func_174877_v());
        }
        return true;
    }

    @Nonnull
    protected IMjConnector createConnector() {
        return new EngineConnector(false);
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    protected void engineUpdate() {
        super.engineUpdate();
        if (this.burnTime > 0) {
            --this.burnTime;
            if (this.getPowerStage() != EnumPowerStage.OVERHEAT) {
                long output;
                this.currentOutput = output = this.getCurrentOutput();
                this.addPower(output);
            }
        }
    }

    public void burn() {
        if (this.burnTime == 0 && this.isRedstonePowered) {
            this.burnTime = this.totalBurnTime = TileEngineStone_BC8.getItemBurnTime(this.invFuel.getStackInSlot(0));
            if (this.burnTime > 0) {
                this.deltaFuelLeft.setValue(100);
                this.deltaFuelLeft.addDelta(0L, (long)this.totalBurnTime, -100);
                ItemStack fuel = this.invFuel.extractItem(0, 1, false);
                ItemStack container = fuel.func_77973_b().getContainerItem(fuel);
                if (!container.func_190926_b()) {
                    if (this.invFuel.getStackInSlot(0).func_190926_b()) {
                        this.isForceInserting = false;
                        ItemStack leftover = this.invFuel.insert(container, false, false);
                        if (!leftover.func_190926_b()) {
                            this.isForceInserting = true;
                            this.invFuel.setStackInSlot(0, leftover);
                        }
                    } else {
                        InventoryUtil.addToBestAcceptor((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), null, (ItemStack)container);
                    }
                }
            }
        }
    }

    private static int getItemBurnTime(ItemStack itemstack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack);
    }

    public long maxPowerReceived() {
        return 200L * MjAPI.MJ;
    }

    public long maxPowerExtracted() {
        return 100L * MjAPI.MJ;
    }

    public long getMaxPower() {
        return 1000L * MjAPI.MJ;
    }

    public float explosionRange() {
        return 2.0f;
    }

    public long getCurrentOutput() {
        long e = 3L * this.getMaxPower() / 8L - this.power;
        this.esum = TileEngineStone_BC8.clamp(this.esum + e, -eLimit, eLimit);
        return TileEngineStone_BC8.clamp(e + this.esum / 20L, MIN_OUTPUT, MAX_OUTPUT);
    }

    private static long clamp(long val, long min, long max) {
        return Math.max(min, Math.min(max, val));
    }

    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        super.getDebugInfo(left, right, side);
        left.add("esum = " + MjAPI.formatMj((long)this.esum) + " M");
        long e = 3L * this.getMaxPower() / 8L - this.power;
        left.add("output = " + MjAPI.formatMj((long)TileEngineStone_BC8.clamp(e + this.esum / 20L, MIN_OUTPUT, MAX_OUTPUT)) + " MJ");
        left.add("burnTime = " + this.burnTime);
        left.add("delta = " + this.deltaFuelLeft.getDynamic(0.0f));
    }
}

