/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.BCModules;
import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IRefineryRecipeManager;
import buildcraft.energy.BCEnergyFluids;
import buildcraft.lib.fluid.BCFluid;
import buildcraft.lib.misc.MathUtil;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BCEnergyRecipes {
    private static final int TIME_BASE = 240000;

    public static void init() {
        BuildcraftFuelRegistry.coolant.addCoolant(FluidRegistry.WATER, 0.0023f);
        BuildcraftFuelRegistry.coolant.addSolidCoolant(new ItemStack(Blocks.field_150432_aD), new FluidStack(FluidRegistry.WATER, 1000), 1.5f);
        BuildcraftFuelRegistry.coolant.addSolidCoolant(new ItemStack(Blocks.field_150403_cj), new FluidStack(FluidRegistry.WATER, 1000), 2.0f);
        int _oil = 8;
        int _gas = 16;
        int _light = 4;
        int _dense = 2;
        boolean _residue = true;
        int _gas_light = 10;
        int _light_dense = 5;
        int _dense_residue = 2;
        int _light_dense_residue = 3;
        int _gas_light_dense = 8;
        BCEnergyRecipes.addFuel((Fluid[])BCEnergyFluids.fuelGaseous, 16, 8, 4);
        BCEnergyRecipes.addFuel((Fluid[])BCEnergyFluids.fuelLight, 4, 6, 6);
        BCEnergyRecipes.addFuel((Fluid[])BCEnergyFluids.fuelDense, 2, 4, 12);
        BCEnergyRecipes.addFuel((Fluid[])BCEnergyFluids.fuelMixedLight, 10, 3, 5);
        BCEnergyRecipes.addFuel((Fluid[])BCEnergyFluids.fuelMixedHeavy, 5, 5, 8);
        BCEnergyRecipes.addDirtyFuel((Fluid[])BCEnergyFluids.oilDense, 2, 4, 4);
        BCEnergyRecipes.addFuel((Fluid[])BCEnergyFluids.oilDistilled, 8, 1, 5);
        BCEnergyRecipes.addDirtyFuel((Fluid[])BCEnergyFluids.oilHeavy, 3, 2, 4);
        BCEnergyRecipes.addDirtyFuel((Fluid[])BCEnergyFluids.crudeOil, 8, 3, 4);
        if (BCModules.FACTORY.isLoaded()) {
            FluidStack[] gas_light_dense_residue = BCEnergyRecipes.createFluidStack((Fluid[])BCEnergyFluids.crudeOil, 8);
            FluidStack[] gas_light_dense = BCEnergyRecipes.createFluidStack((Fluid[])BCEnergyFluids.oilDistilled, 8);
            FluidStack[] gas_light = BCEnergyRecipes.createFluidStack((Fluid[])BCEnergyFluids.fuelMixedLight, 10);
            FluidStack[] gas = BCEnergyRecipes.createFluidStack((Fluid[])BCEnergyFluids.fuelGaseous, 16);
            FluidStack[] light_dense_residue = BCEnergyRecipes.createFluidStack((Fluid[])BCEnergyFluids.oilHeavy, 3);
            FluidStack[] light_dense = BCEnergyRecipes.createFluidStack((Fluid[])BCEnergyFluids.fuelMixedHeavy, 5);
            FluidStack[] light = BCEnergyRecipes.createFluidStack((Fluid[])BCEnergyFluids.fuelLight, 4);
            FluidStack[] dense_residue = BCEnergyRecipes.createFluidStack((Fluid[])BCEnergyFluids.oilDense, 2);
            FluidStack[] dense = BCEnergyRecipes.createFluidStack((Fluid[])BCEnergyFluids.fuelDense, 2);
            FluidStack[] residue = BCEnergyRecipes.createFluidStack((Fluid[])BCEnergyFluids.oilResidue, 1);
            BCEnergyRecipes.addDistillation(gas_light_dense_residue, gas, light_dense_residue, 0, 32L * MjAPI.MJ);
            BCEnergyRecipes.addDistillation(gas_light_dense_residue, gas_light, dense_residue, 1, 16L * MjAPI.MJ);
            BCEnergyRecipes.addDistillation(gas_light_dense_residue, gas_light_dense, residue, 2, 12L * MjAPI.MJ);
            BCEnergyRecipes.addDistillation(gas_light_dense, gas, light_dense, 0, 24L * MjAPI.MJ);
            BCEnergyRecipes.addDistillation(gas_light_dense, gas_light, dense, 1, 16L * MjAPI.MJ);
            BCEnergyRecipes.addDistillation(gas_light, gas, light, 0, 24L * MjAPI.MJ);
            BCEnergyRecipes.addDistillation(light_dense_residue, light, dense_residue, 1, 16L * MjAPI.MJ);
            BCEnergyRecipes.addDistillation(light_dense_residue, light_dense, residue, 2, 12L * MjAPI.MJ);
            BCEnergyRecipes.addDistillation(light_dense, light, dense, 1, 16L * MjAPI.MJ);
            BCEnergyRecipes.addDistillation(dense_residue, dense, residue, 2, 12L * MjAPI.MJ);
            BCEnergyRecipes.addHeatExchange(BCEnergyFluids.crudeOil);
            BCEnergyRecipes.addHeatExchange(BCEnergyFluids.oilDistilled);
            BCEnergyRecipes.addHeatExchange(BCEnergyFluids.oilHeavy);
            BCEnergyRecipes.addHeatExchange(BCEnergyFluids.fuelMixedLight);
            BCEnergyRecipes.addHeatExchange(BCEnergyFluids.fuelMixedHeavy);
            BCEnergyRecipes.addHeatExchange(BCEnergyFluids.oilDense);
            BCEnergyRecipes.addHeatExchange(BCEnergyFluids.fuelGaseous);
            BCEnergyRecipes.addHeatExchange(BCEnergyFluids.fuelLight);
            BCEnergyRecipes.addHeatExchange(BCEnergyFluids.fuelDense);
            BCEnergyRecipes.addHeatExchange(BCEnergyFluids.oilResidue);
            FluidStack water = new FluidStack(FluidRegistry.WATER, 10);
            BuildcraftRecipeRegistry.refineryRecipes.addHeatableRecipe(water, null, 0, 1);
            FluidStack lava = new FluidStack(FluidRegistry.LAVA, 5);
            BuildcraftRecipeRegistry.refineryRecipes.addCoolableRecipe(lava, null, 4, 2);
        }
    }

    private static FluidStack[] createFluidStack(Fluid[] fluid, int amount) {
        FluidStack[] arr = new FluidStack[fluid.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new FluidStack(fluid[i], amount);
        }
        return arr;
    }

    private static Fluid getFirstOrNull(Fluid[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array[0];
    }

    private static void addFuel(Fluid[] in, int amountDiff, int multiplier, int boostOver4) {
        Fluid fuel = BCEnergyRecipes.getFirstOrNull(in);
        if (fuel == null) {
            return;
        }
        long powerPerCycle = (long)multiplier * MjAPI.MJ;
        int totalTime = 240000 * boostOver4 / 4 / multiplier / amountDiff;
        BuildcraftFuelRegistry.fuel.addFuel(fuel, powerPerCycle, totalTime);
    }

    private static void addDirtyFuel(Fluid[] in, int amountDiff, int multiplier, int boostOver4) {
        Fluid fuel = BCEnergyRecipes.getFirstOrNull(in);
        if (fuel == null) {
            return;
        }
        long powerPerCycle = (long)multiplier * MjAPI.MJ / 4L;
        int totalTime = 240000 * boostOver4 / 4 / multiplier / amountDiff;
        Fluid residue = BCEnergyRecipes.getFirstOrNull((Fluid[])BCEnergyFluids.oilResidue);
        if (residue == null) {
            BuildcraftFuelRegistry.fuel.addFuel(fuel, powerPerCycle, totalTime);
        } else {
            BuildcraftFuelRegistry.fuel.addDirtyFuel(fuel, powerPerCycle, totalTime, new FluidStack(residue, 1000 / amountDiff));
        }
    }

    private static void addDistillation(FluidStack[] in, FluidStack[] outGas, FluidStack[] outLiquid, int heat, long mjCost) {
        FluidStack _in = in[heat];
        FluidStack _outGas = outGas[heat];
        FluidStack _outLiquid = outLiquid[heat];
        IRefineryRecipeManager.IDistillationRecipe existing = (IRefineryRecipeManager.IDistillationRecipe)BuildcraftRecipeRegistry.refineryRecipes.getDistillationRegistry().getRecipeForInput(_in);
        if (existing != null) {
            throw new IllegalStateException("Already added distillation recipe for " + _in.getFluid().getName());
        }
        int hcf = MathUtil.findHighestCommonFactor((int)_in.amount, (int)_outGas.amount);
        if ((hcf = MathUtil.findHighestCommonFactor((int)hcf, (int)_outLiquid.amount)) > 1) {
            _in = _in.copy();
            _in.amount /= hcf;
            _outGas = _outGas.copy();
            _outGas.amount /= hcf;
            _outLiquid = _outLiquid.copy();
            _outLiquid.amount /= hcf;
            mjCost /= (long)hcf;
        }
        BuildcraftRecipeRegistry.refineryRecipes.addDistillationRecipe(_in, _outGas, _outLiquid, mjCost);
    }

    private static void addHeatExchange(BCFluid[] fluid) {
        for (int i = 0; i < fluid.length - 1; ++i) {
            BCFluid cool = fluid[i];
            BCFluid hot = fluid[i + 1];
            FluidStack cool_f = new FluidStack((Fluid)cool, 10);
            FluidStack hot_f = new FluidStack((Fluid)hot, 10);
            int ch = cool.getHeatValue();
            int hh = hot.getHeatValue();
            BuildcraftRecipeRegistry.refineryRecipes.addHeatableRecipe(cool_f, hot_f, ch, hh);
            BuildcraftRecipeRegistry.refineryRecipes.addCoolableRecipe(hot_f, cool_f, hh, ch);
        }
    }
}

