/*
 * Decompiled with CFR 0.152.
 */
package team.chisel;

import com.google.common.base.Predicate;
import java.beans.ConstructorProperties;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import team.chisel.Chisel;
import team.chisel.api.block.BlockCreator;
import team.chisel.api.block.BlockProvider;
import team.chisel.api.block.ChiselBlockFactory;
import team.chisel.api.block.VariationData;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.client.handler.BlockSpeedHandler;
import team.chisel.client.sound.ChiselSoundTypes;
import team.chisel.common.block.BlockAutoChisel;
import team.chisel.common.block.BlockCarvable;
import team.chisel.common.block.BlockCarvableCarpet;
import team.chisel.common.block.BlockCarvableIce;
import team.chisel.common.block.BlockCarvablePane;
import team.chisel.common.block.ItemChiselBlock;
import team.chisel.common.block.TileAutoChisel;
import team.chisel.common.carving.Carving;
import team.chisel.common.config.Configurations;
import team.chisel.common.init.ChiselBlocks;
import team.chisel.common.init.ChiselItems;
import team.chisel.common.init.ChiselSounds;
import team.chisel.common.item.ItemChisel;
import team.chisel.common.item.ItemOffsetTool;
import team.chisel.common.util.GenerationHandler;

@Mod.EventBusSubscriber
public enum Features {
    ALUMINUM{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockAluminum", null, beaconBaseProvider).setParentFolder("metals/aluminum").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockAluminum").build(b -> b.func_149672_a(SoundType.field_185852_e).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockAluminum");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Aluminum");
        }
    }
    ,
    ANDESITE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState stone = Blocks.field_150348_b.func_176223_P();
            PropertyEnum prop = BlockStone.field_176247_a;
            Carving.chisel.addVariation("andesite", CarvingUtils.variationFor(stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.ANDESITE), -21));
            Carving.chisel.addVariation("andesite", CarvingUtils.variationFor(stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH), -20));
            factory.newBlock(Material.field_151576_e, "andesite", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").addOreDict("stoneAndesite").addOreDict("stoneAndesitePolished").build(b -> b.func_149711_c(1.5f).func_149752_b(30.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    ANTIBLOCK{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "antiblock", provider).newVariation("black").next("red").next("green").next("brown").next("blue").next("purple").next("cyan").next("silver").next("gray").next("pink").next("lime").next("yellow").next("light_blue").next("magenta").next("orange").next("white").build();
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.antiblock, 8, 15), "SSS", "SGS", "SSS", Character.valueOf('S'), "stone", Character.valueOf('G'), "dustGlowstone");
        }
    }
    ,
    ARCANE_STONE("thaumcraft"){

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "arcane_stone", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("raw").build(b -> b.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Carving.chisel.addVariation("arcane_stone", CarvingUtils.variationFor(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("thaumcraft", "stone_arcane"))).func_176223_P(), -64));
            Carving.chisel.addVariation("arcane_stone", CarvingUtils.variationFor(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("thaumcraft", "stone_arcane_brick"))).func_176223_P(), -63));
        }
    }
    ,
    AUTOCHISEL{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            String name = "auto_chisel";
            factory.getRegistry().register(new BlockAutoChisel().setRegistryName(name));
            GameRegistry.registerTileEntity(TileAutoChisel.class, (String)("chisel:" + name));
        }

        @Override
        void addItems(IForgeRegistry<Item> registry) {
            registry.register(new ItemBlock((Block)ChiselBlocks.auto_chisel).setRegistryName(ChiselBlocks.auto_chisel.getRegistryName()));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, ChiselBlocks.auto_chisel, "GGG", "GRG", "III", Character.valueOf('G'), "blockGlass", Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "ingotIron");
        }
    }
    ,
    BASALT{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "basalt", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("raw").setOrder(-100).addOreDict("stoneBasalt").addOreDict("stoneBasaltPolished").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            if (!Configurations.basaltSpecialGen) {
                GenerationHandler.INSTANCE.addGeneration(ChiselBlocks.basalt2.func_176223_P().func_177226_a((IProperty)ChiselBlocks.basalt2.getMetaProp(), (Comparable)Integer.valueOf(7)), new GenerationHandler.WorldGenInfo(Configurations.basaltVeinAmount, 0, 32, 1.0, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)));
            }
        }
    }
    ,
    BLOOD_MAGIC("bloodmagic"){

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "bloodMagic", provider).newVariation("bloodRuneArranged").next("bloodRuneBricks").next("bloodRuneCarved").next("bloodRuneCarvedRadial").next("bloodRuneClassicPanel").next("bloodRuneTiles").build();
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Carving.chisel.addVariation("bloodMagic", CarvingUtils.variationFor(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("bloodmagic", "blood_rune"))).func_176223_P(), -64));
        }
    }
    ,
    BOOKSHELF{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            String[] woodTypes = new String[]{"Oak", "Spruce", "Birch", "Jungle", "Acacia", "DarkOak"};
            Carving.chisel.addVariation("bookshelf_oak", CarvingUtils.variationFor(Blocks.field_150342_X.func_176223_P(), -1));
            BlockCreator<BlockCarvable> bookshelfCreator = (mat, index, maxVariation, data) -> new BlockCarvable(mat, index, maxVariation, data){

                public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
                    Blocks.field_150342_X.getDrops(drops, world, pos, state, fortune);
                }

                public float getEnchantPowerBonus(World world, BlockPos pos) {
                    return 1.0f;
                }
            };
            for (String woodType : woodTypes) {
                factory.newBlock(Material.field_151575_d, "bookshelf_" + woodType.toLowerCase(), new ChiselBlockProvider<BlockCarvable>(bookshelfCreator, BlockCarvable.class)).newVariation("rainbow").next("necromancer-novice").next("necromancer").next("redtomes").next("abandoned").next("hoarder").next("brim").next("historician").next("cans").next("papers").addOreDict("bookshelf").addOreDict("bookshelf" + woodType).build(b -> b.func_149672_a(SoundType.field_185848_a).func_149711_c(1.5f));
            }
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            BlockCarvable[] bookshelves = new BlockCarvable[]{ChiselBlocks.bookshelf_spruce, ChiselBlocks.bookshelf_birch, ChiselBlocks.bookshelf_jungle, ChiselBlocks.bookshelf_acacia, ChiselBlocks.bookshelf_darkoak};
            Block[] stairs = new Block[]{Blocks.field_150485_bF, Blocks.field_150487_bG, Blocks.field_150481_bH, Blocks.field_150400_ck, Blocks.field_150401_cl};
            for (int c = 0; c < bookshelves.length; ++c) {
                Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "bookshelf" + c, new ItemStack((Block)bookshelves[c], 1), new Object[]{"S S", "BBB", "S S", Character.valueOf('S'), new ItemStack(stairs[c], 1), Character.valueOf('B'), new ItemStack(Items.field_151122_aG, 1)});
            }
        }
    }
    ,
    BRICKS{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("bricks", CarvingUtils.variationFor(Blocks.field_150336_V.func_176223_P(), -1));
            factory.newBlock(Material.field_151576_e, "bricks", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-solid").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    BRONZE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockBronze", null, beaconBaseProvider).setParentFolder("metals/bronze").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockBronze").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockBronze");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Bronze");
        }
    }
    ,
    BROWNSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "brownstone", new ChiselBlockProvider<BlockCarvable>(creator, BlockCarvable.class)).newVariation("default").next("block").next("doubleslab").next("blocks").next("weathered").next("weathered-block").next("weathered-doubleslab").next("weathered-blocks").next("weathered-half").next("weathered-block-half").build(b -> {
                b.func_149672_a(SoundType.field_185851_d).func_149711_c(1.0f);
                BlockSpeedHandler.speedupBlocks.add((Block)b);
            });
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.brownstone, 4, 0), " S ", "SCS", " S ", Character.valueOf('S'), "sandstone", Character.valueOf('C'), new ItemStack(Items.field_151119_aD, 1));
        }
    }
    ,
    CERTUS("appliedenergistics2"){

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "certus", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").next("raw").build(b -> b.func_149711_c(0.8f).func_149752_b(4.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Carving.chisel.addVariation("certus", CarvingUtils.variationFor(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("appliedenergistics2", "quartz_block"))).func_176223_P(), -64));
            Carving.chisel.addVariation("certus", CarvingUtils.variationFor(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("appliedenergistics2", "quartz_pillar"))).func_176223_P(), -63));
            Carving.chisel.addVariation("certus", CarvingUtils.variationFor(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("appliedenergistics2", "chiseled_quartz_block"))).func_176223_P(), -62));
        }
    }
    ,
    CARPET{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState carpet = Blocks.field_150404_cg.func_176223_P();
            PropertyEnum prop = BlockCarpet.field_176330_a;
            for (int c = 0; c < dyeColors.length; ++c) {
                Carving.chisel.addVariation("carpet_" + dyeColors[c].toLowerCase(), CarvingUtils.variationFor(carpet.func_177226_a((IProperty)prop, (Comparable)EnumDyeColor.func_176766_a((int)c)), -1));
                factory.newBlock(Material.field_151593_r, "carpet_" + dyeColors[c].toLowerCase(), new ChiselBlockProvider<BlockCarvableCarpet>(BlockCarvableCarpet::new, BlockCarvableCarpet.class)).opaque(false).setParentFolder("carpet").newVariation("legacy_" + dyeColors[c].toLowerCase()).next("llama_" + dyeColors[c].toLowerCase()).build(b -> b.func_149672_a(SoundType.field_185854_g).func_149711_c(0.1f).func_149713_g(0));
            }
        }
    }
    ,
    CHARCOAL{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "block_charcoal", null, provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").next("raw").addOreDict("blockCharcoal").build(b -> b.func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            CarvingUtils.addOreGroup("blockCharcoal");
        }

        @Override
        void addItems(IForgeRegistry<Item> registry) {
            OreDictionary.registerOre((String)"charcoal", (ItemStack)new ItemStack(Items.field_151044_h, 1, 1));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "charcoal_uncraft", new ItemStack(Items.field_151044_h, 9, 1), new Object[]{"X", Character.valueOf('X'), "blockCharcoal"});
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.block_charcoal2, 1, 1), "XXX", "XXX", "XXX", Character.valueOf('X'), "charcoal");
        }
    }
    ,
    CHISEL{

        @Override
        void addItems(IForgeRegistry<Item> registry) {
            registry.register((IForgeRegistryEntry)new ItemChisel(ItemChisel.ChiselType.IRON));
            registry.register((IForgeRegistryEntry)new ItemChisel(ItemChisel.ChiselType.DIAMOND));
            registry.register((IForgeRegistryEntry)new ItemChisel(ItemChisel.ChiselType.HITECH));
            registry.register((IForgeRegistryEntry)new ItemOffsetTool());
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            if (!Configurations.chiselRecipe) {
                Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "chisel_iron", ChiselItems.chisel_iron, new Object[]{" x", "s ", Character.valueOf('x'), "ingotIron", Character.valueOf('s'), "stickWood"});
                Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "chisel_diamond", ChiselItems.chisel_diamond, new Object[]{" x", "s ", Character.valueOf('x'), "gemDiamond", Character.valueOf('s'), "stickWood"});
            } else {
                Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "chisel_iron", ChiselItems.chisel_iron, new Object[]{" xx", " xx", "s  ", Character.valueOf('x'), "ingotIron", Character.valueOf('s'), "stickWood"});
                Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "chisel_diamond", ChiselItems.chisel_diamond, new Object[]{" xx", " xx", "s  ", Character.valueOf('x'), "gemDiamond", Character.valueOf('s'), "stickWood"});
            }
            Features.addShapelessRecipe((IForgeRegistry<IRecipe>)registry, "chisel_hitech", ChiselItems.chisel_hitech, new Object[]{ChiselItems.chisel_diamond, "dustRedstone", "ingotGold"});
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "offsettool", ChiselItems.offsettool, new Object[]{"-o", "|-", Character.valueOf('o'), Items.field_151079_bi, Character.valueOf('|'), "stickWood", Character.valueOf('-'), "ingotIron"});
        }
    }
    ,
    CLOUD{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151580_n, "cloud", provider).opaque(false).newVariation("cloud").next("large").next("small").next("vertical").next("grid").build(b -> b.func_149672_a(SoundType.field_185854_g).func_149711_c(0.3f));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.cloud, 32, 0), " S ", "S S", " S ", Character.valueOf('S'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        }
    }
    ,
    COBALT{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockCobalt", null, beaconBaseProvider).setParentFolder("metals/cobalt").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockCobalt").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockCobalt");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Cobalt");
        }
    }
    ,
    COBBLESTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("cobblestone", CarvingUtils.variationFor(Blocks.field_150347_e.func_176223_P(), -20));
            factory.newBlock(Material.field_151576_e, "cobblestone", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("emboss").next("indent").next("marker").addOreDict("cobblestone").build(b -> b.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    COAL{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "block_coal", null, provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").next("raw").addOreDict("blockCoal").build(b -> b.func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            CarvingUtils.addOreGroup("blockCoal");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack(Items.field_151044_h, 9), "X", Character.valueOf('X'), "blockCoal");
        }
    }
    ,
    COAL_COKE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "block_coal_coke", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").next("raw").addOreDict("blockFuelCoke").addOreDict("blockCoalCoke").build(b -> b.func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            CarvingUtils.addOreGroup("blockCoalCoke");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerOreUncraftRecipe((IForgeRegistry<IRecipe>)registry, "blockFuelCoke", "fuelCoke");
        }
    }
    ,
    COBBLESTONEMOSSY{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("cobblestonemossy", CarvingUtils.variationFor(Blocks.field_150341_Y.func_176223_P(), -1));
            factory.newBlock(Material.field_151576_e, "cobblestonemossy", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").addOreDict("blockMossy").build(b -> b.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    CONCRETE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            for (int i = 0; i < dyeColors.length; ++i) {
                Carving.chisel.addVariation("concrete_" + dyeColors[i].toLowerCase(), CarvingUtils.variationFor(Blocks.field_192443_dR.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.func_176766_a((int)i)), -1));
                factory.newBlock(Material.field_151576_e, "concrete_" + dyeColors[i].toLowerCase(), provider).setParentFolder("concrete_" + dyeColors[i].toLowerCase()).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").addOreDict("blockConcrete").addOreDict("blockConcrete" + dyeColors[i]).build(b -> {
                    b.func_149672_a(SoundType.field_185851_d).func_149711_c(1.5f);
                    BlockSpeedHandler.speedupBlocks.add((Block)b);
                });
            }
            BlockSpeedHandler.speedupBlocks.add(Blocks.field_192443_dR);
        }
    }
    ,
    COPPER{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockCopper", null, beaconBaseProvider).setParentFolder("metals/copper").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockCopper").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockCopper");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Copper");
        }
    }
    ,
    DIAMOND{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "diamond", null, beaconBaseProvider).newVariation("terrain-diamond-embossed").next("terrain-diamond-gem").next("terrain-diamond-cells").next("terrain-diamond-space").next("terrain-diamond-spaceblack").next("terrain-diamond-simple").next("terrain-diamond-bismuth").next("terrain-diamond-crushed").next("terrain-diamond-four").next("terrain-diamond-fourornate").next("terrain-diamond-zelda").next("terrain-diamond-ornatelayer").addOreDict("blockDiamond").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 2));
            CarvingUtils.addOreGroup("blockDiamond");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack(Items.field_151045_i, 9), "X", Character.valueOf('X'), "blockDiamond");
        }
    }
    ,
    DIORITE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState stone = Blocks.field_150348_b.func_176223_P();
            PropertyEnum prop = BlockStone.field_176247_a;
            Carving.chisel.addVariation("diorite", CarvingUtils.variationFor(stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.DIORITE), -21));
            Carving.chisel.addVariation("diorite", CarvingUtils.variationFor(stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.DIORITE_SMOOTH), -20));
            factory.newBlock(Material.field_151576_e, "diorite", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").addOreDict("stoneDiorite").addOreDict("stoneDioritePolished").build(b -> b.func_149711_c(1.5f).func_149752_b(30.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    DIRT{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("dirt", CarvingUtils.variationFor(Blocks.field_150346_d.func_176223_P(), -1));
            Carving.chisel.setVariationSound("dirt", ChiselSounds.dirt_chisel);
            factory.newBlock(Material.field_151578_c, "dirt", new ChiselBlockProvider<BlockCarvable>(BlockCarvable::new, BlockCarvable.class)).newVariation("bricks").next("netherbricks").next("bricks3").next("cobble").next("reinforcedCobbleDirt").next("reinforcedDirt").next("happy").next("bricks2").next("bricks+dirt2").next("hor").next("vert").next("layers").next("vertical").next("chunky").next("horizontal").next("plate").addOreDict("dirt").build(b -> b.func_149672_a(SoundType.field_185849_b).func_149711_c(0.5f).setHarvestLevel("shovel", 0));
        }
    }
    ,
    ELECTRUM{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockElectrum", null, beaconBaseProvider).setParentFolder("metals/electrum").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockElectrum").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockElectrum");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Electrum");
        }
    }
    ,
    EMERALD{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "emerald", null, beaconBaseProvider).newVariation("panel").next("panelclassic").next("smooth").next("chunk").next("goldborder").next("zelda").next("cell").next("cellbismuth").next("four").next("fourornate").next("ornate").next("masonryEmerald").next("emeraldCircle").next("emeraldPrismatic").addOreDict("blockEmerald").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).func_149752_b(10.0f).setHarvestLevel("pickaxe", 2));
            CarvingUtils.addOreGroup("blockEmerald");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack(Items.field_151166_bC, 9), "X", Character.valueOf('X'), "blockEmerald");
        }
    }
    ,
    END_PURPUR{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState purpur_pillar = Blocks.field_185768_cU.func_176223_P();
            PropertyEnum prop = BlockRotatedPillar.field_176298_M;
            Carving.chisel.addVariation("purpur", CarvingUtils.variationFor(Blocks.field_185767_cT.func_176223_P(), -5));
            Carving.chisel.addVariation("purpur", CarvingUtils.variationFor(purpur_pillar.func_177226_a((IProperty)prop, (Comparable)EnumFacing.Axis.Y), -3));
            factory.newBlock(Material.field_151576_e, "purpur", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-solid").next("bricks-small").next("circular").next("twisted").next("prism").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    ENDSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("endstone", CarvingUtils.variationFor(Blocks.field_150377_bs.func_176223_P(), -21));
            Carving.chisel.addVariation("endstone", CarvingUtils.variationFor(Blocks.field_185772_cY.func_176223_P(), -20));
            factory.newBlock(Material.field_151576_e, "endstone", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").addOreDict("endstone").build(b -> b.setDragonProof().func_149711_c(3.0f).func_149752_b(15.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    FACTORY{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "factory", provider).newVariation("dots").next("rust2").next("rust").next("platex").next("wireframewhite").next("wireframe").next("hazard").next("hazardorange").next("circuit").next("metalbox").next("goldplate").next("goldplating").next("grinder").next("plating").next("rustplates").next("column").next("frameblue").next("iceiceice").next("tilemosaic").next("vent").next("wireframeblue").build(b -> b.func_149672_a(ChiselSoundTypes.METAL));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.factory, Configurations.factoryBlockAmount, 0), "SXS", "X X", "SXS", Character.valueOf('X'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('S'), new ItemStack(Items.field_151042_j, 1));
        }
    }
    ,
    FUTURA{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "futura", provider).newVariation("screenMetallic").next("screenCyan").next("controller").next("wavy").next("controllerPurple").next("uberWavy").build(b -> b.func_149672_a(SoundType.field_185852_e));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.futura, 8, 0), "SSS", "SGS", "SSS", Character.valueOf('S'), "stone", Character.valueOf('G'), "dustRedstone");
        }
    }
    ,
    GLASS{
        private BlockCarvable[] glassBlocks;
        private BlockCarvablePane[] paneBlocks;

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("glass", CarvingUtils.variationFor(Blocks.field_150359_w.func_176223_P(), -20));
            BlockCreator<BlockCarvable> glassCreator = (mat, index, maxVariation, data) -> new BlockCarvable(mat, index, maxVariation, data){

                public int func_149745_a(Random random) {
                    return 0;
                }

                protected boolean func_149700_E() {
                    return true;
                }
            };
            this.glassBlocks = (BlockCarvable[])factory.newBlock(Material.field_151592_s, "glass", new ChiselBlockProvider<BlockCarvable>(glassCreator, BlockCarvable.class)).opaque(false).newVariation("terrain-glassbubble").next("chinese").setOrder(20).next("japanese").setOrder(22).next("terrain-glassdungeon").next("terrain-glasslight").next("terrain-glassnoborder").next("terrain-glass-ornatesteel").next("terrain-glass-screen").next("terrain-glassshale").next("terrain-glass-steelframe").next("terrain-glassstone").next("terrain-glassstreak").next("terrain-glass-thickgrid").next("terrain-glass-thingrid").next("a1-glasswindow-ironfencemodern").next("chrono").next("chinese2").setOrder(21).next("japanese2").setOrder(23).addOreDict("blockGlass").addOreDict("blockGlassColorless").build(b -> b.func_149672_a(SoundType.field_185853_f).func_149711_c(0.3f));
            Carving.chisel.addVariation("glasspane", CarvingUtils.variationFor(Blocks.field_150410_aZ.func_176223_P(), -20));
            this.paneBlocks = (BlockCarvablePane[])factory.newBlock(Material.field_151592_s, "glasspane", new ChiselBlockProvider<BlockCarvablePane>(BlockCarvablePane::noDrop, BlockCarvablePane.class)).newVariation("terrain-glassbubble").next("chinese").setOrder(20).next("japanese").setOrder(22).next("terrain-glassdungeon").next("terrain-glasslight").next("terrain-glassnoborder").next("terrain-glass-ornatesteel").next("terrain-glass-screen").next("terrain-glassshale").next("terrain-glass-steelframe").next("terrain-glassstone").next("terrain-glassstreak").next("terrain-glass-thickgrid").next("terrain-glass-thingrid").next("a1-glasswindow-ironfencemodern").next("chrono").next("chinese2").setOrder(21).next("japanese2").setOrder(23).addOreDict("paneGlass").addOreDict("paneGlassColorless").build(b -> b.func_149672_a(SoundType.field_185853_f).func_149711_c(0.3f));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            for (int i = 0; i < this.paneBlocks.length; ++i) {
                for (int meta = 0; meta < this.glassBlocks[i].getVariations().length; ++meta) {
                    Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, Configurations.featureName(this) + "/" + this.paneBlocks[i].getVariations()[meta].name, new ItemStack((Block)this.paneBlocks[i], 16, meta), new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack((Block)this.glassBlocks[i], 1, meta)});
                }
            }
        }
    }
    ,
    GLASSDYED{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState stainedGlass = Blocks.field_150399_cn.func_176223_P();
            IBlockState stainedGlassPane = Blocks.field_150397_co.func_176223_P();
            PropertyEnum prop = BlockStainedGlass.field_176547_a;
            for (int c = 0; c < dyeColors.length; ++c) {
                final int i = c;
                BlockCreator<BlockCarvable> glassCreator = (mat, index, maxVariation, data) -> new BlockCarvable(mat, index, maxVariation, data){
                    float[] beaconFloats;
                    {
                        super(material, index, max, variations);
                        this.beaconFloats = EnumDyeColor.func_176766_a((int)i).func_193349_f();
                    }

                    public int func_149745_a(Random random) {
                        return 0;
                    }

                    protected boolean func_149700_E() {
                        return true;
                    }

                    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
                        return this.beaconFloats;
                    }
                };
                Carving.chisel.addVariation("glassdyed" + dyeColors[c].toLowerCase(), CarvingUtils.variationFor(stainedGlass.func_177226_a((IProperty)prop, (Comparable)EnumDyeColor.func_176766_a((int)c)), -1));
                factory.newBlock(Material.field_151592_s, "glassdyed" + dyeColors[c].toLowerCase(), new ChiselBlockProvider<BlockCarvable>(glassCreator, BlockCarvable.class)).opaque(false).setParentFolder("glass_stained/" + dyeColors[c].toLowerCase()).newVariation("panel").next("framed").next("framed_fancy").next("streaks").next("rough").next("brick").addOreDict("blockGlass").addOreDict("blockGlass" + dyeColors[c]).build(b -> b.func_149672_a(SoundType.field_185853_f).func_149711_c(0.3f));
                Carving.chisel.addVariation("glasspanedyed" + dyeColors[c].toLowerCase(), CarvingUtils.variationFor(stainedGlassPane.func_177226_a((IProperty)prop, (Comparable)EnumDyeColor.func_176766_a((int)c)), -1));
                factory.newBlock(Material.field_151592_s, "glasspanedyed" + dyeColors[c].toLowerCase(), new ChiselBlockProvider<BlockCarvablePane>((material, index, max, variations) -> new BlockCarvablePane(material, false, index, max, variations){

                    public BlockRenderLayer func_180664_k() {
                        return BlockRenderLayer.TRANSLUCENT;
                    }
                }, BlockCarvablePane.class)).setParentFolder("glasspane_stained/" + dyeColors[c].toLowerCase()).newVariation("panel").next("framed").next("framed_fancy").next("streaks").next("rough").next("brick").addOreDict("paneGlass").addOreDict("paneGlass" + dyeColors[c]).build(b -> b.func_149672_a(SoundType.field_185853_f).func_149711_c(0.3f));
            }
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
        }
    }
    ,
    GLOWSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("glowstone", CarvingUtils.variationFor(Blocks.field_150426_aN.func_176223_P(), -20));
            BlockCreator<BlockCarvable> glowstoneCreator = (mat, index, maxVariation, data) -> new BlockCarvable(mat, index, maxVariation, data){

                public int func_149679_a(int fortune, Random random) {
                    return MathHelper.func_76125_a((int)(this.func_149745_a(random) + random.nextInt(fortune + 1)), (int)1, (int)4);
                }

                public int func_149745_a(Random random) {
                    return 2 + random.nextInt(3);
                }

                @Nullable
                public Item func_180660_a(IBlockState state, Random rand, int fortune) {
                    return Items.field_151114_aO;
                }

                public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
                    Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
                    drops.add((Object)new ItemStack(Items.field_151114_aO, this.quantityDropped(state, fortune, rand)));
                }
            };
            factory.newBlock(Material.field_151592_s, "glowstone", new ChiselBlockProvider<BlockCarvable>(glowstoneCreator, BlockCarvable.class)).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bismuth").next("tiles-large-bismuth").next("tiles-medium-bismuth").next("neon").next("neon-panel").addOreDict("glowstone").build(b -> b.func_149715_a(1.0f).func_149711_c(0.3f).func_149752_b(1.5f).func_149672_a(SoundType.field_185853_f));
        }
    }
    ,
    GOLD{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockGold", null, beaconBaseProvider).setParentFolder("metals/gold").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockGold").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(3.0f).func_149752_b(10.0f).setHarvestLevel("pickaxe", 2));
            factory.newBlock(Material.field_151573_f, "gold", null, beaconBaseProvider).newVariation("terrain-gold-largeingot").next("terrain-gold-smallingot").next("terrain-gold-brick").next("terrain-gold-cart").next("terrain-gold-coin-heads").next("terrain-gold-coin-tails").next("terrain-gold-crate-dark").next("terrain-gold-crate-light").next("terrain-gold-plates").next("terrain-gold-rivets").next("terrain-gold-star").next("terrain-gold-space").next("terrain-gold-spaceblack").next("terrain-gold-simple").addOreDict("blockGold").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(3.0f).func_149752_b(10.0f).setHarvestLevel("pickaxe", 2));
            CarvingUtils.addOreGroup("blockGold");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Gold");
        }
    }
    ,
    GRANITE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState stone = Blocks.field_150348_b.func_176223_P();
            PropertyEnum prop = BlockStone.field_176247_a;
            Carving.chisel.addVariation("granite", CarvingUtils.variationFor(stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.GRANITE), -21));
            Carving.chisel.addVariation("granite", CarvingUtils.variationFor(stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.GRANITE_SMOOTH), -20));
            factory.newBlock(Material.field_151576_e, "granite", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").addOreDict("stoneGranite").addOreDict("stoneGranitePolished").build(b -> b.func_149711_c(1.5f).func_149752_b(30.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    HARDENED_CLAY{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("hardenedclay", CarvingUtils.variationFor(Blocks.field_150405_ch.func_176223_P(), -1));
            factory.newBlock(Material.field_151576_e, "hardenedclay", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").addOreDict("hardenedClay").build(b -> b.func_149711_c(1.25f).func_149752_b(7.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    ICE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("ice", CarvingUtils.variationFor(Blocks.field_150432_aD.func_176223_P(), -1));
            BlockCreator<BlockCarvableIce> iceCreator = BlockCarvableIce::new;
            factory.newBlock(Material.field_151588_w, "ice", new ChiselBlockProvider<BlockCarvableIce>(iceCreator, BlockCarvableIce.class)).opaque(false).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").addOreDict("ice").addOreDict("blockIce").build(b -> b.func_149711_c(0.5f).func_149713_g(3).func_149672_a(SoundType.field_185853_f).setHarvestLevel("pickaxe", 0));
            factory.newBlock(Material.field_151588_w, "icepillar", new ChiselBlockProvider<BlockCarvableIce>(iceCreator, BlockCarvableIce.class)).opaque(false).setGroup("ice").newVariation("plainplain").next("plaingreek").next("greekplain").next("greekgreek").next("convexplain").next("carved").next("ornamental").addOreDict("ice").addOreDict("blockIce").build(b -> b.func_149711_c(0.5f).func_149713_g(3).func_149672_a(SoundType.field_185853_f).setHarvestLevel("pickaxe", 0));
        }
    }
    ,
    INVAR{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockInvar", null, beaconBaseProvider).setParentFolder("metals/invar").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockInvar").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockInvar");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Invar");
        }
    }
    ,
    IRON{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockIron", null, beaconBaseProvider).setParentFolder("metals/iron").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockIron").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 1));
            factory.newBlock(Material.field_151573_f, "iron", null, beaconBaseProvider).newVariation("terrain-iron-largeingot").next("terrain-iron-smallingot").next("terrain-iron-gears").next("terrain-iron-brick").next("terrain-iron-plates").next("terrain-iron-rivets").next("terrain-iron-coin-heads").next("terrain-iron-coin-tails").next("terrain-iron-crate-dark").next("terrain-iron-crate-light").next("terrain-iron-moon").next("terrain-iron-space").next("terrain-iron-spaceblack").next("terrain-iron-vents").next("terrain-iron-simple").addOreDict("blockIron").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockIron");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Iron");
        }
    }
    ,
    IRONPANE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("ironpane", CarvingUtils.variationFor(Blocks.field_150411_aY.func_176223_P(), -1));
            factory.newBlock(Material.field_151573_f, "ironpane", new ChiselBlockProvider<BlockCarvablePane>(BlockCarvablePane::create, BlockCarvablePane.class)).newVariation("borderless").next("borderless-topper").next("barbedwire").next("cage").next("thickgrid").next("thingrid").next("ornatesteel").next("bars").next("spikes").next("classic").next("classicnew").next("fence").next("modern").build(b -> b.setDragonProof().func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 0));
        }
    }
    ,
    LABORATORY{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "laboratory", provider).newVariation("wallpanel").next("dottedpanel").next("largewall").next("roundel").next("wallvents").next("largetile").next("smalltile").next("floortile").next("checkertile").next("clearscreen").next("fuzzscreen").next("largesteel").next("smallsteel").next("directionleft").next("directionright").next("infocon").build(b -> b.func_149672_a(ChiselSoundTypes.METAL));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.laboratory, 8), "***", "*X*", "***", Character.valueOf('*'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('X'), new ItemStack(Items.field_151128_bU, 1));
        }
    }
    ,
    LAPIS{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "lapis", null, provider).newVariation("terrain-lapisblock-chunky").next("terrain-lapisblock-panel").next("terrain-lapisblock-zelda").next("terrain-lapisornate").next("terrain-lapistile").next("a1-blocklapis-panel").next("a1-blocklapis-smooth").next("a1-blocklapis-ornatelayer").next("masonryLapis").addOreDict("blockLapis").build(b -> b.func_149711_c(3.0f).func_149752_b(5.0f).func_149672_a(SoundType.field_185851_d).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockLapis");
        }
    }
    ,
    LAVASTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "lavastone", new ChiselBlockProvider<BlockCarvable>(BlockCarvable::new, BlockCarvable.class)).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").build(b -> b.func_149711_c(4.0f).func_149752_b(50.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.lavastone, 8, 0), "***", "*X*", "***", Character.valueOf('*'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('X'), new ItemStack(Items.field_151129_at, 1));
        }
    }
    ,
    LEAD{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockLead", null, beaconBaseProvider).setParentFolder("metals/lead").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockLead").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockLead");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Lead");
        }
    }
    ,
    LIMESTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "limestone", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("raw").setOrder(-100).addOreDict("stoneLimestone").addOreDict("stoneLimestonePolished").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            GenerationHandler.INSTANCE.addGeneration(ChiselBlocks.limestone2.func_176223_P().func_177226_a((IProperty)ChiselBlocks.limestone2.getMetaProp(), (Comparable)Integer.valueOf(7)), new GenerationHandler.WorldGenInfo(Configurations.limestoneAmount, 32, 64, 1.0, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)));
        }
    }
    ,
    MARBLE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "marble", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("raw").setOrder(-100).addOreDict("stoneMarble").addOreDict("stoneMarblePolished").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            GenerationHandler.INSTANCE.addGeneration(ChiselBlocks.marble2.func_176223_P().func_177226_a((IProperty)ChiselBlocks.marble2.getMetaProp(), (Comparable)Integer.valueOf(7)), new GenerationHandler.WorldGenInfo(Configurations.marbleAmount, 32, 64, 1.0, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)));
        }
    }
    ,
    MARBLEPILLAR{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            if (Configurations.oldPillars) {
                factory.newBlock(Material.field_151576_e, "marblepillarold", provider).setGroup("marble").newVariation("column").next("capstone").next("base").next("small").next("pillar-carved").next("a1-stoneornamental-marblegreek").next("a1-stonepillar-greek").next("a1-stonepillar-plain").next("a1-stonepillar-greektopplain").next("a1-stonepillar-plaintopplain").next("a1-stonepillar-greekbottomplain").next("a1-stonepillar-plainbottomplain").next("a1-stonepillar-greektopgreek").next("a1-stonepillar-plaintopgreek").next("a1-stonepillar-greekbottomgreek").next("a1-stonepillar-plainbottomgreek").addOreDict("stoneMarble").addOreDict("stoneMarblePolished").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            } else {
                factory.newBlock(Material.field_151576_e, "marblepillar", provider).setGroup("marble").newVariation("pillar").next("default").next("simple").next("convex").next("rough").next("greekdecor").next("greekgreek").next("greekplain").next("plaindecor").next("plaingreek").next("plainplain").next("widedecor").next("widegreek").next("wideplain").next("carved").next("ornamental").addOreDict("stoneMarble").addOreDict("stoneMarblePolished").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            }
        }
    }
    ,
    NETHERBRICK{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("netherbrick", CarvingUtils.variationFor(Blocks.field_150385_bj.func_176223_P(), -1));
            factory.newBlock(Material.field_151576_e, "netherbrick", provider).newVariation("a1-netherbrick-brinstar").next("a1-netherbrick-classicspatter").next("a1-netherbrick-guts").next("a1-netherbrick-gutsdark").next("a1-netherbrick-gutssmall").next("a1-netherbrick-lavabrinstar").next("a1-netherbrick-lavabrown").next("a1-netherbrick-lavaobsidian").next("a1-netherbrick-lavastonedark").next("a1-netherbrick-meat").next("a1-netherbrick-meatred").next("a1-netherbrick-meatredsmall").next("a1-netherbrick-meatsmall").next("a1-netherbrick-red").next("a1-netherbrick-redsmall").next("netherFancyBricks").build(b -> b.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    NETHERRACK{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("netherrack", CarvingUtils.variationFor(Blocks.field_150424_aL.func_176223_P(), -20));
            BlockCreator<BlockCarvable> netherrackCreator = (mat, index, maxVariation, data) -> new BlockCarvable(mat, index, maxVariation, data){

                public boolean isFireSource(@Nonnull World world, BlockPos pos, EnumFacing side) {
                    return side == EnumFacing.UP;
                }
            };
            factory.newBlock(Material.field_151576_e, "netherrack", new ChiselBlockProvider<BlockCarvable>(netherrackCreator, BlockCarvable.class)).newVariation("a1-netherrack-bloodgravel").next("a1-netherrack-bloodrock").next("a1-netherrack-bloodrockgrey").next("a1-netherrack-brinstar").next("a1-netherrack-brinstarshale").next("a1-netherrack-classic").next("a1-netherrack-classicspatter").next("a1-netherrack-guts").next("a1-netherrack-gutsdark").next("a1-netherrack-meat").next("a1-netherrack-meatred").next("a1-netherrack-meatrock").next("a1-netherrack-red").next("a1-netherrack-wells").addOreDict("netherrack").build(b -> b.func_149711_c(0.4f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    NICKEL{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockNickel", null, beaconBaseProvider).setParentFolder("metals/nickel").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockNickel").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockNickel");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Nickel");
        }
    }
    ,
    OBSIDIAN{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("obsidian", CarvingUtils.variationFor(Blocks.field_150343_Z.func_176223_P(), -1));
            factory.newBlock(Material.field_151576_e, "obsidian", provider).newVariation("pillar").next("pillar-quartz").next("chiseled").next("panel-shiny").next("panel").next("chunks").next("growth").next("crystal").next("map-a").next("map-b").next("panel-light").next("blocks").next("tiles").next("greek").next("crate").addOreDict("obsidian").build(b -> b.setDragonProof().func_149711_c(50.0f).func_149752_b(2000.0f).func_149672_a(SoundType.field_185851_d).setHarvestLevel("pickaxe", 3));
        }
    }
    ,
    PAPER{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151585_k, "paper", provider).newVariation("box").next("throughMiddle").next("cross").next("sixSections").next("vertical").next("horizontal").next("floral").next("plain").next("door").build(b -> b.func_149672_a(SoundType.field_185850_c).func_149711_c(1.5f));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.paper, 32), "ppp", "psp", "ppp", Character.valueOf('p'), Items.field_151121_aF, Character.valueOf('s'), "stickWood");
        }
    }
    ,
    PLANKS{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState planks = Blocks.field_150344_f.func_176223_P();
            PropertyEnum prop = BlockPlanks.field_176383_a;
            for (int c = 0; c < plank_names.length; ++c) {
                String groupName = "planks-" + plank_names[c];
                Carving.chisel.addVariation(groupName, CarvingUtils.variationFor(planks.func_177226_a((IProperty)prop, (Comparable)BlockPlanks.EnumType.func_176837_a((int)c)), -1));
                Carving.chisel.setVariationSound(groupName, ChiselSounds.wood_chisel);
                factory.newBlock(Material.field_151575_d, "planks-" + plank_names[c], provider).newVariation("clean").next("short").next("fancy").next("panel-nails").next("double").next("crate").next("crate-fancy").next("large").next("vertical").next("vertical-uneven").next("parquet").next("blinds").next("crateex").next("chaotic-hor").next("chaotic").addOreDict("plankWood").build(b -> b.func_149711_c(2.0f).func_149752_b(5.0f).func_149672_a(SoundType.field_185848_a));
            }
        }
    }
    ,
    PLATINUM{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockPlatinum", null, beaconBaseProvider).setParentFolder("metals/platinum").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockPlatinum").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockPlatinum");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Platinum");
        }
    }
    ,
    PRISMARINE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState prismarine = Blocks.field_180397_cI.func_176223_P();
            PropertyEnum prop = BlockPrismarine.field_176332_a;
            Carving.chisel.addVariation("prismarine", CarvingUtils.variationFor(prismarine.func_177226_a((IProperty)prop, (Comparable)BlockPrismarine.EnumType.BRICKS), -1));
            factory.newBlock(Material.field_151576_e, "prismarine", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").addOreDict("prismarine").addOreDict("prismarineBrick").addOreDict("prismarineDark").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    QUARTZ{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState quartzBlock = Blocks.field_150371_ca.func_176223_P();
            PropertyEnum prop = BlockQuartz.field_176335_a;
            Carving.chisel.addVariation("quartz", CarvingUtils.variationFor(quartzBlock.func_177226_a((IProperty)prop, (Comparable)BlockQuartz.EnumType.DEFAULT), -25));
            Carving.chisel.addVariation("quartz", CarvingUtils.variationFor(quartzBlock.func_177226_a((IProperty)prop, (Comparable)BlockQuartz.EnumType.CHISELED), -24));
            Carving.chisel.addVariation("quartz", CarvingUtils.variationFor(quartzBlock.func_177226_a((IProperty)prop, (Comparable)BlockQuartz.EnumType.LINES_Y), -22));
            factory.newBlock(Material.field_151576_e, "quartz", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("prism").next("bricks-chaotic").next("cuts").addOreDict("blockQuartz").build(b -> b.func_149711_c(0.8f).func_149752_b(4.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    REDSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("redstone", CarvingUtils.variationFor(Blocks.field_150451_bX.func_176223_P(), -20));
            BlockCreator<BlockCarvable> redstoneCreator = (mat, index, maxVariation, data) -> new BlockCarvable(mat, index, maxVariation, data){

                public boolean func_149744_f(IBlockState state) {
                    return true;
                }

                public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
                    return 15;
                }
            };
            factory.newBlock(Material.field_151573_f, "redstone", new ChiselBlockProvider<BlockCarvable>(redstoneCreator, BlockCarvable.class)).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").addOreDict("blockRedstone").build(b -> b.func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185852_e));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack(Items.field_151137_ax, 9), "X", Character.valueOf('X'), "blockRedstone");
        }
    }
    ,
    SANDSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState ss = Blocks.field_150322_A.func_176223_P();
            PropertyEnum prop = BlockSandStone.field_176297_a;
            Carving.chisel.addVariation("sandstoneyellow", CarvingUtils.variationFor(ss.func_177226_a((IProperty)prop, (Comparable)BlockSandStone.EnumType.DEFAULT), -13));
            Carving.chisel.addVariation("sandstoneyellow", CarvingUtils.variationFor(ss.func_177226_a((IProperty)prop, (Comparable)BlockSandStone.EnumType.SMOOTH), -11));
            Carving.chisel.addVariation("sandstoneyellow", CarvingUtils.variationFor(ss.func_177226_a((IProperty)prop, (Comparable)BlockSandStone.EnumType.CHISELED), -10));
            factory.newBlock(Material.field_151576_e, "sandstoneyellow", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("seamless").setOrder(-12).addOreDict("sandstone").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(0.8f));
        }
    }
    ,
    SANDSTONE_RED{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState ss = Blocks.field_180395_cM.func_176223_P();
            PropertyEnum prop = BlockRedSandstone.field_176336_a;
            Carving.chisel.addVariation("sandstonered", CarvingUtils.variationFor(ss.func_177226_a((IProperty)prop, (Comparable)BlockRedSandstone.EnumType.DEFAULT), -13));
            Carving.chisel.addVariation("sandstonered", CarvingUtils.variationFor(ss.func_177226_a((IProperty)prop, (Comparable)BlockRedSandstone.EnumType.SMOOTH), -11));
            Carving.chisel.addVariation("sandstonered", CarvingUtils.variationFor(ss.func_177226_a((IProperty)prop, (Comparable)BlockRedSandstone.EnumType.CHISELED), -10));
            factory.newBlock(Material.field_151576_e, "sandstonered", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("seamless").setOrder(-12).addOreDict("sandstone").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(0.8f));
        }
    }
    ,
    SANDSTONE_SCRIBBLES{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "sandstone-scribbles", provider).setGroup("sandstoneyellow").newVariation("scribbles-0").next("scribbles-1").next("scribbles-2").next("scribbles-3").next("scribbles-4").next("scribbles-5").next("scribbles-6").next("scribbles-7").next("scribbles-8").next("scribbles-9").next("scribbles-10").next("scribbles-11").next("scribbles-12").next("scribbles-13").next("scribbles-14").next("scribbles-15").addOreDict("sandstone").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(0.8f));
        }
    }
    ,
    SANDSTONERED_SCRIBBLES{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "sandstonered-scribbles", provider).setGroup("sandstonered").newVariation("scribbles-0").next("scribbles-1").next("scribbles-2").next("scribbles-3").next("scribbles-4").next("scribbles-5").next("scribbles-6").next("scribbles-7").next("scribbles-8").next("scribbles-9").next("scribbles-10").next("scribbles-11").next("scribbles-12").next("scribbles-13").next("scribbles-14").next("scribbles-15").addOreDict("sandstone").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(0.8f));
        }
    }
    ,
    SILVER{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockSilver", null, beaconBaseProvider).setParentFolder("metals/silver").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockSilver").build(b -> b.func_149672_a(SoundType.field_185852_e).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockSilver");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Silver");
        }
    }
    ,
    STEEL{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockSteel", null, beaconBaseProvider).setParentFolder("metals/steel").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockSteel").build(b -> b.func_149672_a(SoundType.field_185852_e).setHarvestLevel("pickaxe", 2));
            CarvingUtils.addOreGroup("blockSteel");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Steel");
        }
    }
    ,
    STONEBRICK{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            if (Configurations.chiselStoneToCobbleBricks) {
                Carving.chisel.addVariation("stonebrick", CarvingUtils.variationFor(Blocks.field_150348_b.func_176223_P(), -100));
            }
            IBlockState stoneBricks = Blocks.field_150417_aV.func_176223_P();
            PropertyEnum prop = BlockStoneBrick.field_176249_a;
            Carving.chisel.addVariation("stonebrick", CarvingUtils.variationFor(stoneBricks.func_177226_a((IProperty)prop, (Comparable)BlockStoneBrick.EnumType.DEFAULT), -26));
            if (Configurations.allowMossy) {
                Carving.chisel.addVariation("stonebrick", CarvingUtils.variationFor(stoneBricks.func_177226_a((IProperty)prop, (Comparable)BlockStoneBrick.EnumType.MOSSY), -25));
            }
            Carving.chisel.addVariation("stonebrick", CarvingUtils.variationFor(stoneBricks.func_177226_a((IProperty)prop, (Comparable)BlockStoneBrick.EnumType.CRACKED), -24));
            Carving.chisel.addVariation("stonebrick", CarvingUtils.variationFor(stoneBricks.func_177226_a((IProperty)prop, (Comparable)BlockStoneBrick.EnumType.CHISELED), -23));
            factory.newBlock(Material.field_151576_e, "stonebrick", provider).setParentFolder("stone").newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-chaotic").next("cuts").next("").next("").next("").next("").next("").next("").next("bricks-small").next("tiles-medium").next("pillar").next("twisted").next("prism").next("largeornate").next("poison").next("sunken").next("doubleslab").setOrder(-28).next("doubleslab-seamless").setOrder(-27).addOreDict("stone").addOreDict("brickStone").addOreDict("bricksStone").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    TECHNICAL{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "technical", provider).setGroup("factory").newVariation("scaffold").next("cautiontape").next("industrialrelic").next("pipesLarge").next("fanFast").next("pipesSmall").next("fanStill").next("vent").next("ventGlowing").next("insulationv2").next("spinningStuffAnim").next("cables").next("rustyBoltedPlates").next("grate").next("malfunctionFan").next("grateRusty").next("scaffoldTransparent").opaque(false).next("fanFastTransparent").opaque(false).next("fanStillTransparent").opaque(false).next("massiveFan").next("massiveHexPlating").build(b -> b.func_149672_a(SoundType.field_185852_e));
            factory.newBlock(Material.field_151573_f, "technicalNew", provider).setGroup("factory").setParentFolder("technical/new").newVariation("weatheredGreenPanels").next("weatheredOrangePanels").next("Sturdy").next("MegaCell").next("ExhaustPlating").next("MakeshiftPanels").next("engineering").next("scaffoldLarge").next("Piping").build(b -> b.func_149672_a(SoundType.field_185852_e));
        }
    }
    ,
    TEMPLE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "temple", provider).newVariation("cobble").next("ornate").next("plate").next("plate-cracked").next("bricks").next("bricks-large").next("bricks-weared").next("bricks-disarray").next("column").next("stand").next("tiles").next("smalltiles").next("tiles-light").next("smalltiles-light").next("stand-creeper").next("stand-mosaic").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "templemossy", provider).setGroup("temple").newVariation("cobble").next("ornate").next("plate").next("plate-cracked").next("bricks").next("bricks-large").next("bricks-weared").next("bricks-disarray").next("column").next("stand").next("tiles").next("smalltiles").next("tiles-light").next("smalltiles-light").next("stand-creeper").next("stand-mosaic").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.temple, 8), "***", "*X*", "***", Character.valueOf('*'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 6));
        }
    }
    ,
    TIN{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockTin", null, beaconBaseProvider).setParentFolder("metals/tin").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockTin").build(b -> b.func_149672_a(SoundType.field_185852_e).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockTin");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Tin");
        }
    }
    ,
    TYRIAN{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "tyrian", provider).newVariation("shining").next("tyrian").next("chaotic").next("softplate").next("rust").next("elaborate").next("routes").next("platform").next("platetiles").next("diagonal").next("dent").next("blueplating").next("black").next("black2").next("opening").next("plate").build(b -> b.func_149672_a(SoundType.field_185852_e));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.tyrian, 32, 0), "SSS", "SXS", "SSS", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('X'), new ItemStack(Items.field_151042_j, 1));
        }
    }
    ,
    URANIUM{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockUranium", null, beaconBaseProvider).setParentFolder("metals/uranium").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").addOreDict("blockUranium").build(b -> b.func_149672_a(SoundType.field_185852_e).setHarvestLevel("pickaxe", 1));
            CarvingUtils.addOreGroup("blockUranium");
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            Features.registerIngotUncraftRecipe((IForgeRegistry<IRecipe>)registry, "Uranium");
        }
    }
    ,
    VALENTINES{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "valentines", provider).newVariation("1").next("2").next("3").next("4").next("5").next("6").next("7").next("8").next("9").next("companion").build(b -> b.func_149711_c(1.5f).func_149752_b(20.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.valentines, 4), "***", "*X*", "***", Character.valueOf('*'), "stone", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 9));
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "companion_cube", new ItemStack((Block)ChiselBlocks.valentines, 32, 9), new Object[]{"***", "*X*", "***", Character.valueOf('*'), "stone", Character.valueOf('X'), new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE)});
        }
    }
    ,
    VOIDSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "voidstone", provider).newVariation("raw").next("quarters").next("smooth").next("skulls").next("rune").next("metalborder").next("eye").next("bevel").build();
            factory.newBlock(Material.field_151576_e, "energizedVoidstone", provider).setGroup("voidstone").setParentFolder("voidstone/animated").newVariation("raw").next("quarters").next("smooth").next("skulls").next("rune").next("metalborder").next("eye").next("bevel").build();
            factory.newBlock(Material.field_151576_e, "voidstoneRunic", provider).setParentFolder("voidstone/runes").setGroup("voidstone").newVariation("black").next("red").next("green").next("brown").next("blue").next("purple").next("cyan").next("lightgray").next("gray").next("pink").next("lime").next("yellow").next("lightblue").next("magenta").next("orange").build();
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.voidstone, 16, 0), " E ", "OOO", " E ", Character.valueOf('E'), new ItemStack(Items.field_151061_bv), Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z));
            Features.addShapedRecipe((IForgeRegistry<IRecipe>)registry, "voidstone2", new ItemStack((Block)ChiselBlocks.voidstone, 48, 0), new Object[]{" P ", "PEP", " P ", Character.valueOf('E'), new ItemStack(Items.field_151079_bi), Character.valueOf('P'), new ItemStack(Blocks.field_185767_cT)});
        }
    }
    ,
    WATERSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "waterstone", new ChiselBlockProvider<BlockCarvable>(BlockCarvable::new, BlockCarvable.class)).opaque(false).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bricks-chaotic").next("cuts").build(b -> b.func_149711_c(4.0f).func_149752_b(50.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes(IForgeRegistry<IRecipe> registry) {
            this.addShapedRecipe(registry, new ItemStack((Block)ChiselBlocks.waterstone, 8, 0), "***", "*X*", "***", Character.valueOf('*'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('X'), new ItemStack(Items.field_151131_as, 1));
        }
    }
    ,
    WOOL{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState wool = Blocks.field_150325_L.func_176223_P();
            PropertyEnum prop = BlockColored.field_176581_a;
            for (int c = 0; c < dyeColors.length; ++c) {
                Carving.chisel.addVariation("wool_" + dyeColors[c].toLowerCase(), CarvingUtils.variationFor(wool.func_177226_a((IProperty)prop, (Comparable)EnumDyeColor.func_176766_a((int)c)), -1));
                factory.newBlock(Material.field_151580_n, "wool_" + dyeColors[c].toLowerCase(), provider).setParentFolder("wool").newVariation("legacy_" + dyeColors[c].toLowerCase()).next("llama_" + dyeColors[c].toLowerCase()).addOreDict("blockWool").build(b -> b.func_149672_a(SoundType.field_185854_g).func_149711_c(0.8f));
            }
        }
    };

    private static final String[] dyeColors;
    private static final String[] dyeOres;
    public static final String[] plank_names;
    @Nonnull
    private static final BlockCreator<BlockCarvable> creator;
    @Nonnull
    private static final ChiselBlockProvider<BlockCarvable> provider;
    @Nonnull
    private static final BlockCreator<BlockCarvable> beaconBaseCreator;
    @Nonnull
    private static final ChiselBlockProvider<BlockCarvable> beaconBaseProvider;
    private Features parent;
    private String requiredMod;
    private static final ResourceLocation RECIPE_GROUP;

    @SubscribeEvent
    public static void loadBlocks(RegistryEvent.Register<Block> event) {
        Chisel.logger.info("Loading blocks...");
        int num = 0;
        ChiselBlockFactory factory = ChiselBlockFactory.newFactory((IForgeRegistry<Block>)event.getRegistry(), "chisel");
        for (Features f : Features.values()) {
            if (f.enabled()) {
                f.addBlocks(factory);
                ++num;
                continue;
            }
            Features.logDisabled(f);
        }
        Chisel.logger.info(num + " Feature's blocks loaded.");
        Chisel.logger.info("Loading Tile Entities...");
        Chisel.proxy.registerTileEntities();
        Chisel.logger.info("Tile Entities loaded.");
    }

    @SubscribeEvent
    public static void loadItems(RegistryEvent.Register<Item> event) {
        Chisel.logger.info("Loading items...");
        int num = 0;
        for (Features f : Features.values()) {
            if (f.enabled()) {
                f.addItems((IForgeRegistry<Item>)event.getRegistry());
                ++num;
                continue;
            }
            Features.logDisabled(f);
        }
        Chisel.logger.info(num + " Feature's items loaded.");
    }

    @SubscribeEvent
    public static void loadRecipes(RegistryEvent.Register<IRecipe> event) {
        Chisel.logger.info("Loading recipes...");
        int num = 0;
        for (Features f : Features.values()) {
            if (f.enabled()) {
                f.addRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
                ++num;
                continue;
            }
            Features.logDisabled(f);
        }
        Chisel.logger.info(num + " Feature's recipes loaded.");
    }

    private static void logDisabled(Features f) {
        if (!f.hasParentFeature() && f.parent != null) {
            Chisel.logger.info("Skipping feature {} as its parent feature {} was disabled.", (Object)Configurations.featureName(f), (Object)Configurations.featureName(f.parent));
        } else if (!f.hasRequiredMod() && f.getRequiredMod() != null) {
            Chisel.logger.info("Skipping feature {} as its required mod {} was missing.", (Object)Configurations.featureName(f), (Object)f.getRequiredMod());
        } else {
            Chisel.logger.info("Skipping feature {} as it was disabled in the config.", (Object)Configurations.featureName(f));
        }
    }

    public static boolean oneModdedFeatureLoaded() {
        for (Features f : Features.values()) {
            if (!f.hasRequiredMod()) continue;
            return true;
        }
        return false;
    }

    private Features() {
        this((String)null, (Features)null);
    }

    private Features(Features parent) {
        this(null, parent);
    }

    private Features(String requiredMod) {
        this(requiredMod, (Features)null);
    }

    private Features(String requriedMod, Features parent) {
        this.requiredMod = requriedMod;
        this.parent = parent;
    }

    void addBlocks(ChiselBlockFactory factory) {
    }

    void addItems(IForgeRegistry<Item> registry) {
    }

    void addRecipes(IForgeRegistry<IRecipe> registry) {
    }

    public boolean enabled() {
        return Configurations.featureEnabled(this) && this.hasRequiredMod() && this.hasParentFeature();
    }

    private boolean hasParentFeature() {
        return this.parent == null || this.parent.enabled();
    }

    private boolean hasRequiredMod() {
        return this.getRequiredMod() == null || Loader.isModLoaded((String)this.getRequiredMod());
    }

    private String getRequiredMod() {
        return this.requiredMod;
    }

    boolean needsMetaRecipes() {
        return false;
    }

    private static void registerSlabTop(@Nonnull Block bottom, Block top) {
        ResourceLocation block = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)bottom);
        String name = block.func_110623_a() + "_top";
    }

    private static void registerIngotUncraftRecipe(IForgeRegistry<IRecipe> registry, String ore) {
        Features.registerOreUncraftRecipe(registry, "block" + ore, "ingot" + ore);
    }

    private static void registerOreUncraftRecipe(IForgeRegistry<IRecipe> registry, String blockOre, String endOre) {
        NonNullList oreList;
        if (OreDictionary.doesOreNameExist((String)endOre) && (oreList = OreDictionary.getOres((String)endOre)).size() > 0) {
            ItemStack result = (ItemStack)oreList.get(0);
            Features.addShapedRecipe(registry, "uncraft_" + blockOre, new ItemStack(result.func_77973_b(), 9, result.func_77952_i(), result.func_77978_p()), "X", Character.valueOf('X'), blockOre);
        }
    }

    void addShapelessRecipe(IForgeRegistry<IRecipe> registry, ItemStack result, Object ... ingredients) {
        Features.addShapelessRecipe(registry, Configurations.featureName(this), result, ingredients);
    }

    void addShapelessRecipe(IForgeRegistry<IRecipe> registry, Block result, Object ... ingredients) {
        Features.addShapelessRecipe(registry, Configurations.featureName(this), result, ingredients);
    }

    void addShapelessRecipe(IForgeRegistry<IRecipe> registry, Item result, Object ... ingredients) {
        Features.addShapelessRecipe(registry, Configurations.featureName(this), result, ingredients);
    }

    private static void addShapelessRecipe(IForgeRegistry<IRecipe> registry, String name, ItemStack result, Object ... ingredients) {
        registry.register(new ShapelessOreRecipe(RECIPE_GROUP, result, ingredients).setRegistryName("chisel", name));
    }

    private static void addShapelessRecipe(IForgeRegistry<IRecipe> registry, String name, Block result, Object ... ingredients) {
        registry.register(new ShapelessOreRecipe(RECIPE_GROUP, result, ingredients).setRegistryName("chisel", name));
    }

    private static void addShapelessRecipe(IForgeRegistry<IRecipe> registry, String name, Item result, Object ... ingredients) {
        registry.register(new ShapelessOreRecipe(RECIPE_GROUP, result, ingredients).setRegistryName("chisel", name));
    }

    void addShapedRecipe(IForgeRegistry<IRecipe> registry, ItemStack result, Object ... ingredients) {
        Features.addShapedRecipe(registry, Configurations.featureName(this), result, ingredients);
    }

    void addShapedRecipe(IForgeRegistry<IRecipe> registry, Block result, Object ... ingredients) {
        Features.addShapedRecipe(registry, Configurations.featureName(this), result, ingredients);
    }

    void addShapedRecipe(IForgeRegistry<IRecipe> registry, Item result, Object ... ingredients) {
        Features.addShapedRecipe(registry, Configurations.featureName(this), result, ingredients);
    }

    private static void addShapedRecipe(IForgeRegistry<IRecipe> registry, String name, @Nonnull ItemStack result, Object ... ingredients) {
        registry.register(new ShapedOreRecipe(RECIPE_GROUP, result, ingredients).setRegistryName("chisel", name));
    }

    private static void addShapedRecipe(IForgeRegistry<IRecipe> registry, String name, Block result, Object ... ingredients) {
        registry.register(new ShapedOreRecipe(RECIPE_GROUP, result, ingredients).setRegistryName("chisel", name));
    }

    private static void addShapedRecipe(IForgeRegistry<IRecipe> registry, String name, Item result, Object ... ingredients) {
        registry.register(new ShapedOreRecipe(RECIPE_GROUP, result, ingredients).setRegistryName("chisel", name));
    }

    static {
        dyeColors = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        dyeOres = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        plank_names = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark-oak"};
        creator = BlockCarvable::new;
        provider = new ChiselBlockProvider<BlockCarvable>(creator, BlockCarvable.class);
        beaconBaseCreator = (mat, index, maxVariation, data) -> new BlockCarvable(mat, index, maxVariation, data){

            public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
                return true;
            }
        };
        beaconBaseProvider = new ChiselBlockProvider<BlockCarvable>(beaconBaseCreator, BlockCarvable.class);
        RECIPE_GROUP = new ResourceLocation("", "");
    }

    @ParametersAreNonnullByDefault
    private static class ChiselBlockProvider<T extends Block>
    implements BlockProvider<T> {
        private final BlockCreator<T> creator;
        private final Class<T> blockClass;

        @Override
        public T createBlock(Material mat, int index, int maxVariation, VariationData ... data) {
            return this.creator.createBlock(mat, index, maxVariation, data);
        }

        @Override
        public ItemBlock createItemBlock(T block) {
            return (ItemBlock)new ItemChiselBlock((Block)block).setRegistryName(block.getRegistryName());
        }

        @ConstructorProperties(value={"creator", "blockClass"})
        public ChiselBlockProvider(BlockCreator<T> creator, Class<T> blockClass) {
            this.creator = creator;
            this.blockClass = blockClass;
        }

        @Override
        public Class<T> getBlockClass() {
            return this.blockClass;
        }
    }
}

