/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.BlockCartAssembler;
import vswe.stevescarts.blocks.BlockContainerBase;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.items.ItemUpgrade;
import vswe.stevescarts.upgrades.AssemblerUpgrade;

public class BlockUpgrade
extends BlockContainerBase
implements ModBlocks.ICustomItemBlock,
ModBlocks.ISubtypeItemBlockModelDefinition {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)19);
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");
    private static AxisAlignedBB IDLE_BB = new AxisAlignedBB(0.1875, 0.125, 0.1875, 0.8125, 0.875, 0.8125);
    private static AxisAlignedBB[] BBS = new AxisAlignedBB[6];

    public BlockUpgrade() {
        super(Material.field_151576_e);
        this.func_149647_a(StevesCarts.tabsSC2Blocks);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(true)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityUpgrade) {
            state = state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(((TileEntityUpgrade)te).getType()));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE, CONNECTED});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() | ((Boolean)state.func_177229_b((IProperty)CONNECTED) != false ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf((meta & 8) >> 3 == 1));
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            return side != EnumFacing.UP && upgrade.getType() == 13;
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            upgrade.setType(stack.func_77952_i());
            ((BlockCartAssembler)ModBlocks.CART_ASSEMBLER.getBlock()).addUpgrade(worldIn, pos);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        ((BlockCartAssembler)ModBlocks.CART_ASSEMBLER.getBlock()).addUpgrade(world, pos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile;
        if (player.field_71075_bZ.field_75098_d && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            upgrade.setCreativeBroken();
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            if (upgrade.getUpgrade() != null) {
                upgrade.getUpgrade().removed(upgrade);
            }
            if (!upgrade.isCreativeBroken()) {
                BlockUpgrade.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1, upgrade.getType()));
            }
            if (upgrade.hasInventory()) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)upgrade);
            }
        }
        super.func_180663_b(world, pos, state);
        ((BlockCartAssembler)ModBlocks.CART_ASSEMBLER.getBlock()).removeUpgrade(world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)CONNECTED)).booleanValue()) {
            return IDLE_BB;
        }
        return BBS[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d().func_176745_a()];
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            if (upgrade.getMaster() == null) {
                return false;
            }
            if (world.field_72995_K) {
                return true;
            }
            if (upgrade.getUpgrade().useStandardInterface()) {
                BlockPos masterPos = upgrade.getMaster().func_174877_v();
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)StevesCarts.instance, (int)3, (World)world, (int)masterPos.func_177958_n(), (int)masterPos.func_177956_o(), (int)masterPos.func_177952_p());
                return true;
            }
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)StevesCarts.instance, (int)7, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityUpgrade();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            return new ItemStack((Block)this, 1, upgrade.getType());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ItemUpgrade((Block)this);
    }

    @Override
    public int getSubtypeNumber() {
        return AssemblerUpgrade.getUpgradesList().size();
    }

    @Override
    public String getSubtypeName(int meta) {
        AssemblerUpgrade data = AssemblerUpgrade.getUpgrade(meta);
        if (data != null) {
            if (data.getIcon() == null) {
                data.setIcon("upgrade_" + data.getRawName().toLowerCase());
            }
            return data.getIcon();
        }
        return "unknown_icon";
    }

    static {
        float margin = 0.1875f;
        float width = 0.125f;
        BlockUpgrade.BBS[EnumFacing.DOWN.func_176745_a()] = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
        BlockUpgrade.BBS[EnumFacing.UP.func_176745_a()] = new AxisAlignedBB(0.1875, 0.875, 0.1875, 0.8125, 1.0, 0.8125);
        BlockUpgrade.BBS[EnumFacing.WEST.func_176745_a()] = new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.125, 0.8125, 0.8125);
        BlockUpgrade.BBS[EnumFacing.EAST.func_176745_a()] = new AxisAlignedBB(0.875, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
        BlockUpgrade.BBS[EnumFacing.NORTH.func_176745_a()] = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.125);
        BlockUpgrade.BBS[EnumFacing.SOUTH.func_176745_a()] = new AxisAlignedBB(0.1875, 0.1875, 0.875, 0.8125, 0.8125, 1.0);
    }
}

