/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.primitives.SignedBytes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;

public class SyncableByte
extends SyncableObjectBase
implements ISyncableValueProvider<Byte> {
    private byte value;

    public SyncableByte(byte value) {
        this.value = value;
    }

    public SyncableByte() {
    }

    public void set(byte newValue) {
        if (newValue != this.value) {
            this.value = newValue;
            this.markDirty();
        }
    }

    public byte get() {
        return this.value;
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    @Override
    public void readFromStream(PacketBuffer stream) {
        this.value = stream.readByte();
    }

    @Override
    public void writeToStream(PacketBuffer stream) {
        stream.writeByte((int)this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74774_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.value = tag.func_74771_c(name);
    }

    public void modify(int by) {
        this.set(SignedBytes.checkedCast((long)(this.value + by)));
    }
}

