/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.symbol;

import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.symbol.FixedCallable;
import info.openmods.calc.utils.Stack;

public abstract class BinaryFunction<E>
extends FixedCallable<E> {
    private BinaryFunction() {
        super(2, 1);
    }

    public static abstract class WithFrame<E>
    extends BinaryFunction<E> {
        protected abstract E call(Frame<E> var1, E var2, E var3);

        @Override
        public final void call(Frame<E> frame) {
            Frame<E> executionFrame = FrameFactory.newLocalFrameWithSubstack(frame, 2);
            Stack<E> stack = executionFrame.stack();
            E right = stack.pop();
            E left = stack.pop();
            E result = this.call(executionFrame, left, right);
            stack.checkIsEmpty().push(result);
        }
    }

    public static abstract class Direct<E>
    extends BinaryFunction<E> {
        protected abstract E call(E var1, E var2);

        @Override
        public final void call(Frame<E> frame) {
            Stack<E> stack = frame.stack();
            E right = stack.pop();
            E left = stack.pop();
            E result = this.call(left, right);
            stack.push(result);
        }
    }
}

