/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.rwtema.extrautils2.backend.ModifyingBakedModel;
import com.rwtema.extrautils2.compatibility.CompatClientHelper;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.CraftingHelper112;
import com.rwtema.extrautils2.compatibility.ICompatPerspectiveAwareModel;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.NullRecipe;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.gui.backend.WidgetProgressArrowBase;
import com.rwtema.extrautils2.gui.backend.WidgetSlotGhost;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.gui.backend.WidgetSlotReadOnly;
import com.rwtema.extrautils2.gui.backend.WidgetTextTranslate;
import com.rwtema.extrautils2.itemhandler.ConcatItemHandler;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.PublicWrapper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.itemhandler.StackDump;
import com.rwtema.extrautils2.itemhandler.XUCrafter;
import com.rwtema.extrautils2.itemhandler.XUTileItemStackHandler;
import com.rwtema.extrautils2.items.itemmatching.Matchers;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.render.IVertexBuffer;
import com.rwtema.extrautils2.tile.TileAdvInteractor;
import com.rwtema.extrautils2.tile.tesr.ITESRHook;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.datastructures.ArrayAccess;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.tuple.Pair;

public class TileCrafter
extends TileAdvInteractor
implements ITickable,
IDynamicHandler,
ITESRHook {
    public static final LoadingCache<ShapedOreRecipe, Integer> SOR_WIDTH = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<ShapedOreRecipe, Integer>(){

        public Integer load(@Nonnull ShapedOreRecipe key) throws Exception {
            return (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)key, (String[])new String[]{"width"});
        }
    });
    public static final LoadingCache<ShapedOreRecipe, Integer> SOR_HEIGHT = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<ShapedOreRecipe, Integer>(){

        public Integer load(@Nonnull ShapedOreRecipe key) throws Exception {
            return (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)key, (String[])new String[]{"height"});
        }
    });
    private final ItemStackHandler recipeSlots = this.registerNBT("recipe", new XUTileItemStackHandler(9, this));
    private final ItemStackHandler output = this.registerNBT("output", new XUTileItemStackHandler(9, this));
    private final StackDump extraStacks = this.registerNBT("extrastacks", new StackDump());
    private final ItemStackHandler contents = this.registerNBT("contents", new XUTileItemStackHandler(9, this){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deserializeNBT(NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            if (this.getSlots() == 27) {
                MinecraftServer server;
                int i;
                ArrayAccess prevStacks = CompatHelper.getArray10List11(this.stacks);
                ArrayList dumpStacks = Lists.newArrayList();
                for (i = 9; i < 27; ++i) {
                    ItemStack stack = (ItemStack)prevStacks.get(i);
                    if (!StackHelper.isNonNull(stack)) continue;
                    dumpStacks.add(stack);
                }
                if (!dumpStacks.isEmpty() && (server = FMLCommonHandler.instance().getMinecraftServerInstance()) != null) {
                    Queue queue = server.field_175589_i;
                    synchronized (queue) {
                        server.field_175589_i.add(ListenableFutureTask.create(() -> dumpStacks.forEach(TileCrafter.this.extraStacks::addStack), (Object)Boolean.TRUE));
                    }
                }
                this.setSize(9);
                for (i = 0; i < 9; ++i) {
                    CompatHelper.getArray10List11(this.stacks).set(i, prevStacks.get(i));
                }
            }
        }
    });
    private final SingleStackHandler ghostOutput = new SingleStackHandler();
    IRecipe curRecipe;
    Predicate<ItemStack>[] recipeMatchers = null;
    ItemStack[] genericStacks;
    XUCrafter crafter = new XUCrafter();
    IItemHandler publicOutputSlot = ConcatItemHandler.concatNonNull(new PublicWrapper.Insert((IItemHandlerModifiable)this.contents), new PublicWrapper.Extract((IItemHandlerModifiable)this.output));
    private NBTSerializable.NBTEnum<ContainerMode> mode = this.registerNBT("mode", new NBTSerializable.NBTEnum<ContainerMode>(ContainerMode.CONTAINER_ITEMS_STAY_IN_INPUT));

    public static String errLog(IRecipe recipe) {
        if (recipe == null) {
            return "[null recipe]";
        }
        try {
            return "[" + recipe.getClass() + "=" + recipe.func_77571_b() + "]";
        }
        catch (Exception err) {
            return "[" + recipe.getClass() + "=ERROR_GETTING_RECIPE_OUTPUT]";
        }
    }

    @Override
    protected boolean operate() {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (this.extraStacks.hasStacks()) {
            this.extraStacks.attemptDump((IItemHandler)this.output);
        }
        if (this.curRecipe == NullRecipe.INSTANCE) {
            return false;
        }
        if (this.genericStacks == null) {
            return false;
        }
        List<IItemHandler> adjHandlers = this.getAdjacentHandlers();
        this.crafter.loadStacks(this.genericStacks);
        if (!this.curRecipe.func_77569_a((InventoryCrafting)this.crafter, this.field_145850_b)) {
            return false;
        }
        BitSet matched = new BitSet(9);
        for (int i = 0; i < this.genericStacks.length; ++i) {
            if (!StackHelper.isNull(this.genericStacks[i])) continue;
            matched.set(i);
        }
        if (matched.cardinality() == 9) {
            return false;
        }
        IItemHandler copyContents = InventoryHelper.copyHandler((IItemHandler)this.contents);
        IItemHandler copyOutput = InventoryHelper.copyHandler((IItemHandler)this.output);
        for (int i = 0; i < 9; ++i) {
            ItemStack take;
            if (matched.get(i) || !StackHelper.isNonNull(take = this.takeItem(i, this.recipeMatchers[i], copyContents, false, this.crafter))) continue;
            matched.set(i);
        }
        if (matched.cardinality() < 9 && !adjHandlers.isEmpty()) {
            ItemStack take;
            int i;
            BitSet clone = (BitSet)matched.clone();
            ArrayList<IItemHandler> adjHandlersCopy = new ArrayList<IItemHandler>(adjHandlers.size());
            for (IItemHandler adjHandler : adjHandlers) {
                adjHandlersCopy.add(InventoryHelper.copyHandler(adjHandler));
            }
            XUCrafter crafterCopy = new XUCrafter();
            crafterCopy.loadStacks(this.crafter);
            IItemHandler copy2 = InventoryHelper.copyHandler((IItemHandler)this.contents);
            block3: for (i = 0; i < 9; ++i) {
                if (clone.get(i)) continue;
                Iterator<Object> iterator = adjHandlersCopy.iterator();
                while (iterator.hasNext()) {
                    IItemHandler adjHandler = (IItemHandler)iterator.next();
                    take = this.takeItem(i, this.recipeMatchers[i], adjHandler, true, crafterCopy);
                    if (!StackHelper.isNonNull(take) || !StackHelper.isNull(InventoryHelper.insert(copy2, take, true))) continue;
                    take = this.takeItem(i, this.recipeMatchers[i], adjHandler, false, this.crafter);
                    InventoryHelper.insert(copy2, take, false);
                    clone.set(i);
                    continue block3;
                }
            }
            if (clone.cardinality() < 9) {
                return false;
            }
            block5: for (i = 0; i < 9; ++i) {
                if (matched.get(i)) continue;
                for (IItemHandler adjHandler : adjHandlers) {
                    take = this.takeItem(i, this.recipeMatchers[i], adjHandler, true, this.crafter);
                    if (!StackHelper.isNonNull(take) || !StackHelper.isNull(InventoryHelper.insert((IItemHandler)this.contents, take, true))) continue;
                    take = this.takeItem(i, this.recipeMatchers[i], adjHandler, false, this.crafter);
                    InventoryHelper.insert((IItemHandler)this.contents, take, false);
                    matched.set(i);
                    continue block5;
                }
            }
        }
        if (matched.cardinality() < 9) {
            return false;
        }
        if (!this.curRecipe.func_77569_a((InventoryCrafting)this.crafter, this.field_145850_b)) {
            return false;
        }
        ItemStack outputStack = this.curRecipe.func_77572_b((InventoryCrafting)this.crafter);
        if (StackHelper.isNull(outputStack)) {
            return false;
        }
        if (StackHelper.isNonNull(InventoryHelper.insert(copyOutput, outputStack, false))) {
            return false;
        }
        for (ItemStack stack : this.curRecipe.func_179532_b((InventoryCrafting)this.crafter)) {
            if (!StackHelper.isNonNull(stack) || !StackHelper.isNonNull(InventoryHelper.insert(this.mode.value == ContainerMode.CONTAINER_ITEMS_STAY_IN_INPUT ? copyContents : copyOutput, stack, false))) continue;
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (this.recipeMatchers[i] == null) continue;
            this.takeItem(i, this.recipeMatchers[i], (IItemHandler)this.contents, false, this.crafter);
        }
        outputStack = this.curRecipe.func_77572_b((InventoryCrafting)this.crafter);
        InventoryHelper.insert((IItemHandler)this.output, outputStack, false);
        for (ItemStack stack : this.curRecipe.func_179532_b((InventoryCrafting)this.crafter)) {
            if (!StackHelper.isNonNull(stack)) continue;
            InventoryHelper.insert((IItemHandler)(this.mode.value == ContainerMode.CONTAINER_ITEMS_STAY_IN_INPUT ? this.contents : this.output), stack, false);
        }
        return true;
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        super.addToDescriptionPacket(packet);
        packet.writeItemStack(this.ghostOutput.getStack());
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        super.handleDescriptionPacket(packet);
        this.ghostOutput.setStack(packet.readItemStack());
    }

    @Override
    public boolean preOperate() {
        if (this.curRecipe == null) {
            int i;
            this.crafter.loadStacks((IItemHandler)this.recipeSlots);
            List<IRecipe> recipes = CraftingHelper112.getRecipeList();
            for (IRecipe recipe : recipes) {
                try {
                    if (!recipe.func_77569_a((InventoryCrafting)this.crafter, this.field_145850_b) || !StackHelper.isNonNull(recipe.func_77572_b((InventoryCrafting)this.crafter))) continue;
                    this.curRecipe = recipe;
                    break;
                }
                catch (Exception err) {
                    throw new RuntimeException("Caught exception while querying recipe " + TileCrafter.errLog(recipe), err);
                }
            }
            if (this.curRecipe == null) {
                this.curRecipe = NullRecipe.INSTANCE;
                if (StackHelper.isNonNull(this.ghostOutput.getStack())) {
                    this.markForUpdate();
                }
                this.ghostOutput.setStack(StackHelper.empty());
            }
            this.ghostOutput.setStack(this.curRecipe.func_77572_b((InventoryCrafting)this.crafter));
            this.markForUpdate();
            this.genericStacks = new ItemStack[9];
            for (i = 0; i < this.genericStacks.length; ++i) {
                this.genericStacks[i] = StackHelper.empty();
            }
            this.recipeMatchers = new Predicate[9];
            for (i = 0; i < this.recipeMatchers.length; ++i) {
                this.recipeMatchers[i] = StackHelper::isNull;
            }
            List<Object> input = CraftingHelper112.getRecipeInputs(this.curRecipe);
            if (input.isEmpty()) {
                this.curRecipe = NullRecipe.INSTANCE;
                if (StackHelper.isNonNull(this.ghostOutput.getStack())) {
                    this.markForUpdate();
                }
                this.ghostOutput.setStack(StackHelper.empty());
            }
            for (int i2 = 0; i2 < input.size(); ++i2) {
                this.genericStacks[i2] = StackHelper.empty();
                Object o = input.get(i2);
                if ((o = CraftingHelper112.unwrapIngredients(o)) instanceof List) {
                    List o1 = (List)o;
                    if (!o1.isEmpty()) {
                        block6: for (Object o2 : o1) {
                            ItemStack o21 = (ItemStack)o2;
                            for (int j = 0; j < this.recipeSlots.getSlots(); ++j) {
                                ItemStack a = this.recipeSlots.getStackInSlot(j);
                                if (!OreDictionary.itemMatches((ItemStack)a, (ItemStack)o21, (boolean)false)) continue;
                                this.genericStacks[i2] = a;
                                break block6;
                            }
                        }
                        if (StackHelper.isNull(this.genericStacks[i2])) {
                            this.genericStacks[i2] = (ItemStack)o1.iterator().next();
                        }
                    }
                } else if (o instanceof ItemStack) {
                    this.genericStacks[i2] = (ItemStack)o;
                }
                this.recipeMatchers[i2] = input.get(i2) instanceof Predicate ? (Predicate<Object>)input.get(i2) : Matchers.createMatcher(o, true);
            }
        }
        return this.curRecipe != NullRecipe.INSTANCE;
    }

    private List<IItemHandler> getAdjacentHandlers() {
        ArrayList<IItemHandler> adjHandlers = new ArrayList<IItemHandler>();
        for (EnumFacing facing : EnumFacing.values()) {
            IItemHandler handler;
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tile == null || (handler = CapGetter.ItemHandler.getInterface((ICapabilityProvider)tile, facing.func_176734_d())) == null) continue;
            adjHandlers.add(handler);
        }
        return adjHandlers;
    }

    public ItemStack takeItem(int slot, Predicate<ItemStack> matcher, IItemHandler handler, boolean simulate, XUCrafter crafter) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack take;
            ItemStack stack = handler.getStackInSlot(i);
            if (!StackHelper.isNonNull(stack) || !matcher.test(stack) || !StackHelper.isNonNull(take = handler.extractItem(i, 1, simulate))) continue;
            crafter.func_70299_a(slot, take);
            if (this.curRecipe.func_77569_a((InventoryCrafting)crafter, this.field_145850_b) && StackHelper.isNonNull(this.curRecipe.func_77572_b((InventoryCrafting)crafter))) {
                return take;
            }
            crafter.func_70299_a(slot, this.genericStacks[slot]);
        }
        return StackHelper.empty();
    }

    @Override
    protected Iterable<ItemStack> getDropHandler() {
        return InventoryHelper.getItemHandlerIterator(new IItemHandler[]{this.contents, this.upgrades});
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.publicOutputSlot;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new CrafterContainer(this, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IBlockAccess world, BlockPos pos, double x, double y, double z, float partialTicks, int destroyStage, IVertexBuffer renderer, BlockRendererDispatcher blockRenderer) {
        Pair pair;
        ItemStack stack = this.ghostOutput.getStack();
        if (StackHelper.isNull(stack)) {
            return;
        }
        IBakedModel duplicateModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        IBakedModel finalModel = duplicateModel.func_188617_f().handleItemState(duplicateModel, stack, this.field_145850_b, null);
        if (finalModel instanceof ICompatPerspectiveAwareModel && (pair = ((ICompatPerspectiveAwareModel)finalModel).handlePerspective(ItemCameraTransforms.TransformType.GROUND)).getLeft() != null) {
            finalModel = (IBakedModel)pair.getLeft();
        }
        finalModel = ModifyingBakedModel.create(finalModel, (original, base, state1, side, rand) -> {
            float t = MCTimer.renderTimer / 64.0f;
            float c = MathHelper.func_76134_b((float)t);
            float s = MathHelper.func_76126_a((float)t);
            ArrayList list = Lists.newArrayListWithExpectedSize((int)original.size());
            for (BakedQuad bakedQuad : original) {
                int[] data = Arrays.copyOf(bakedQuad.func_178209_a(), 28);
                for (int i = 0; i < 28; i += 7) {
                    float ax = Float.intBitsToFloat(data[i]) - 0.5f;
                    float ay = Float.intBitsToFloat(data[i + 1]);
                    float az = Float.intBitsToFloat(data[i + 2]) - 0.5f;
                    data[i] = Float.floatToRawIntBits(0.5f + (ax * c - az * s) * 0.25f);
                    data[i + 1] = Float.floatToRawIntBits(0.05f + ay * 0.25f);
                    data[i + 2] = Float.floatToRawIntBits(0.5f + (ax * s + az * c) * 0.25f);
                }
                list.add(new BakedQuad(data, bakedQuad.func_178211_c(), bakedQuad.func_178210_d(), bakedQuad.func_187508_a(), bakedQuad.shouldApplyDiffuseLighting(), bakedQuad.getFormat()));
            }
            return list;
        });
        blockRenderer.func_175019_b().func_178267_a(world, finalModel, Blocks.field_150350_a.func_176223_P(), this.func_174877_v().func_177984_a(), CompatClientHelper.unwrap(renderer), false);
    }

    @Override
    public void preRender(int destroyStage) {
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
    }

    @Override
    public void postRender(int destroyStage) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    public static class CrafterContainer
    extends DynamicContainerTile {
        public WidgetSlotGhost[] ghostSlots = new WidgetSlotGhost[9];

        public CrafterContainer(final TileCrafter tileCrafter, EntityPlayer player) {
            super(tileCrafter);
            int x;
            int y;
            tileCrafter.curRecipe = null;
            this.addTitle("AutoCrafter");
            this.crop();
            this.height -= 8;
            int u = this.height;
            int l = 140;
            int l2 = (l - 102) / 2;
            this.addWidget(new WidgetProgressArrowBase(l2 + 54 + 4, u + 18));
            this.addWidget(TileAdvInteractor.getRSWidget(l, u, tileCrafter.redstone_state, tileCrafter.pulses));
            this.addWidget(tileCrafter.upgrades.getSpeedUpgradeSlot(l, u + 36));
            this.addWidget(new WidgetSlotReadOnly(tileCrafter.ghostOutput, 0, l2 + 54 + 22 + 8, u + 18){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                }
            });
            this.addWidget((IWidget)((WidgetClickMCButtonChoices)new WidgetClickMCButtonChoices<ContainerMode>(l, u + 18){

                @Override
                protected void onSelectedServer(ContainerMode marker) {
                    ((TileCrafter)tileCrafter).mode.value = marker;
                }

                @Override
                public ContainerMode getSelectedValue() {
                    return (ContainerMode)((Object)((TileCrafter)tileCrafter).mode.value);
                }
            }.addChoice(ContainerMode.CONTAINER_ITEMS_TO_OUTPUT, new ItemStack(Items.field_151133_ar), Lang.translate("Move Ancillary Items To Output"))).addChoice((ContainerMode)ContainerMode.CONTAINER_ITEMS_STAY_IN_INPUT, new ItemStack((Block)Blocks.field_150486_ae), Lang.translate("Keep Ancillary Items In Input")));
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 3; ++x) {
                    int i = x + y * 3;
                    this.ghostSlots[i] = new WidgetSlotGhost((IItemHandlerModifiable)tileCrafter.recipeSlots, i, l2 + x * 18, u + y * 18){

                        @Override
                        public void func_75215_d(ItemStack stack) {
                            tileCrafter.curRecipe = null;
                            super.func_75215_d(stack);
                        }
                    };
                    this.addWidget(this.ghostSlots[i]);
                }
            }
            this.crop();
            this.height -= 2;
            this.addWidget(new WidgetTextTranslate(4, this.height, Lang.getKey("Input Inventory"), 162));
            this.crop();
            this.height -= 4;
            for (y = 0; y < 1; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.addWidget(new WidgetSlotItemHandler((IItemHandler)tileCrafter.contents, x + y * 9, 4 + x * 18, this.height + y * 18));
                }
            }
            this.crop();
            this.addWidget(new WidgetTextTranslate(4, this.height, Lang.getKey("Output Inventory"), 162));
            this.crop();
            this.height -= 4;
            for (int i = 0; i < 9; ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)tileCrafter.output, i, 4 + i * 18, this.height));
            }
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }

    public static enum ContainerMode {
        CONTAINER_ITEMS_TO_OUTPUT,
        CONTAINER_ITEMS_STAY_IN_INPUT;

    }
}

