/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.textures.SpriteColorMask;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockColors
extends XUBlock {
    final String tex;
    String spriteBase;
    String spriteMask;

    public BlockColors(Material rock, String tex) {
        super(rock);
        this.tex = tex;
    }

    @Override
    public void registerTextures() {
        this.spriteBase = SpriteColorMask.registerSupplier(this.tex, "base", false);
        this.spriteMask = SpriteColorMask.registerSupplier(this.tex, "mask", true);
    }

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        return BoxModel.newStandardBlock();
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, @Nonnull BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.SOLID;
    }

    @Override
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        BoxModel model = new BoxModel();
        model.renderAsNormalBlock = true;
        float eps2 = 0.0f;
        Box mask = new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        mask.texture = this.spriteMask;
        mask.setLayer(BlockRenderLayer.TRANSLUCENT);
        long positionRandom = MathHelper.func_180186_a((Vec3i)pos);
        Random random = new Random(positionRandom);
        mask.tint = ColorHelper.color(random.nextInt(256), random.nextInt(256), random.nextInt(256), 255);
        model.add(mask);
        float eps = 0.0f;
        Box under = new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        block8: for (EnumFacing side : EnumFacing.values()) {
            if (!world.func_180495_p(pos.func_177972_a(side)).doesSideBlockRendering(world, pos.func_177972_a(side), side.func_176734_d())) continue;
            under.invisible[side.ordinal()] = true;
            mask.invisible[side.ordinal()] = true;
            switch (side) {
                case DOWN: {
                    under.minY = 0.0f;
                    continue block8;
                }
                case UP: {
                    under.maxY = 1.0f;
                    continue block8;
                }
                case NORTH: {
                    under.minZ = 0.0f;
                    continue block8;
                }
                case SOUTH: {
                    under.maxZ = 1.0f;
                    continue block8;
                }
                case WEST: {
                    under.minX = 0.0f;
                    continue block8;
                }
                case EAST: {
                    under.maxX = 1.0f;
                }
            }
        }
        under.texture = this.spriteBase;
        model.add(under);
        return model;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addItemColors(ItemColors itemColors, net.minecraft.client.renderer.color.BlockColors blockColors) {
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> tintIndex, new Block[]{this});
    }

    @Override
    @Nonnull
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        return BoxModel.newStandardBlock(this.spriteBase);
    }
}

