/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.flow;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.pipe.IFlowPower;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.api.transport.pipe.PipeEvent;
import buildcraft.api.transport.pipe.PipeEventPower;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.core.BCCoreConfig;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.AverageInt;
import buildcraft.transport.pipe.flow.IPipeTransportPowerHook;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.function.ToLongFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;

public class PipeFlowPower
extends PipeFlow
implements IFlowPower,
IDebuggable {
    private static final long DEFAULT_MAX_POWER = MjAPI.MJ * 10L;
    public static final int NET_POWER_AMOUNTS = 2;
    public Vec3d clientDisplayFlowCentre = Vec3d.field_186680_a;
    public Vec3d clientDisplayFlowCentreLast = Vec3d.field_186680_a;
    public long clientLastDisplayTime = 0L;
    private long maxPower = -1L;
    private long powerLoss = -1L;
    private long powerResistance = -1L;
    private long currentWorldTime;
    private boolean isReceiver = false;
    private final EnumMap<EnumFacing, Section> sections;
    private final SafeTimeTracker tracker = new SafeTimeTracker((long)BCCoreConfig.networkUpdateRate);
    private long[] transferQuery;

    public PipeFlowPower(IPipe pipe) {
        super(pipe);
        this.sections = new EnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            this.sections.put(face, new Section(face));
        }
    }

    public PipeFlowPower(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.isReceiver = nbt.func_74767_n("isReceiver");
        this.sections = new EnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            this.sections.put(face, new Section(face));
        }
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74757_a("isReceiver", this.isReceiver);
        return nbt;
    }

    public void writePayload(int id, PacketBuffer buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && (id == 2 || id == 0)) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                Section s = this.sections.get(face);
                buffer.writeInt(s.displayPower);
                buffer.func_179249_a((Enum)s.displayFlow);
            }
        }
    }

    public void readPayload(int id, PacketBuffer buffer, Side side) throws IOException {
        super.readPayload(id, buffer, side);
        if (side == Side.CLIENT && (id == 2 || id == 0)) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                Section s = this.sections.get(face);
                s.displayPower = buffer.readInt();
                s.displayFlow = (EnumFlow)buffer.func_179257_a(EnumFlow.class);
            }
        }
    }

    public boolean canConnect(EnumFacing face, PipeFlow other) {
        return other instanceof PipeFlowPower;
    }

    public boolean canConnect(EnumFacing face, TileEntity oTile) {
        IMjPassiveProvider provider;
        if (this.isReceiver && (provider = (IMjPassiveProvider)oTile.getCapability(MjAPI.CAP_PASSIVE_PROVIDER, face.func_176734_d())) != null) {
            return true;
        }
        IMjConnector receiver = (IMjConnector)oTile.getCapability(MjAPI.CAP_CONNECTOR, face.func_176734_d());
        return receiver != null && receiver.canConnect((IMjConnector)this.sections.get(face));
    }

    public void reconfigure() {
        PipeEventPower.Configure configure = new PipeEventPower.Configure(this.pipe.getHolder(), (IFlowPower)this);
        PipeApi.PowerTransferInfo pti = PipeApi.getPowerTransferInfo((PipeDefinition)this.pipe.getDefinition());
        configure.setReceiver(pti.isReceiver);
        configure.setMaxPower(pti.transferPerTick);
        configure.setPowerLoss(pti.lossPerTick);
        configure.setPowerResistance(pti.resistancePerTick);
        this.pipe.getHolder().fireEvent((PipeEvent)configure);
        this.isReceiver = configure.isReceiver();
        this.maxPower = configure.getMaxPower();
        if (this.maxPower <= 0L) {
            this.maxPower = DEFAULT_MAX_POWER;
        }
        this.powerLoss = MathUtil.clamp((long)configure.getPowerLoss(), (long)-1L, (long)this.maxPower);
        this.powerResistance = MathUtil.clamp((long)configure.getPowerResistance(), (long)-1L, (long)MjAPI.MJ);
        if (this.powerLoss < 0L) {
            if (this.powerResistance < 0L) {
                this.powerResistance = MjAPI.MJ / 100L;
            }
            this.powerLoss = this.maxPower * this.powerResistance / MjAPI.MJ;
        } else if (this.powerResistance < 0L) {
            this.powerResistance = this.powerLoss * MjAPI.MJ / this.maxPower;
        }
    }

    public long tryExtractPower(long maxExtracted, EnumFacing from) {
        if (!this.isReceiver) {
            return 0L;
        }
        TileEntity tile = this.pipe.getConnectedTile(from);
        if (tile == null) {
            return 0L;
        }
        IMjPassiveProvider receiver = (IMjPassiveProvider)tile.getCapability(MjAPI.CAP_PASSIVE_PROVIDER, from.func_176734_d());
        if (receiver == null) {
            return 0L;
        }
        return 0L;
    }

    public boolean onFlowActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        return super.onFlowActivate(player, trace, hitX, hitY, hitZ, part);
    }

    public Section getSection(EnumFacing side) {
        return this.sections.get(side);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        if (capability == MjAPI.CAP_RECEIVER) {
            return (T)(this.isReceiver ? MjAPI.CAP_RECEIVER.cast((Object)this.sections.get(facing)) : null);
        }
        if (capability == MjAPI.CAP_CONNECTOR) {
            return (T)MjAPI.CAP_CONNECTOR.cast((Object)this.sections.get(facing));
        }
        return null;
    }

    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("maxPower = " + LocaleUtil.localizeMj((long)this.maxPower));
        left.add("isReceiver = " + this.isReceiver);
        left.add("internalPower = " + this.arrayToString(s -> s.internalPower) + " <- " + this.arrayToString(s -> s.internalNextPower));
        left.add("- powerQuery: " + this.arrayToString(s -> s.powerQuery) + " <- " + this.arrayToString(s -> s.nextPowerQuery));
        left.add("- power: IN " + this.arrayToString(s -> s.debugPowerInput) + ", OUT " + this.arrayToString(s -> s.debugPowerOutput));
        left.add("- power: OFFERED " + this.arrayToString(s -> s.debugPowerOffered));
    }

    private String arrayToString(ToLongFunction<Section> getter) {
        long[] arr = new long[6];
        for (EnumFacing face : EnumFacing.field_82609_l) {
            arr[face.ordinal()] = getter.applyAsLong(this.sections.get(face)) / MjAPI.MJ;
        }
        return Arrays.toString(arr);
    }

    public void onTick() {
        Section s;
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            this.clientDisplayFlowCentreLast = this.clientDisplayFlowCentre;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                Section s2 = this.sections.get(face);
                s2.clientDisplayFlowLast = s2.clientDisplayFlow;
                double diff = (double)s2.displayFlow.value * 2.4 * (double)face.func_176743_c().func_179524_a();
                s2.clientDisplayFlow += 16.0 + diff;
                s2.clientDisplayFlow %= 16.0;
                double cVal = VecUtil.getValue((Vec3d)this.clientDisplayFlowCentre, (EnumFacing.Axis)face.func_176740_k());
                cVal += 16.0 + diff / 2.0;
                this.clientDisplayFlowCentre = VecUtil.replaceValue((Vec3d)this.clientDisplayFlowCentre, (EnumFacing.Axis)face.func_176740_k(), (double)(cVal %= 16.0));
            }
            return;
        }
        if (this.maxPower == -1L) {
            this.reconfigure();
        }
        EnumFlow[] lastFlows = new EnumFlow[6];
        int[] lastDisplayPower = new int[6];
        for (Object face : EnumFacing.field_82609_l) {
            s = this.sections.get(face);
            int i = face.ordinal();
            lastFlows[i] = s.displayFlow;
            lastDisplayPower[i] = s.displayPower;
        }
        this.step();
        this.init();
        for (Object face : EnumFacing.field_82609_l) {
            s = this.sections.get(face);
            if (s.internalPower <= 0L) continue;
            long totalPowerQuery = 0L;
            for (EnumFacing face2 : EnumFacing.field_82609_l) {
                if (face == face2) continue;
                totalPowerQuery += this.sections.get((Object)face2).powerQuery;
            }
            if (totalPowerQuery <= 0L) continue;
            long unusedPowerQuery = totalPowerQuery;
            for (EnumFacing face2 : EnumFacing.field_82609_l) {
                if (face == face2) continue;
                Section s2 = this.sections.get(face2);
                if (s2.powerQuery <= 0L) continue;
                long watts = Math.min(BigInteger.valueOf(s.internalPower).multiply(BigInteger.valueOf(s2.powerQuery)).divide(BigInteger.valueOf(unusedPowerQuery)).longValue(), s.internalPower);
                unusedPowerQuery -= s2.powerQuery;
                IPipe neighbour = this.pipe.getConnectedPipe(face2);
                long leftover = watts;
                if (neighbour != null && neighbour.getFlow() instanceof PipeFlowPower && neighbour.isConnected(face2.func_176734_d())) {
                    PipeFlowPower oFlow = (PipeFlowPower)neighbour.getFlow();
                    leftover = oFlow.sections.get(face2.func_176734_d()).receivePowerInternal(watts);
                } else {
                    IMjReceiver receiver = (IMjReceiver)this.pipe.getHolder().getCapabilityFromPipe(face2, MjAPI.CAP_RECEIVER);
                    if (receiver != null && receiver.canReceive()) {
                        leftover = receiver.receivePower(watts, false);
                    }
                }
                long used = watts - leftover;
                s.internalPower -= used;
                s2.debugPowerOutput += used;
                s.powerAverage.push((int)used);
                s2.powerAverage.push((int)used);
                s.displayFlow = EnumFlow.OUT;
                s2.displayFlow = EnumFlow.IN;
            }
        }
        for (Section s3 : this.sections.values()) {
            s3.powerAverage.tick();
            double value = s3.powerAverage.getAverage() / (double)this.maxPower;
            value = Math.sqrt(value);
            s3.displayPower = (int)(value * (double)MjAPI.MJ);
        }
        for (Object face : EnumFacing.field_82609_l) {
            long requested;
            IMjReceiver recv;
            if (this.pipe.getConnectedType(face) != IPipe.ConnectedType.TILE || (recv = (IMjReceiver)this.pipe.getHolder().getCapabilityFromPipe(face, MjAPI.CAP_RECEIVER)) == null || !recv.canReceive() || (requested = recv.getPowerRequested()) <= 0L) continue;
            this.requestPower((EnumFacing)face, requested);
        }
        long[] transferQueryTemp = new long[6];
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!this.pipe.isConnected(face)) continue;
            long query = 0L;
            for (EnumFacing face2 : EnumFacing.field_82609_l) {
                if (face == face2) continue;
                query += this.sections.get((Object)face2).powerQuery;
            }
            transferQueryTemp[face.ordinal()] = query;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IPipe oPipe;
            if (transferQueryTemp[face.ordinal()] <= 0L || !this.pipe.isConnected(face) || (oPipe = this.pipe.getHolder().getNeighbourPipe(face)) == null || !(oPipe.getFlow() instanceof PipeFlowPower)) continue;
            PipeFlowPower oFlow = (PipeFlowPower)oPipe.getFlow();
            oFlow.requestPower(face.func_176734_d(), transferQueryTemp[face.ordinal()]);
        }
        boolean didChange = false;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            Section s4 = this.sections.get(face);
            int i = face.ordinal();
            if (lastFlows[i] == s4.displayFlow && lastDisplayPower[i] == s4.displayPower) continue;
            didChange = true;
            break;
        }
        if (didChange) {
            this.sendPayload(2);
        }
        this.transferQuery = transferQueryTemp;
    }

    private void step() {
        long now = this.pipe.getHolder().getPipeWorld().func_82737_E();
        if (this.currentWorldTime != now) {
            this.currentWorldTime = now;
            this.sections.values().forEach(Section::step);
        }
    }

    private void init() {
    }

    private void requestPower(EnumFacing from, long amount) {
        this.step();
        Section s = this.sections.get(from);
        s.nextPowerQuery = this.pipe.getBehaviour() instanceof IPipeTransportPowerHook ? (s.nextPowerQuery += (long)((IPipeTransportPowerHook)this.pipe.getBehaviour()).requestPower(from, amount)) : (s.nextPowerQuery += amount);
    }

    public long getPowerRequested(@Nullable EnumFacing side) {
        long req = 0L;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (side != null && face == side) continue;
            req += this.sections.get((Object)face).powerQuery;
        }
        return req;
    }

    public double getMaxTransferForRender(float partialTicks) {
        return (double)this.maxPower / (double)MjAPI.MJ;
    }

    public static enum EnumFlow {
        IN(-1),
        OUT(1),
        STATIONARY(0);

        public final int value;

        private EnumFlow(int value) {
            this.value = value;
        }
    }

    public class Section
    implements IMjReceiver {
        public final EnumFacing side;
        public final AverageInt clientDisplayAverage = new AverageInt(10);
        public double clientDisplayFlow;
        public double clientDisplayFlowLast;
        public int displayPower;
        public EnumFlow displayFlow = EnumFlow.STATIONARY;
        public long nextPowerQuery;
        public long internalNextPower;
        public final AverageInt powerAverage = new AverageInt(10);
        long powerQuery;
        long internalPower;
        long debugPowerInput;
        long debugPowerOutput;
        long debugPowerOffered;

        public Section(EnumFacing side) {
            this.side = side;
        }

        void step() {
            this.powerQuery = this.nextPowerQuery;
            this.nextPowerQuery = 0L;
            long next = this.internalPower;
            this.internalPower = this.internalNextPower;
            this.internalNextPower = next;
        }

        public boolean canConnect(@Nonnull IMjConnector other) {
            return true;
        }

        public long getPowerRequested() {
            return PipeFlowPower.this.getPowerRequested(this.side);
        }

        long receivePowerInternal(long sent) {
            if (sent > 0L) {
                this.debugPowerOffered += sent;
                this.internalNextPower += sent;
                return 0L;
            }
            return sent;
        }

        public long receivePower(long microJoules, boolean simulate) {
            if (PipeFlowPower.this.isReceiver) {
                PipeFlowPower.this.step();
                if (!simulate) {
                    return this.receivePowerInternal(microJoules);
                }
                return 0L;
            }
            return microJoules;
        }

        public boolean canReceive() {
            return PipeFlowPower.this.isReceiver;
        }
    }
}

