/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func;

import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.NodeInliningHelper;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.INodeFunc;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.INodeStack;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.NodeTypes;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func.NodeFuncBase;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func.StringFunctionBi;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeConstantObject;

public class NodeFuncObjectToObject<A, R>
extends NodeFuncBase
implements INodeFunc.INodeFuncObject<R> {
    public final IFuncObjectToObject<A, R> function;
    private final StringFunctionBi stringFunction;
    private final Class<A> argTypeA;
    private final Class<R> returnType;

    public NodeFuncObjectToObject(String name, Class<A> argTypeA, Class<R> returnType, IFuncObjectToObject<A, R> function) {
        this(argTypeA, returnType, function, (String a) -> "[ " + NodeTypes.getName(argTypeA) + " -> " + NodeTypes.getName(returnType) + " ] " + name + "(" + a + ")");
    }

    public NodeFuncObjectToObject(Class<A> argTypeA, Class<R> returnType, IFuncObjectToObject<A, R> function, StringFunctionBi stringFunction) {
        this.argTypeA = argTypeA;
        this.returnType = returnType;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    @Override
    public Class<R> getType() {
        return this.returnType;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public IExpressionNode.INodeObject<R> getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return new Func(a);
    }

    @FunctionalInterface
    public static interface IFuncObjectToObject<A, R> {
        public R apply(A var1);
    }

    private class Func
    implements IExpressionNode.INodeObject<R> {
        private final IExpressionNode.INodeObject<A> argA;

        public Func(IExpressionNode.INodeObject<A> argA) {
            this.argA = argA;
        }

        @Override
        public Class<R> getType() {
            return NodeFuncObjectToObject.this.returnType;
        }

        @Override
        public R evaluate() {
            return NodeFuncObjectToObject.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeObject<R> inline() {
            if (!NodeFuncObjectToObject.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new Func(a), a -> new Func(a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new Func(a), a -> new NodeConstantObject(NodeFuncObjectToObject.this.returnType, NodeFuncObjectToObject.this.function.apply(a.evaluate())));
        }

        public String toString() {
            return NodeFuncObjectToObject.this.stringFunction.apply(this.argA.toString());
        }
    }
}

