/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.render;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class FontRendererSeparate
extends FontRenderer {
    private final Map<ResourceLocation, BufferedImage> textureData = new HashMap<ResourceLocation, BufferedImage>();
    private final Map<ResourceLocation, Integer> textureLocations = new HashMap<ResourceLocation, Integer>();

    public FontRendererSeparate(GameSettings settings, ResourceLocation location, TextureManager textureManagerIn, boolean unicode) {
        super(settings, location, textureManagerIn, unicode);
        this.loadTex(location);
    }

    private void loadTex(ResourceLocation location) {
        try (IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);){
            this.textureData.put(location, TextureUtil.func_177053_a((InputStream)resource.func_110527_b()));
        }
        catch (FileNotFoundException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    protected void bindTexture(ResourceLocation location) {
        if (this.textureLocations == null) {
            return;
        }
        Integer value = this.textureLocations.get(location);
        if (value == null) {
            BufferedImage img = this.textureData.get(location);
            if (img == null) {
                return;
            }
            int next = GL11.glGenTextures();
            TextureUtil.func_110987_a((int)next, (BufferedImage)img);
            this.textureLocations.put(location, next);
            value = next;
        }
        GL11.glBindTexture((int)3553, (int)value);
    }

    public void destroy() {
        for (Integer value : this.textureLocations.values()) {
            GL11.glDeleteTextures((int)value);
        }
        this.textureLocations.clear();
    }
}

