/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json;

import alexiil.mc.mod.load.CLSLog;
import alexiil.mc.mod.load.ClsManager;
import alexiil.mc.mod.load.json.InvalidSourceException;
import alexiil.mc.mod.load.json.JsonAction;
import alexiil.mc.mod.load.json.JsonConfig;
import alexiil.mc.mod.load.json.JsonConfigurable;
import alexiil.mc.mod.load.json.JsonFactory;
import alexiil.mc.mod.load.json.JsonInsn;
import alexiil.mc.mod.load.json.JsonRender;
import alexiil.mc.mod.load.json.JsonRenderingPart;
import alexiil.mc.mod.load.json.JsonVariable;
import alexiil.mc.mod.load.json.serial.ConfigDeserialiser;
import alexiil.mc.mod.load.json.serial.FactoryDeserialiser;
import alexiil.mc.mod.load.json.serial.ImageDeserialiser;
import alexiil.mc.mod.load.json.serial.InstructionDeserialiser;
import alexiil.mc.mod.load.json.serial.RenderingPartDeserialiser;
import alexiil.mc.mod.load.json.serial.VariableArrayDeserialiser;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ConfigManager {
    public static final Gson GSON_ADAPTORS;
    public static final Gson GSON_DEFAULT;
    private static final Map<Class<? extends JsonConfigurable<?, ?>>, EType> types;
    private static IResourceManager resManager;
    private static final Map<ResourceLocation, String> cache;
    private static final Map<ResourceLocation, String> failedCache;

    /*
     * Enabled aggressive exception aggregation
     */
    private static String getFirst(ResourceLocation identifier, boolean firstAttempt) {
        if (identifier == null) {
            throw new NullPointerException("Identifier provided shouldn't have been null!");
        }
        try (IResource res = ClsManager.getResource(identifier);){
            String string;
            block18: {
                InputStream stream = res.func_110527_b();
                try {
                    string = IOUtils.toString((InputStream)stream);
                    if (stream == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        CLSLog.warn("Tried to access \"" + identifier + "\", but an IO exception occoured!", e);
                        String string2 = null;
                        return string2;
                    }
                }
                stream.close();
            }
            return string;
        }
        catch (IOException e) {
            if (firstAttempt) {
                CLSLog.warn("Tried to get the resource but failed! (" + identifier + ") because " + e.getClass());
            }
            return null;
        }
    }

    private static String getTextResource(ResourceLocation identifier) {
        if (identifier == null) {
            throw new NullPointerException("Identifier provided shouldn't have been null!");
        }
        if (cache.containsKey(identifier)) {
            return cache.get(identifier);
        }
        if (failedCache.containsKey(identifier)) {
            String attempt = ConfigManager.getFirst(identifier, false);
            if (attempt != null) {
                failedCache.remove(identifier);
                cache.put(identifier, attempt);
            }
            return attempt;
        }
        String actual = ConfigManager.getFirst(identifier, true);
        if (actual == null) {
            failedCache.put(identifier, null);
        } else {
            cache.put(identifier, actual);
        }
        return actual;
    }

    static <T extends JsonConfigurable<T, ?>> T getAsT(EType type, String location) throws InvalidExpressionException {
        if (StringUtils.isEmpty((CharSequence)location)) {
            CLSLog.warn("Location was given as null!", new Throwable());
            return null;
        }
        CLSLog.info("Getting " + location + " as " + (Object)((Object)type));
        ResourceLocation loc = ConfigManager.getLocation(type, location);
        String text = ConfigManager.getTextResource(loc);
        if (text == null) {
            JsonConfigurable<?, ?> failed = type.getNotFound(location);
            if (failed != null) {
                failed.setLocation(loc);
                return (T)failed;
            }
            CLSLog.warn("The text inside of \"" + loc + "\" was null!");
            return null;
        }
        try {
            JsonConfigurable t = (JsonConfigurable)GSON_ADAPTORS.fromJson(text, type.clazz);
            t.setLocation(loc);
            t.setSource(text);
            return (T)t;
        }
        catch (JsonSyntaxException t) {
            throw new InvalidSourceException("Failed to read from " + loc + "\n" + text, t);
        }
    }

    public static JsonRenderingPart getAsRenderingPart(String location) throws InvalidExpressionException {
        return (JsonRenderingPart)ConfigManager.getAsT(EType.RENDERING_PART, location);
    }

    public static JsonFactory getAsFactory(String location) throws InvalidExpressionException {
        return (JsonFactory)ConfigManager.getAsT(EType.FACTORY, location);
    }

    public static JsonRender getAsImage(String location) throws InvalidExpressionException {
        return (JsonRender)ConfigManager.getAsT(EType.IMAGE, location);
    }

    public static JsonInsn getAsInsn(String location) throws InvalidExpressionException {
        return (JsonInsn)ConfigManager.getAsT(EType.INSTRUCTION, location);
    }

    public static JsonAction getAsAction(String location) throws InvalidExpressionException {
        return (JsonAction)ConfigManager.getAsT(EType.ACTION, location);
    }

    public static JsonConfig getAsConfig(String location) throws InvalidExpressionException {
        return (JsonConfig)ConfigManager.getAsT(EType.CONFIG, location);
    }

    public static void getAsScript(String location) {
    }

    public static ResourceLocation getLocation(EType type, String base) {
        String path = base.startsWith("builtin/") ? "builtin/" + type.resourceBase + "/" + base.substring("builtin/".length()) + ".json" : (base.startsWith("sample/") ? "sample/" + type.resourceBase + "/" + base.substring("sample/".length()) + ".json" : type.resourceBase + "/" + base + ".json");
        return new ResourceLocation("customloadingscreen", path);
    }

    static {
        types = Maps.newHashMap();
        resManager = Minecraft.func_71410_x().func_110442_L();
        cache = Maps.newHashMap();
        failedCache = Maps.newHashMap();
        GSON_ADAPTORS = new GsonBuilder().registerTypeAdapter(JsonConfig.class, (Object)ConfigDeserialiser.INSTANCE).registerTypeAdapter(JsonRenderingPart.class, (Object)RenderingPartDeserialiser.INSTANCE).registerTypeAdapter(JsonRender.class, (Object)ImageDeserialiser.INSTANCE).registerTypeAdapter(JsonInsn.class, (Object)InstructionDeserialiser.INSTANCE).registerTypeAdapter(JsonVariable[].class, (Object)VariableArrayDeserialiser.INSTANCE).registerTypeAdapter(JsonFactory.class, (Object)FactoryDeserialiser.INSTANCE).create();
        GSON_DEFAULT = new GsonBuilder().setPrettyPrinting().create();
    }

    public static enum EType {
        FACTORY(JsonFactory.class, "factory"),
        ACTION(JsonAction.class, "action"),
        RENDERING_PART(JsonRenderingPart.class, "imagemeta"),
        IMAGE(JsonRender.class, "image"),
        INSTRUCTION(JsonInsn.class, "instruction"),
        CONFIG(JsonConfig.class, "config");

        public final Class<? extends JsonConfigurable<?, ?>> clazz;
        public final String resourceBase;

        public static EType valueOf(Class<? extends JsonConfigurable<?, ?>> configurable) {
            return (EType)((Object)types.get(configurable));
        }

        private <T extends JsonConfigurable<T, ?>> EType(Class<T> clazz, String resourceBase) {
            this.clazz = clazz;
            this.resourceBase = resourceBase;
            types.put(clazz, this);
        }

        public JsonConfigurable<?, ?> getNotFound(String location) throws InvalidExpressionException {
            JsonRender ji;
            if (this == RENDERING_PART && (ji = ConfigManager.getAsImage(location)) != null) {
                JsonRenderingPart jrp = new JsonRenderingPart(ji, new JsonInsn[0], "true");
                jrp.setSource(("{#-'image':'" + location + "'#}").replace('\'', '\"').replace('#', '\n').replace('-', '\t'));
                return jrp;
            }
            return null;
        }
    }
}

