/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface WorldTarget {
    @Nonnull
    public static final WorldTarget TRUE = new WorldTarget(){

        @Override
        public boolean isValid() {
            return true;
        }
    };
    @Nonnull
    public static final WorldTarget FALSE = new WorldTarget(){

        @Override
        public boolean isValid() {
            return false;
        }
    };

    public boolean isValid();

    default public boolean isValid(@Nonnull EntityPlayer player) {
        return this.isValid();
    }

    default public boolean isValid(@Nonnull EntityPlayer player, double maxDistanceSq) {
        return this.isValid(player);
    }

    @Nonnull
    default public IBlockState read() {
        return Blocks.field_150350_a.func_176223_P();
    }

    default public boolean write(@Nonnull IBlockState newState) {
        return false;
    }

    @Nonnull
    public static WorldTarget ofBlockPos(@Nonnull World world, @Nonnull BlockPos pos) {
        return new BlockPosTarget(world, pos);
    }

    @Nonnull
    public static WorldTarget ofBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block block) {
        return new BlockTarget(block, world, pos);
    }

    @Nonnull
    public static WorldTarget ofBlockState(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState blockstate) {
        return new BlockStateTarget(blockstate, world, pos);
    }

    public static class BlockStateTarget
    extends BlockTarget {
        @Nonnull
        private IBlockState targetBlockstate;

        private BlockStateTarget(@Nonnull IBlockState blockstate, @Nonnull World world, @Nonnull BlockPos pos) {
            super(blockstate.func_177230_c(), world, pos);
            this.targetBlockstate = blockstate;
        }

        @Override
        public boolean isValid() {
            return this.read() == this.targetBlockstate;
        }
    }

    public static class BlockTarget
    extends BlockPosTarget {
        @Nonnull
        final Block targetBlock;

        private BlockTarget(@Nonnull Block block, @Nonnull World world, @Nonnull BlockPos pos) {
            super(world, pos);
            this.targetBlock = block;
        }

        @Override
        public boolean isValid() {
            return this.read().func_177230_c() == this.targetBlock;
        }

        @Override
        public boolean isValid(@Nonnull EntityPlayer player) {
            return this.targetWorld.get() == player.field_70170_p && this.isValid();
        }

        @Override
        public boolean isValid(@Nonnull EntityPlayer player, double maxDistanceSq) {
            return player.func_174831_c(this.targetPos) <= maxDistanceSq && this.isValid(player);
        }
    }

    public static class BlockPosTarget
    implements WorldTarget {
        @Nonnull
        final WeakReference<World> targetWorld;
        @Nonnull
        final BlockPos targetPos;

        private BlockPosTarget(@Nonnull World world, @Nonnull BlockPos pos) {
            this.targetWorld = new WeakReference<World>(world);
            this.targetPos = pos.func_185334_h();
        }

        @Override
        public boolean isValid() {
            World world2 = (World)this.targetWorld.get();
            return world2 != null && world2.func_175667_e(this.targetPos);
        }

        @Override
        public boolean write(@Nonnull IBlockState newState) {
            World world2 = (World)this.targetWorld.get();
            if (world2 != null && world2.func_175667_e(this.targetPos)) {
                return world2.func_175656_a(this.targetPos, newState);
            }
            return WorldTarget.super.write(newState);
        }

        @Override
        @Nonnull
        public IBlockState read() {
            World world2 = (World)this.targetWorld.get();
            return world2 != null && world2.func_175667_e(this.targetPos) ? world2.func_180495_p(this.targetPos) : WorldTarget.super.read();
        }
    }
}

