/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NNMap;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.generator.stirling.ContainerStirlingGenerator;
import crazypants.enderio.machines.machine.generator.stirling.FuelCache;
import crazypants.enderio.machines.machine.generator.stirling.GuiStirlingGenerator;
import crazypants.enderio.machines.machine.generator.stirling.TileStirlingGenerator;
import crazypants.enderio.util.Prep;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class StirlingRecipeCategory
extends BlankRecipeCategory<StirlingRecipeWrapper> {
    @Nonnull
    public static final String UID = "StirlingGenerator";
    static int xOff = 28;
    static int yOff = 7;
    static int xSize = 133;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawableAnimated flame;

    public static void register(@Nonnull IModRegistry registry, @Nonnull IGuiHelper guiHelper) {
        if (!((Boolean)PersonalConfig.enableStirlingJEIRecipes.get()).booleanValue()) {
            return;
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new StirlingRecipeCategory(guiHelper)});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_stirling_generator.getBlockNN(), 1, 0), new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_simple_stirling_generator.getBlockNN(), 1, 0), new String[]{UID});
        registry.addRecipeClickArea(GuiStirlingGenerator.class, 155, 42, 16, 16, new String[]{UID});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerStirlingGenerator.Normal.class, UID, 0, 1, 2, 36);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerStirlingGenerator.Simple.class, UID, 0, 1, 1, 36);
        long start = System.nanoTime();
        FuelCache.initialize(registry.getIngredientRegistry().getAllIngredients(ItemStack.class));
        NNMap.Brutal recipeInputs = new NNMap.Brutal();
        FuelCache.getFuels().apply((NNList.Callback)new NNList.Callback<ItemStack>((NNMap)recipeInputs){
            final /* synthetic */ NNMap val$recipeInputs;
            {
                this.val$recipeInputs = nNMap;
            }

            public void apply(@Nonnull ItemStack stack) {
                int burntime = TileStirlingGenerator.getBurnTimeGeneric(stack);
                if (burntime <= 0) {
                    return;
                }
                if (this.val$recipeInputs.containsKey((Object)burntime)) {
                    ((NNList)this.val$recipeInputs.get((Object)burntime)).add((Object)stack);
                } else {
                    NNList list = new NNList();
                    list.add((Object)stack);
                    this.val$recipeInputs.put((Object)burntime, (Object)list);
                }
            }
        });
        ArrayList<StirlingRecipeWrapper> recipeList = new ArrayList<StirlingRecipeWrapper>();
        TreeSet recipeOrder = new TreeSet(recipeInputs.keySet());
        Iterator it = recipeOrder.descendingIterator();
        while (it.hasNext()) {
            recipeList.add(new StirlingRecipeWrapper((NNList)recipeInputs.get(it.next()), guiHelper));
        }
        registry.addRecipes(recipeList, UID);
        long end = System.nanoTime();
        Log.info(String.format("StirlingRecipeCategory: Added %d stirling generator recipes for %d solid fuels to JEI in %.3f seconds.", recipeList.size(), FuelCache.getFuels().size(), (double)(end - start) / 1.0E9));
    }

    public StirlingRecipeCategory(@Nonnull IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("stirling_generator");
        this.background = guiHelper.createDrawable(backgroundLocation, xOff, yOff, xSize, 70);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 176, 0, 13, 13);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_stirling_generator.getBlock().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.flame.draw(minecraft, 81 - xOff, 53 - yOff);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull StirlingRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiItemStacks.init(0, true, 79 - xOff, 33 - yOff);
        group.init(1, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 37 - xOff, 21 - yOff, 40, 10, 0, 0);
        group.init(2, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 101 - xOff, 21 - yOff, 40, 10, 0, 0);
        group.init(3, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 30 - xOff, 67 - yOff, 52, 10, 0, 0);
        group.init(4, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 98 - xOff, 67 - yOff, 60, 10, 0, 0);
        guiItemStacks.set(ingredients);
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class StirlingRecipeWrapper
    extends BlankRecipeWrapper {
        @Nonnull
        private final NNList<ItemStack> solidFuel;
        private IDrawable stirlingFront;

        private StirlingRecipeWrapper(@Nonnull NNList<ItemStack> solidFuel, @Nonnull IGuiHelper guiHelper) {
            this.solidFuel = solidFuel;
            if (!this.simpleFuel((ItemStack)solidFuel.get(0))) {
                ResourceLocation stirlingFrontLocation = new ResourceLocation("enderio", "textures/blocks/block_stirling_gen_simple_front_off.png");
                this.stirlingFront = guiHelper.createDrawable(stirlingFrontLocation, 0, 0, 16, 16, 16, 16);
            }
        }

        private boolean simpleFuel(@Nonnull ItemStack fuel) {
            return Prep.isInvalid(fuel.func_77973_b().getContainerItem(fuel));
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            NNList list = new NNList();
            list.add(this.solidFuel);
            ingredients.setInputLists(ItemStack.class, (List)list);
            CapacitorKey minKey = this.simpleFuel((ItemStack)this.solidFuel.get(0)) ? CapacitorKey.SIMPLE_STIRLING_POWER_GEN : CapacitorKey.STIRLING_POWER_GEN;
            double minEnergyProducedPerTick = minKey.getFloat(DefaultCapacitorData.BASIC_CAPACITOR);
            double maxEnergyProducedPerTick = CapacitorKey.STIRLING_POWER_GEN.getFloat(DefaultCapacitorData.ENDER_CAPACITOR);
            double minEnergyProduced = minEnergyProducedPerTick * (double)TileStirlingGenerator.getBurnTime((ItemStack)this.solidFuel.get(0), minKey, DefaultCapacitorData.BASIC_CAPACITOR);
            double maxEnergyProduced = maxEnergyProducedPerTick * (double)TileStirlingGenerator.getBurnTime((ItemStack)this.solidFuel.get(0), CapacitorKey.STIRLING_POWER_GEN, DefaultCapacitorData.ENDER_CAPACITOR);
            ingredients.setOutputs(EnergyIngredient.class, (List)new NNList((Object[])new EnergyIngredient[]{new EnergyIngredient((int)Math.round(minEnergyProducedPerTick), true), new EnergyIngredient((int)Math.round(maxEnergyProducedPerTick), true), new EnergyIngredient((int)Math.round(minEnergyProduced), false), new EnergyIngredient((int)Math.round(maxEnergyProduced), false)}));
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer fr = minecraft.field_71466_p;
            String txt = Lang.GUI_STIRGEN_OUTPUT.get("");
            int sw = fr.func_78256_a(txt);
            fr.func_175063_a(txt, (float)(89 - sw / 2 - xOff), (float)(10 - yOff), ColorUtil.getRGB((Color)Color.WHITE));
            txt = "-";
            sw = fr.func_78256_a(txt);
            fr.func_175063_a(txt, (float)(89 - sw / 2 - xOff), (float)(22 - yOff), ColorUtil.getRGB((Color)Color.WHITE));
            fr.func_175063_a(txt, (float)(89 - sw / 2 - xOff), (float)(68 - yOff), ColorUtil.getRGB((Color)Color.WHITE));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.stirlingFront != null) {
                this.stirlingFront.draw(minecraft, 129 - xOff, 40 - yOff);
                IconEIO.map.render((IWidgetIcon)IconEIO.GENERIC_VERBOTEN, (double)(135 - xOff), (double)(34 - yOff), true);
            }
        }

        @Nonnull
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (this.stirlingFront != null && mouseX >= 121 - xOff && mouseX <= 121 - xOff + 32 && mouseY >= 32 - yOff && mouseY <= 32 - yOff + 32) {
                return Lang.JEI_STIRGEN_NOTSIMPLE.getLines(new Object[0]);
            }
            if (mouseY < 32 - yOff || mouseY >= 69 - yOff) {
                return Lang.JEI_STIRGEN_RANGE.getLines(new Object[0]);
            }
            return super.getTooltipStrings(mouseX, mouseY);
        }
    }
}

