/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.coordselector;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class TelepadTarget {
    @Nonnull
    private BlockPos location;
    private int dimension;
    @Nonnull
    private String name;
    @Nonnull
    private ItemStack icon;

    public TelepadTarget() {
        this(new BlockPos(0, -1, 0), Integer.MIN_VALUE);
    }

    public TelepadTarget(@Nonnull BlockPos location, int dimension) {
        this(location, dimension, "", Prep.getEmpty());
    }

    public TelepadTarget(@Nonnull BlockPos location, int dimension, @Nonnull String name, @Nonnull ItemStack icon) {
        this.location = location;
        this.dimension = dimension;
        this.name = name;
        this.icon = icon;
    }

    public TelepadTarget(@Nonnull TelepadTarget newTarget) {
        this(newTarget.location, newTarget.dimension, newTarget.name, newTarget.icon);
    }

    @Nonnull
    public BlockPos getLocation() {
        return this.location;
    }

    public int getDimension() {
        return this.dimension;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(@Nonnull ItemStack icon) {
        this.icon = icon;
    }

    public int getX() {
        return this.location.func_177958_n();
    }

    public TelepadTarget setX(int x) {
        this.location = new BlockPos(x, this.getY(), this.getZ());
        return this;
    }

    public int getY() {
        return this.location.func_177956_o();
    }

    public TelepadTarget setY(int y) {
        this.location = new BlockPos(this.getX(), y, this.getZ());
        return this;
    }

    public int getZ() {
        return this.location.func_177952_p();
    }

    public TelepadTarget setZ(int z) {
        this.location = new BlockPos(this.getX(), this.getY(), z);
        return this;
    }

    public TelepadTarget setLocation(@Nonnull BlockPos pos) {
        this.location = pos;
        return this;
    }

    public TelepadTarget setDimension(int dimension) {
        this.dimension = dimension;
        return this;
    }

    @Nonnull
    public String getChatString() {
        String res = "";
        if (!this.name.isEmpty()) {
            res = res + this.name + " ";
        }
        res = res + BlockCoord.chatString((BlockPos)this.location, (TextFormatting)TextFormatting.WHITE) + " ";
        res = res + TelepadTarget.getDimenionName(this.dimension);
        return res;
    }

    @Nonnull
    public String getDimenionName() {
        return TelepadTarget.getDimenionName(this.dimension);
    }

    @Nonnull
    public static String getDimenionName(int dim) {
        if (!DimensionManager.isDimensionRegistered((int)dim)) {
            return Integer.toString(dim);
        }
        DimensionType type = DimensionManager.getProviderType((int)dim);
        if (type == null) {
            return Integer.toString(dim);
        }
        String name = type.func_186065_b();
        int[] dims = DimensionManager.getDimensions((DimensionType)type);
        if (dims != null && dims.length > 1) {
            name = name + " " + dim;
        }
        return name;
    }

    public boolean isValid() {
        return this.location.func_177956_o() >= 0;
    }

    @Nonnull
    public String toString() {
        String res = "";
        if (!this.name.isEmpty()) {
            res = res + " " + this.name + " ";
        }
        res = res + this.location + " " + this.dimension;
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimension;
        result = 31 * result + this.icon.hashCode();
        result = 31 * result + this.location.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TelepadTarget other = (TelepadTarget)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (!ItemStack.func_77989_b((ItemStack)this.icon, (ItemStack)other.icon)) {
            return false;
        }
        if (!this.location.equals((Object)other.location)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public void writeToNBT(@Nonnull ItemStack stack) {
        this.writeToNBT(NbtValue.getOrCreateRoot(stack));
        if (!this.getName().isEmpty()) {
            stack.func_151001_c(this.getName());
        } else {
            stack.func_135074_t();
        }
    }

    public void writeToNBT(@Nonnull NBTTagCompound tag) {
        NbtValue.REMOTE_POS.setBlockPos(tag, this.location);
        NbtValue.REMOTE_D.setInt(tag, this.dimension);
        NbtValue.REMOTE_NAME.setString(tag, this.name);
        NbtValue.REMOTE_ICON.setStack(tag, this.icon);
    }

    @Nullable
    public static TelepadTarget readFromNBT(@Nonnull ItemStack stack) {
        return TelepadTarget.readFromNBT(NbtValue.getReadOnlyRoot(stack));
    }

    @Nullable
    public static TelepadTarget readFromNBT(@Nonnull NBTTagCompound tag) {
        if (!NbtValue.REMOTE_POS.hasTag(tag)) {
            return null;
        }
        return new TelepadTarget(NbtValue.REMOTE_POS.getBlockPos(tag), NbtValue.REMOTE_D.getInt(tag), NbtValue.REMOTE_NAME.getString(tag, ""), NbtValue.REMOTE_ICON.getStack(tag));
    }
}

