/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.painted;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.NNEnumMap;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.block.painted.BlockItemPaintedBlock;
import crazypants.enderio.base.block.painted.BlockItemPaintedPressurePlate;
import crazypants.enderio.base.block.painted.EnumPressurePlateType;
import crazypants.enderio.base.block.painted.TilePaintedPressurePlate;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.glass.BlockFusedQuartzBase;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.paint.render.PaintRegistry;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.PressurePlatePainterTemplate;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.ICacheKey;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumRenderPart;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.base.render.util.QuadCollector;
import crazypants.enderio.util.CapturedMob;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockPressurePlateWeighted;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPaintedPressurePlate
extends BlockBasePressurePlate
implements ITileEntityProvider,
IPaintable.ITexturePaintableBlock,
ISmartRenderAwareBlock,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
BlockItemPaintedBlock.INamedSubBlocks,
IResourceTooltipProvider,
IRenderMapper.IItemRenderMapper.IItemModelMapper,
IModObject.WithBlockItem,
ICustomSubItems {
    @Nonnull
    private static final String MODEL_UP = "pressure_plate_up";
    @Nonnull
    private static final String MODEL_DOWN = "pressure_plate_down";
    @Nonnull
    private final NNEnumMap<EnumPressurePlateType, IBlockState> defaultPaints = new NNEnumMap(EnumPressurePlateType.class, (Object)Blocks.field_150350_a.func_176223_P());

    public static BlockPaintedPressurePlate create(@Nonnull IModObject modObject) {
        BlockPaintedPressurePlate result = new BlockPaintedPressurePlate(modObject);
        result.init(modObject);
        MachineRecipeRegistry.instance.registerRecipe("painter", new PressurePlatePainterTemplate(result, EnumPressurePlateType.WOOD.getMetaFromType(), Blocks.field_150452_aw));
        MachineRecipeRegistry.instance.registerRecipe("painter", new PressurePlatePainterTemplate(result, EnumPressurePlateType.STONE.getMetaFromType(), Blocks.field_150456_au));
        MachineRecipeRegistry.instance.registerRecipe("painter", new PressurePlatePainterTemplate(result, EnumPressurePlateType.IRON.getMetaFromType(), Blocks.field_150443_bT));
        MachineRecipeRegistry.instance.registerRecipe("painter", new PressurePlatePainterTemplate(result, EnumPressurePlateType.GOLD.getMetaFromType(), Blocks.field_150445_bS));
        return result;
    }

    public BlockPaintedPressurePlate(@Nonnull IModObject modObject) {
        super(Material.field_151573_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(EnderIOTab.tabEnderIO);
        modObject.apply(this);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(0.5f);
    }

    private void init(@Nonnull IModObject modObject) {
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel(MODEL_UP, new ResourceLocation("minecraft:block/stone_pressure_plate_up"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel(MODEL_DOWN, new ResourceLocation("minecraft:block/stone_pressure_plate_down"), PaintRegistry.PaintMode.ALL_TEXTURES);
        this.defaultPaints.put((Enum)EnumPressurePlateType.WOOD, (Object)Blocks.field_150452_aw.func_176223_P());
        this.defaultPaints.put((Enum)EnumPressurePlateType.STONE, (Object)Blocks.field_150456_au.func_176223_P());
        this.defaultPaints.put((Enum)EnumPressurePlateType.IRON, (Object)Blocks.field_150443_bT.func_176223_P());
        this.defaultPaints.put((Enum)EnumPressurePlateType.GOLD, (Object)Blocks.field_150445_bS.func_176223_P());
        this.defaultPaints.put((Enum)EnumPressurePlateType.DARKSTEEL, (Object)this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(1)));
        this.defaultPaints.put((Enum)EnumPressurePlateType.SOULARIUM, (Object)this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(2)));
        this.defaultPaints.put((Enum)EnumPressurePlateType.TUNED, (Object)this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(3)));
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemPaintedPressurePlate(this));
    }

    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TilePaintedPressurePlate();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockPressurePlateWeighted.field_176579_a});
    }

    protected int func_180669_e(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            EnumPressurePlateType type = ((TilePaintedPressurePlate)te).getType();
            return type.getCountingMode().count(worldIn.func_175647_a(type.getSearchClass(), field_185511_c.func_186670_a(pos), type.getPredicate(this.getMobType((IBlockAccess)worldIn, pos))));
        }
        return this.func_176576_e(worldIn.func_180495_p(pos));
    }

    protected int func_176576_e(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a);
    }

    @Nonnull
    protected IBlockState func_176575_a(@Nonnull IBlockState state, int strength) {
        return state.func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(strength));
    }

    protected void setTypeFromMeta(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, int meta) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TilePaintedPressurePlate) {
            ((TilePaintedPressurePlate)te).setType(EnumPressurePlateType.getTypeFromMeta(meta));
            ((TilePaintedPressurePlate)te).setSilent(EnumPressurePlateType.getSilentFromMeta(meta));
        }
    }

    protected int getMetaForStack(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return EnumPressurePlateType.getMetaFromType(((TilePaintedPressurePlate)te).getType(), ((TilePaintedPressurePlate)te).isSilent());
        }
        return 0;
    }

    protected EnumPressurePlateType getType(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).getType();
        }
        return EnumPressurePlateType.WOOD;
    }

    protected boolean isSilent(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).isSilent();
        }
        return false;
    }

    protected CapturedMob getMobType(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).getMobType();
        }
        return null;
    }

    protected void setMobType(IBlockAccess worldIn, @Nonnull BlockPos pos, CapturedMob mobType) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TilePaintedPressurePlate) {
            ((TilePaintedPressurePlate)te).setMobType(mobType);
        }
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public void func_180633_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        this.setTypeFromMeta((IBlockAccess)worldIn, pos, stack.func_77960_j());
        this.setPaintSource(state, (IBlockAccess)worldIn, pos, PaintUtil.getSourceBlock(stack));
        this.setRotation((IBlockAccess)worldIn, pos, EnumFacing.func_176733_a((double)placer.field_70177_z));
        this.setMobType((IBlockAccess)worldIn, pos, CapturedMob.create(stack));
        if (!worldIn.field_72995_K) {
            worldIn.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean rotateBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        this.setRotation((IBlockAccess)world, pos, this.getRotation((IBlockAccess)world, pos).func_176732_a(EnumFacing.Axis.Y));
        return true;
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World worldIn, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack item) {
        super.func_180657_a(worldIn, player, pos, state, te, item);
        super.removedByPlayer(state, worldIn, pos, player, true);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        drops.add((Object)this.getDrop(world, pos));
    }

    @Nonnull
    protected ItemStack getDrop(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        CapturedMob mobType = this.getMobType(world, pos);
        ItemStack drop = mobType != null ? mobType.toStack((Block)this, this.getMetaForStack(world, pos), 1) : new ItemStack((Block)this, 1, this.getMetaForStack(world, pos));
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            PaintUtil.setSourceBlock(drop, ((IPaintable.IPaintableTileEntity)te).getPaintSource());
        }
        return drop;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return this.getDrop((IBlockAccess)world, pos);
    }

    @Override
    public void setPaintSource(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            if (this.defaultPaints.get((Object)this.getType(world, pos)) == paintSource) {
                ((IPaintable.IPaintableTileEntity)te).setPaintSource(null);
            } else {
                ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
            }
        }
    }

    @Override
    public void setPaintSource(@Nonnull Block block, @Nonnull ItemStack stack, @Nullable IBlockState paintSource) {
        if (this.defaultPaints.get((Object)EnumPressurePlateType.getTypeFromMeta(stack.func_77960_j())) == paintSource) {
            PaintUtil.setSourceBlock(stack, null);
        } else {
            PaintUtil.setSourceBlock(stack, paintSource);
        }
    }

    @Override
    @Nonnull
    public IBlockState getPaintSource(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IBlockState paintSource;
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof IPaintable.IPaintableTileEntity && (paintSource = ((IPaintable.IPaintableTileEntity)te).getPaintSource()) != null) {
            return paintSource;
        }
        return (IBlockState)this.defaultPaints.get((Object)this.getType(world, pos));
    }

    @Override
    @Nonnull
    public IBlockState getPaintSource(@Nonnull Block block, @Nonnull ItemStack stack) {
        IBlockState paintSource = PaintUtil.getSourceBlock(stack);
        return paintSource != null ? paintSource : (IBlockState)this.defaultPaints.get((Object)EnumPressurePlateType.getTypeFromMeta(stack.func_77960_j()));
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, this);
        blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(this.getRotation(world, pos)).addCacheKey((Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a) > 0);
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private IBakedModel mapRender(IBlockState state, @Nullable IBlockState paint, EnumFacing facing) {
        ModelRotation rot;
        switch (facing) {
            case EAST: {
                rot = ModelRotation.X0_Y90;
                break;
            }
            case NORTH: {
                rot = null;
                break;
            }
            case SOUTH: {
                rot = ModelRotation.X0_Y180;
                break;
            }
            case WEST: {
                rot = ModelRotation.X0_Y270;
                break;
            }
            default: {
                return null;
            }
        }
        if ((Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a) > 0) {
            return PaintRegistry.getModel(IBakedModel.class, MODEL_DOWN, paint, (IModelState)rot);
        }
        return PaintRegistry.getModel(IBakedModel.class, MODEL_UP, paint, (IModelState)rot);
    }

    protected EnumFacing getRotation(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).getRotation();
        }
        return EnumFacing.NORTH;
    }

    protected void setRotation(IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing rotation) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TilePaintedPressurePlate) {
            ((TilePaintedPressurePlate)te).setRotation(rotation);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(this.getPaintSource(block, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBakedModel> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack) {
        IBlockState paintSource = this.getPaintSource(block, stack);
        IBakedModel model1 = PaintRegistry.getModel(IBakedModel.class, MODEL_UP, paintSource, null);
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        list.add(model1);
        if (paintSource != this.defaultPaints.get((Object)EnumPressurePlateType.getTypeFromMeta(stack.func_77960_j()))) {
            IBlockState stdOverlay = ModObject.block_machine_base.getBlockNN().func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY));
            IBakedModel model2 = PaintRegistry.getModel(IBakedModel.class, MODEL_UP, stdOverlay, PaintRegistry.OVERLAY_TRANSFORMATION);
            list.add(model2);
        }
        return list;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    public int getFlammability(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.getType(world, pos).getFlammability();
    }

    public int getFireSpreadSpeed(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.getType(world, pos).getFireSpreadSpeed();
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        for (EnumPressurePlateType type : EnumPressurePlateType.values()) {
            if (!type.isShadowsVanilla()) {
                list.add((Object)new ItemStack((Block)this, 1, EnumPressurePlateType.getMetaFromType(type, false)));
            }
            list.add((Object)new ItemStack((Block)this, 1, EnumPressurePlateType.getMetaFromType(type, true)));
        }
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getSubItems() {
        NNList list = new NNList();
        for (EnumPressurePlateType type : EnumPressurePlateType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, EnumPressurePlateType.getMetaFromType(type, false)));
            list.add((Object)new ItemStack((Block)this, 1, EnumPressurePlateType.getMetaFromType(type, true)));
        }
        return list;
    }

    @Override
    @Nonnull
    public String getUnlocalizedName(int meta) {
        return this.func_149739_a() + "." + EnumPressurePlateType.getTypeFromMeta(meta).func_176610_l() + (EnumPressurePlateType.getSilentFromMeta(meta) ? ".silent" : "");
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.getUnlocalizedName(itemStack.func_77960_j());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable BlockRenderLayer blockLayer, @Nonnull QuadCollector quadCollector) {
        IBlockState paintSource = this.getPaintSource(state, world, pos);
        if (PaintUtil.canRenderInLayer(paintSource, blockLayer) && !this.isInvisible(paintSource)) {
            quadCollector.addFriendlybakedModel(blockLayer, this.mapRender(state, paintSource, this.getRotation(world, pos)), paintSource, MathHelper.func_180186_a((Vec3i)pos));
        }
        return null;
    }

    public boolean isInvisible(@Nonnull IBlockState paintSource) {
        return paintSource.func_177230_c() instanceof BlockFusedQuartzBase;
    }

    protected void func_185507_b(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        if (!this.isSilent((IBlockAccess)worldIn, pos)) {
            this.getType((IBlockAccess)worldIn, pos).playClickOnSound(worldIn, pos);
        }
    }

    protected void func_185508_c(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        if (!this.isSilent((IBlockAccess)worldIn, pos)) {
            this.getType((IBlockAccess)worldIn, pos).playClickOffSound(worldIn, pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

