/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.button.IButtonBehaviour;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.misc.collect.TypedKeyMap;
import buildcraft.silicon.container.ContainerGate;
import buildcraft.silicon.gate.GateLogic;
import net.minecraft.util.ResourceLocation;

public class GuiGate
extends GuiBC8<ContainerGate> {
    public static final ResourceLocation GUI_DEFINITION = new ResourceLocation("buildcraftsilicon:gui/gate.json");

    public GuiGate(ContainerGate container) {
        super((ContainerBC_Neptune)container, GUI_DEFINITION);
        BuildCraftJsonGui jsonGui = (BuildCraftJsonGui)this.mainGui;
        this.preLoad(jsonGui);
        jsonGui.load();
        this.field_146999_f = jsonGui.getSizeX();
        this.field_147000_g = jsonGui.getSizeY();
    }

    protected void preLoad(BuildCraftJsonGui json) {
        GateLogic gate = ((ContainerGate)this.container).gate;
        TypedKeyMap properties = json.properties;
        FunctionContext context = json.context;
        properties.put((Object)"statement.container", (Object)gate);
        context.putConstantBoolean("gate.two_columns", gate.isSplitInTwo());
        context.putConstantLong("gate.slots", (long)gate.variant.numSlots);
        context.putConstantLong("gate.triggers.args", (long)gate.variant.numTriggerArgs);
        context.putConstantLong("gate.actions.args", (long)gate.variant.numActionArgs);
        context.put_b("gate.two_columns", () -> gate.isOn);
        context.putConstant("gate.material", String.class, (Object)gate.variant.material.tag);
        context.putConstant("gate.modifier", String.class, (Object)gate.variant.modifier.tag);
        context.putConstant("gate.logic", String.class, (Object)gate.variant.logic.tag);
        context.putConstant("gate.variant", String.class, (Object)gate.variant.getLocalizedName());
        properties.put((Object)"gate.triggers.possible", ((ContainerGate)this.container).possibleTriggersContext);
        properties.put((Object)"gate.actions.possible", ((ContainerGate)this.container).possibleActionsContext);
        context.put_l_b("gate.is_connected", i -> {
            if (i < 0L || i >= (long)gate.connections.length) {
                return false;
            }
            return gate.connections[(int)i];
        }).setNeverInline();
        context.put_l_b("gate.trigger.is_on", i -> {
            if (i < 0L || i >= (long)gate.triggerOn.length) {
                return false;
            }
            return gate.triggerOn[(int)i];
        }).setNeverInline();
        context.put_l_b("gate.set.is_on", i -> {
            if (i < 0L || i >= (long)gate.triggerOn.length) {
                return false;
            }
            return gate.actionOn[(int)i];
        }).setNeverInline();
        context.put_l_b("gate.action.is_on", i -> {
            if (i < 0L || i >= (long)gate.actionOn.length) {
                return false;
            }
            return gate.actionOn[(int)i] && gate.statements[(int)i].action.get() != null;
        }).setNeverInline();
        int s = 0;
        while (s < gate.variant.numSlots) {
            int i2 = s++;
            String tName = "gate.trigger/" + i2;
            String aName = "gate.action/" + i2;
            properties.put((Object)tName, gate.statements[i2].trigger);
            properties.put((Object)aName, gate.statements[i2].action);
            properties.put((Object)tName, ((ContainerGate)this.container).possibleTriggersContext);
            properties.put((Object)aName, ((ContainerGate)this.container).possibleActionsContext);
        }
        for (int c = 0; c < gate.connections.length; ++c) {
            int connection = c;
            String name = "gate.connection/" + c;
            properties.put((Object)name, (Object)gate.connections[c]);
            properties.put((Object)name, (Object)IButtonBehaviour.TOGGLE);
            properties.put((Object)name, (b, k) -> ((ContainerGate)this.container).setConnected(connection, b.isButtonActive()));
        }
    }
}

