/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression;

import buildcraft.lib.expression.Argument;
import buildcraft.lib.expression.ExpressionDebugManager;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.NodeStack;
import buildcraft.lib.expression.Tokenizer;
import buildcraft.lib.expression.TokenizerDefaults;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.cast.NodeCastLongToDouble;
import buildcraft.lib.expression.node.cast.NodeCasting;
import buildcraft.lib.expression.node.condition.NodeConditionalBoolean;
import buildcraft.lib.expression.node.condition.NodeConditionalDouble;
import buildcraft.lib.expression.node.condition.NodeConditionalLong;
import buildcraft.lib.expression.node.condition.NodeConditionalObject;
import buildcraft.lib.expression.node.func.NodeFuncGenericToBoolean;
import buildcraft.lib.expression.node.func.NodeFuncGenericToDouble;
import buildcraft.lib.expression.node.func.NodeFuncGenericToLong;
import buildcraft.lib.expression.node.func.NodeFuncGenericToObject;
import buildcraft.lib.expression.node.func.NodeFuncObjectObjectToBoolean;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class InternalCompiler {
    private static final String UNARY_NEGATION = "\u00ac";
    private static final String FUNCTION_START = "@";
    private static final String FUNCTION_ARGS = "#";
    private static final String OPERATORS = "+-*/^%~:?& << >> >>> == <= >= && || !=\u00ac";
    private static final String leftAssociative = "+-^*/%||&&==!=<=>=<<>>?&";
    private static final String rightAssociative = "";
    private static final String[] precedence = new String[]{"(),", "?", "&& ||", "!= == <= >=", "<< >>", "+-", "%", "*/", "^", "~\u00ac"};
    private static final String OPERATORS_SINGLE = "!~\u00ac";
    private static final String LONG_REGEX = "[-+]?(0x[0-9a-fA-F_]+|[0-9]+)";
    private static final String DOUBLE_REGEX = "[-+]?[0-9]+(\\.[0-9]+)?";
    private static final String BOOLEAN_REGEX = "true|false";
    private static final String STRING_REGEX = "'.*'";
    private static final Pattern LONG_MATCHER = Pattern.compile("[-+]?(0x[0-9a-fA-F_]+|[0-9]+)");
    private static final Pattern DOUBLE_MATCHER = Pattern.compile("[-+]?[0-9]+(\\.[0-9]+)?");
    private static final Pattern BOOLEAN_MATCHER = Pattern.compile("true|false");
    private static final Pattern STRING_MATCHER = Pattern.compile("'.*'");

    public static IExpressionNode compileExpression(String expression, FunctionContext context) throws InvalidExpressionException {
        if (context == null) {
            context = new FunctionContext("default");
        }
        try {
            ExpressionDebugManager.debugPrintln("Compiling " + expression);
            String[] infix = InternalCompiler.tokenize(expression, context);
            Object[] postfix = InternalCompiler.convertToPostfix(infix);
            ExpressionDebugManager.debugPrintln(Arrays.toString(postfix));
            return InternalCompiler.makeExpression((String[])postfix, context);
        }
        catch (InvalidExpressionException iee) {
            throw new InvalidExpressionException("Failed to compile expression " + expression, iee);
        }
    }

    public static INodeFunc compileFunction(String expression, FunctionContext context, Argument ... args) throws InvalidExpressionException {
        FunctionContext ctxReal = new FunctionContext(context);
        IVariableNode[] nodes = new IVariableNode[args.length];
        Class[] types = new Class[args.length];
        for (int i = 0; i < nodes.length; ++i) {
            types[i] = args[i].type;
            nodes[i] = ctxReal.putVariable(args[i].name, args[i].type);
        }
        IExpressionNode node = InternalCompiler.compileExpression(expression, ctxReal);
        if (node instanceof IExpressionNode.INodeLong) {
            return new NodeFuncGenericToLong((IExpressionNode.INodeLong)node, types, nodes);
        }
        if (node instanceof IExpressionNode.INodeDouble) {
            return new NodeFuncGenericToDouble((IExpressionNode.INodeDouble)node, types, nodes);
        }
        if (node instanceof IExpressionNode.INodeBoolean) {
            return new NodeFuncGenericToBoolean((IExpressionNode.INodeBoolean)node, types, nodes);
        }
        if (node instanceof IExpressionNode.INodeObject) {
            return new NodeFuncGenericToObject((IExpressionNode.INodeObject)node, types, nodes);
        }
        ExpressionDebugManager.debugNodeClass(node.getClass());
        throw new IllegalStateException("Unknown node " + node.getClass());
    }

    private static String[] tokenize(String function, FunctionContext context) throws InvalidExpressionException {
        Object[] tokens = TokenizerDefaults.createTokenizer().tokenize(function);
        ArrayList<Object> actual = new ArrayList<Object>();
        boolean changed = false;
        ExpressionDebugManager.debugPrintln("Incoming = " + Arrays.toString(tokens));
        for (int i = 0; i < tokens.length; ++i) {
            Object token;
            block8: {
                String before = rightAssociative;
                token = tokens[i];
                int start = i;
                do {
                    int index;
                    String whole;
                    token = tokens[i];
                    ExpressionDebugManager.debugPrintln("  + " + (String)token);
                    Tokenizer.ITokenizingContext ctx = Tokenizer.ITokenizingContext.createFromString((String)token);
                    Tokenizer.TokenResult result = TokenizerDefaults.GOBBLER_WORD.tokenizePart(ctx);
                    if (!(result instanceof Tokenizer.ResultConsume)) {
                        i = start;
                        token = tokens[start];
                        ExpressionDebugManager.debugPrintln("  - not a word!");
                        break block8;
                    }
                    if (((Tokenizer.ResultConsume)result).length != ((String)token).length()) {
                        i = start;
                        token = tokens[start];
                        ExpressionDebugManager.debugPrintln("  - different length!");
                        break block8;
                    }
                    String lookup = whole = before + (String)token;
                    if (whole.startsWith(".")) {
                        lookup = whole.substring(1);
                    }
                    if ((index = lookup.indexOf(46)) != -1) {
                        String type = lookup.substring(0, index);
                        String after = lookup.substring(index + 1);
                        FunctionContext ctx2 = NodeTypes.getContext(NodeTypes.getType(type));
                        if (!(ctx2 == null || ctx2.getVariable(after) == null && ctx2.getFunctions(after).isEmpty())) {
                            token = whole;
                            break block8;
                        }
                    }
                    if (context.getVariable(lookup) != null || !context.getFunctions(lookup).isEmpty()) {
                        token = whole;
                        break block8;
                    }
                    before = before + (String)token;
                    changed = true;
                } while (++i < tokens.length);
                token = before;
                ExpressionDebugManager.debugPrintln("  - too long!");
            }
            ExpressionDebugManager.debugPrintln("  -> " + (String)token);
            actual.add(token);
        }
        return changed ? actual.toArray(new String[0]) : tokens;
    }

    private static int getPrecedence(String token) {
        int p = 0;
        if (token.startsWith(FUNCTION_START)) {
            return 0;
        }
        for (String pre : precedence) {
            if (pre.contains(token)) {
                return p;
            }
            ++p;
        }
        return p;
    }

    private static String[] convertToPostfix(String[] infix) throws InvalidExpressionException {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        ArrayList<String> postfix = new ArrayList<String>();
        int index = 0;
        ExpressionDebugManager.debugPrintln("Converting " + Arrays.toString(infix));
        ExpressionDebugManager.debugPrintln("         Stack=" + stack + ", postfix=" + postfix);
        boolean justPushedFunc = false;
        for (index = 0; index < infix.length; ++index) {
            boolean found;
            String token = infix[index];
            ExpressionDebugManager.debugPrintln("  - Token \"" + token + "\"");
            if (justPushedFunc && !")".equals(token) && stack.peek() != null && ((String)stack.peek()).startsWith(FUNCTION_START)) {
                stack.push(",");
            }
            justPushedFunc = false;
            if (",".equals(token)) {
                int commas = 1;
                found = false;
                while (!stack.isEmpty()) {
                    String fromStack = (String)stack.pop();
                    if ("(".equals(fromStack) || fromStack.startsWith(FUNCTION_START)) {
                        found = true;
                        stack.push(fromStack);
                        break;
                    }
                    if (",".equals(fromStack)) {
                        ++commas;
                        continue;
                    }
                    postfix.add(fromStack);
                }
                for (int i = 0; i < commas; ++i) {
                    stack.push(",");
                }
                if (!found) {
                    throw new InvalidExpressionException("Did not find an opening parenthesis for the comma!");
                }
            } else if ("(".equals(token)) {
                stack.push(token);
            } else if (")".equals(token)) {
                int commas = 0;
                found = false;
                while (!stack.isEmpty()) {
                    String fromStack = (String)stack.pop();
                    if ("(".equals(fromStack)) {
                        found = true;
                        break;
                    }
                    if (fromStack.startsWith(FUNCTION_START)) {
                        found = true;
                        fromStack = fromStack + FUNCTION_ARGS + commas;
                        postfix.add(fromStack);
                        break;
                    }
                    if (",".equals(fromStack)) {
                        ++commas;
                        continue;
                    }
                    postfix.add(fromStack);
                }
                if (!found) {
                    throw new InvalidExpressionException("Too many closing parenthesis!");
                }
            } else if (":".equals(token)) {
                String s;
                while ((s = (String)stack.peek()) != null && !"?".equals(s)) {
                    postfix.add((String)stack.pop());
                }
            } else if (OPERATORS.contains(token)) {
                String s;
                if ("-".equals(token) && (index == 0 || "+-*/^%~:?& << >> >>> == <= >= && || !=\u00ac(,".contains(infix[index - 1]))) {
                    token = UNARY_NEGATION;
                }
                while ((s = (String)stack.peek()) != null) {
                    boolean shouldContinue;
                    boolean continueIfEqual;
                    int tokenPrec = InternalCompiler.getPrecedence(token);
                    int stackPrec = InternalCompiler.getPrecedence(s);
                    boolean bl = continueIfEqual = !"?".contains(token);
                    boolean bl2 = leftAssociative.contains(token) && (continueIfEqual ? tokenPrec <= stackPrec : tokenPrec < stackPrec) ? true : (shouldContinue = false);
                    if (!shouldContinue && rightAssociative.contains(token) && tokenPrec > stackPrec) {
                        shouldContinue = true;
                    }
                    if (!shouldContinue) break;
                    postfix.add((String)stack.pop());
                }
                stack.push(token);
            } else if (index + 1 < infix.length && "(".equals(infix[index + 1])) {
                justPushedFunc = true;
                stack.push(FUNCTION_START + token);
                ++index;
            } else {
                postfix.add(token);
            }
            ExpressionDebugManager.debugPrintln("         Stack=" + stack + ", postfix=" + postfix);
        }
        while (!stack.isEmpty()) {
            String operator = (String)stack.pop();
            ExpressionDebugManager.debugPrintln("  - Operator \"" + operator + "\"");
            if ("(".equals(operator)) {
                throw new InvalidExpressionException("Too many opening parenthesis!");
            }
            if (")".equals(operator)) {
                throw new InvalidExpressionException("Too many closing parenthesis!");
            }
            postfix.add(operator);
            ExpressionDebugManager.debugPrintln("         Stack=" + stack + ", postfix=" + postfix);
        }
        return postfix.toArray(new String[postfix.size()]);
    }

    private static IExpressionNode makeExpression(String[] postfix, FunctionContext context) throws InvalidExpressionException {
        NodeStack stack = new NodeStack();
        for (int i = 0; i < postfix.length; ++i) {
            int index;
            String type;
            FunctionContext ctx;
            IExpressionNode node;
            String op = postfix[i];
            if (OPERATORS.contains(op) && !"?".equals(op) && !":".equals(op)) {
                boolean isNegation = UNARY_NEGATION.equals(op);
                int count = 2;
                if (isNegation || OPERATORS_SINGLE.contains(op)) {
                    op = isNegation ? "-" : op;
                    count = 1;
                }
                String function = op + FUNCTION_ARGS + count;
                InternalCompiler.pushFunctionNode(stack, function, context);
                continue;
            }
            if (":".equals(op)) continue;
            if ("?".equals(op)) {
                InternalCompiler.pushConditional(stack);
                continue;
            }
            if (InternalCompiler.isValidLong(op)) {
                long val = InternalCompiler.parseValidLong(op);
                stack.push(new NodeConstantLong(val));
                continue;
            }
            if (InternalCompiler.isValidDouble(op)) {
                stack.push(new NodeConstantDouble(Double.parseDouble(op)));
                continue;
            }
            if (BOOLEAN_MATCHER.matcher(op).matches()) {
                stack.push(NodeConstantBoolean.of(Boolean.parseBoolean(op)));
                continue;
            }
            if (STRING_MATCHER.matcher(op).matches()) {
                stack.push(new NodeConstantObject<String>(String.class, op.substring(1, op.length() - 1)));
                continue;
            }
            if (op.startsWith(FUNCTION_START)) {
                String function = op.substring(1);
                InternalCompiler.pushFunctionNode(stack, function, context);
                continue;
            }
            IExpressionNode iExpressionNode = node = context == null ? null : context.getVariable(op);
            if (node == null && op.contains(".") && (ctx = InternalCompiler.getContext(type = op.substring(0, index = op.indexOf(46)))) != null && (node = ctx.getVariable(op)) == null) {
                node = ctx.getVariable(op.substring(index + 1));
            }
            if (node != null) {
                stack.push(node);
                continue;
            }
            String vars = InternalCompiler.getValidVariablesErrorString(context);
            throw new InvalidExpressionException("Unknown variable '" + op + "'" + vars);
        }
        IExpressionNode node = stack.pop().inline();
        if (!stack.isEmpty()) {
            throw new InvalidExpressionException("Tried to make an expression with too many nodes! (" + stack + ")");
        }
        return node;
    }

    private static String getValidVariablesErrorString(FunctionContext context) {
        if (context == null) {
            return " (No context to get variables from)";
        }
        String vars = "\nList of valid variables:";
        vars = vars + InternalCompiler.addParentVariables(context);
        return vars + "\n";
    }

    private static String addParentVariables(FunctionContext context) {
        String vars = rightAssociative;
        ArrayList<String> allVariables = new ArrayList<String>();
        allVariables.addAll(context.getAllVariables());
        allVariables.sort(Comparator.naturalOrder());
        if (!allVariables.isEmpty()) {
            if (!context.name.isEmpty()) {
                vars = vars + "\n" + context.name + ":";
            }
            vars = vars + "\n  " + ((Object)allVariables).toString().replace("[", rightAssociative).replace("]", rightAssociative);
        }
        for (FunctionContext parent : context.getParents()) {
            vars = vars + InternalCompiler.addParentVariables(parent);
        }
        return vars;
    }

    public static boolean isValidDouble(String op) {
        return DOUBLE_MATCHER.matcher(op).matches();
    }

    public static boolean isValidLong(String value) {
        return LONG_MATCHER.matcher(value).matches();
    }

    public static long parseValidLong(String value) {
        long val;
        if (value.startsWith("0x")) {
            String v = value.substring(2).replace("_", rightAssociative);
            val = Long.parseLong(v, 16);
        } else {
            val = Long.parseLong(value);
        }
        return val;
    }

    public static IExpressionNode convertBinary(IExpressionNode convert, IExpressionNode compare) throws InvalidExpressionException {
        Class<?> compareClass;
        Class<?> convertClass = NodeTypes.getType(convert);
        if (convertClass == (compareClass = NodeTypes.getType(compare))) {
            return convert;
        }
        try {
            return NodeCasting.castToType(convert, compareClass);
        }
        catch (InvalidExpressionException iee) {
            NodeCasting.castToType(compare, convertClass);
            return convert;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void pushConditional(NodeStack stack) throws InvalidExpressionException {
        IExpressionNode right = stack.pop();
        IExpressionNode left = stack.pop();
        IExpressionNode conditional = stack.pop();
        right = InternalCompiler.convertBinary(right, left);
        left = InternalCompiler.convertBinary(left, right);
        if (!(conditional instanceof IExpressionNode.INodeBoolean)) throw new InvalidExpressionException("Required a boolean node, but got '" + conditional + "' of " + conditional.getClass());
        IExpressionNode.INodeBoolean condition = (IExpressionNode.INodeBoolean)conditional;
        if (right instanceof IExpressionNode.INodeBoolean) {
            stack.push(new NodeConditionalBoolean(condition, (IExpressionNode.INodeBoolean)left, (IExpressionNode.INodeBoolean)right));
            return;
        } else if (right instanceof IExpressionNode.INodeDouble) {
            stack.push(new NodeConditionalDouble(condition, (IExpressionNode.INodeDouble)left, (IExpressionNode.INodeDouble)right));
            return;
        } else if (right instanceof IExpressionNode.INodeObject) {
            stack.push(new NodeConditionalObject(condition, (IExpressionNode.INodeObject)left, (IExpressionNode.INodeObject)right));
            return;
        } else {
            if (!(right instanceof IExpressionNode.INodeLong)) throw new InvalidExpressionException("Unknown node " + left);
            stack.push(new NodeConditionalLong(condition, (IExpressionNode.INodeLong)left, (IExpressionNode.INodeLong)right));
        }
    }

    private static void pushFunctionNode(NodeStack stack, String function, FunctionContext context) throws InvalidExpressionException {
        NodeStack realStack;
        int index;
        String type;
        Object ctx;
        String name = function.substring(0, function.indexOf(FUNCTION_ARGS));
        String argCount = function.substring(function.indexOf(FUNCTION_ARGS) + 1);
        int count = Integer.parseInt(argCount);
        if (name.startsWith(".")) {
            name = name.substring(1);
            ++count;
        }
        List<IExpressionNode> popOrder = stack.peek(count);
        ArrayList functionOrder = new ArrayList(popOrder.size());
        HashMap functions = new HashMap();
        if (name.contains(".") && (ctx = InternalCompiler.getContext(type = name.substring(0, index = name.indexOf(46)))) != null) {
            functions.putAll(((FunctionContext)ctx).getFunctions(name.substring(index + 1)));
        }
        FunctionContext[] ctxs = new FunctionContext[count + 1];
        ctxs[0] = context;
        int n = 1;
        for (IExpressionNode node : popOrder) {
            Class<?> nodeType = NodeTypes.getType(node);
            functionOrder.add(0, nodeType);
            ctxs[n++] = NodeTypes.getContext(nodeType);
        }
        FunctionContext typeAwareContext = new FunctionContext(ctxs);
        functions.putAll(typeAwareContext.getFunctions(name));
        INodeFunc bestFunction = null;
        int bestCastCount = Integer.MAX_VALUE;
        List bestCasters = null;
        List<Class<Object>> bestClassesTo = null;
        List fnOrderNames = functionOrder.stream().map(NodeTypes::getName).collect(Collectors.toList());
        ExpressionDebugManager.debugStart("Finding best function called '" + name + "' for " + fnOrderNames);
        for (Map.Entry func : functions.entrySet()) {
            List functionClasses = (List)func.getKey();
            List fnClassNames = functionClasses.stream().map(NodeTypes::getName).collect(Collectors.toList());
            ExpressionDebugManager.debugPrintln("Found " + fnClassNames);
            if (functionClasses.size() != functionOrder.size()) continue;
            int casts = 0;
            boolean canCast = true;
            ArrayList casters = new ArrayList();
            ExpressionDebugManager.debugStart("Finding casters...");
            for (int i = 0; i < functionClasses.size(); ++i) {
                INodeFunc caster;
                Class from = (Class)functionOrder.get(i);
                Class to = (Class)functionClasses.get(i);
                ExpressionDebugManager.debugPrintln("  - " + NodeTypes.getName(from) + " -> " + NodeTypes.getName(to));
                if (from == to) {
                    casters.add(a -> a.pop(from));
                    ExpressionDebugManager.debugPrintln("    - Equal types, no cast needed.");
                    continue;
                }
                if (from == Long.TYPE && to == IExpressionNode.INodeLong.class) {
                    caster = new NodeFuncWrapper(){

                        @Override
                        public IExpressionNode getNode(INodeStack s) throws InvalidExpressionException {
                            return new NodeConstantObject<IExpressionNode.INodeLong>(IExpressionNode.INodeLong.class, s.popLong());
                        }
                    };
                } else if (from == Double.TYPE && to == IExpressionNode.INodeDouble.class) {
                    caster = new NodeFuncWrapper(){

                        @Override
                        public IExpressionNode getNode(INodeStack s) throws InvalidExpressionException {
                            return new NodeConstantObject<IExpressionNode.INodeDouble>(IExpressionNode.INodeDouble.class, s.popDouble());
                        }
                    };
                } else if (from == Long.TYPE && to == IExpressionNode.INodeDouble.class) {
                    caster = new NodeFuncWrapper(){

                        @Override
                        public IExpressionNode getNode(INodeStack s) throws InvalidExpressionException {
                            IExpressionNode.INodeLong node = s.popLong();
                            NodeCastLongToDouble nodeD = new NodeCastLongToDouble(node);
                            return new NodeConstantObject<IExpressionNode.INodeDouble>(IExpressionNode.INodeDouble.class, nodeD.inline());
                        }
                    };
                } else if (from == Boolean.TYPE && to == IExpressionNode.INodeBoolean.class) {
                    caster = new NodeFuncWrapper(){

                        @Override
                        public IExpressionNode getNode(INodeStack s) throws InvalidExpressionException {
                            return new NodeConstantObject<IExpressionNode.INodeBoolean>(IExpressionNode.INodeBoolean.class, s.popBoolean());
                        }
                    };
                } else {
                    FunctionContext castingCtx = new FunctionContext(NodeTypes.getContext(from), NodeTypes.getContext(to));
                    caster = castingCtx.getFunction("(" + NodeTypes.getName(to) + ")", Collections.singletonList(from));
                    if (caster == null) {
                        ExpressionDebugManager.debugPrintln("    - No cast found!");
                        canCast = false;
                        break;
                    }
                }
                ++casts;
                casters.add(caster);
                ExpressionDebugManager.debugPrintln("    - Caster = " + caster);
            }
            ExpressionDebugManager.debugEnd(rightAssociative);
            if (!canCast || casts >= bestCastCount) continue;
            bestCastCount = casts;
            bestFunction = (INodeFunc)func.getValue();
            bestCasters = casters;
            bestClassesTo = functionClasses;
        }
        ExpressionDebugManager.debugEnd("Best = " + bestFunction);
        if (bestFunction == null || bestCasters == null) {
            boolean isEq = "==".equals(name);
            boolean isNE = "!=".equals(name);
            if (count == 2 && isEq | isNE && functionOrder.get(0) == functionOrder.get(1)) {
                Class cls = (Class)functionOrder.get(0);
                NodeFuncObjectObjectToBoolean.IFuncObjectObjectToBoolean<Object, Object> func = isEq ? Objects::equals : (a, b) -> !Objects.equals(a, b);
                bestFunction = new NodeFuncObjectObjectToBoolean<Object, Object>(name, cls, cls, func);
                bestCastCount = 0;
                bestCasters = Collections.emptyList();
                bestClassesTo = new ArrayList(functionOrder);
                ExpressionDebugManager.debugPrintln("Using implicit object equality comparison.");
            } else {
                throw new InvalidExpressionException("No viable function called '" + name + "' found for " + fnOrderNames + InternalCompiler.getValidFunctionsErrorString(typeAwareContext));
            }
        }
        if (bestCastCount == 0) {
            realStack = stack;
        } else {
            IExpressionNode[] nodes = new IExpressionNode[count];
            for (int i = count - 1; i >= 0; --i) {
                INodeFunc caster = (INodeFunc)bestCasters.get(i);
                Class from = (Class)functionOrder.get(i);
                Class to = (Class)bestClassesTo.get(i);
                stack.setRecorder(Collections.singletonList(from), caster);
                IExpressionNode node = caster.getNode(stack);
                stack.checkAndRemoveRecorder();
                Class<?> actual = NodeTypes.getType(node);
                if (actual != to) {
                    throw new IllegalStateException("The caster " + caster + " didn't produce the correct result! (Expected " + to + ", but got " + actual + ")");
                }
                nodes[i] = node;
            }
            ExpressionDebugManager.debugPrintln("Nodes = " + nodes);
            realStack = new NodeStack(nodes);
        }
        NodeFuncObjectObjectToBoolean<Object, Object> func = bestFunction;
        bestClassesTo = new ArrayList(bestClassesTo);
        Collections.reverse(bestClassesTo);
        realStack.setRecorder(bestClassesTo, func);
        IExpressionNode node = func.getNode(realStack);
        realStack.checkAndRemoveRecorder();
        stack.push(node);
    }

    private static String getValidFunctionsErrorString(FunctionContext context) {
        if (context == null) {
            return " (No context to get functions from)";
        }
        String vars = "\nList of valid functions:";
        vars = vars + InternalCompiler.addParentFunctions(context);
        return vars + "\n";
    }

    private static String addParentFunctions(FunctionContext context) {
        String vars = rightAssociative;
        ArrayList<String> allFunctions = new ArrayList<String>();
        allFunctions.addAll(context.getAllFunctions().keySet());
        allFunctions.sort(Comparator.naturalOrder());
        if (!allFunctions.isEmpty()) {
            if (!context.name.isEmpty()) {
                vars = vars + "\n" + context.name + ":";
            }
            for (String fnName : allFunctions) {
                Map<List<Class<?>>, INodeFunc> functions = context.getFunctions(fnName);
                for (Map.Entry<List<Class<?>>, INodeFunc> entry : functions.entrySet()) {
                    String args = rightAssociative;
                    for (Class<?> arg : entry.getKey()) {
                        if (args.length() > 0) {
                            args = args + ", ";
                        }
                        args = args + NodeTypes.getName(arg);
                    }
                    INodeFunc function = entry.getValue();
                    String ret = function instanceof INodeFunc.INodeFuncBoolean ? NodeTypes.getName(Boolean.TYPE) : (function instanceof INodeFunc.INodeFuncDouble ? NodeTypes.getName(Double.TYPE) : (function instanceof INodeFunc.INodeFuncLong ? NodeTypes.getName(Long.TYPE) : NodeTypes.getName(((INodeFunc.INodeFuncObject)function).getType())));
                    vars = vars + "\n  " + fnName + "(" + args + ") -> " + ret;
                }
            }
        }
        for (FunctionContext parent : context.getParents()) {
            vars = vars + InternalCompiler.addParentFunctions(parent);
        }
        return vars;
    }

    private static FunctionContext getContext(String type) throws InvalidExpressionException {
        Class<?> clazz = NodeTypes.getType(type);
        return NodeTypes.getType(clazz);
    }

    private static abstract class NodeFuncWrapper
    implements INodeFunc {
        private NodeFuncWrapper() {
        }

        public String toString() {
            return "[Internal Type Wrapper]";
        }
    }
}

