/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.casting;

import java.util.Collection;
import java.util.List;
import org.objectweb.asm.Label;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArrayBasic;
import stanhebben.zenscript.type.ZenTypeArrayList;
import stanhebben.zenscript.type.casting.ICastingRule;
import stanhebben.zenscript.util.MethodOutput;

public class CastingRuleListArray
implements ICastingRule {
    private final ICastingRule base;
    private final ZenTypeArrayList from;
    private final ZenTypeArrayBasic to;

    public CastingRuleListArray(ICastingRule base, ZenTypeArrayList from, ZenTypeArrayBasic to) {
        this.base = base;
        this.from = from;
        this.to = to;
    }

    @Override
    public void compile(IEnvironmentMethod method) {
        MethodOutput methodOutput = method.getOutput();
        methodOutput.iConst0();
        int localCounter = methodOutput.local(Integer.TYPE);
        methodOutput.storeInt(localCounter);
        int localArray = methodOutput.local(this.to.toASMType());
        methodOutput.dup();
        methodOutput.invokeInterface(Collection.class, "size", Integer.TYPE, new Class[0]);
        methodOutput.newArray(this.to.getBaseType().toASMType());
        methodOutput.storeObject(localArray);
        Label start = new Label();
        Label end = new Label();
        methodOutput.label(start);
        methodOutput.dup();
        methodOutput.dup();
        methodOutput.invokeInterface(Collection.class, "size", Integer.TYPE, new Class[0]);
        methodOutput.loadInt(localCounter);
        methodOutput.ifICmpLE(end);
        methodOutput.loadInt(localCounter);
        methodOutput.invokeInterface(List.class, "get", Object.class, Integer.TYPE);
        if (this.base != null) {
            this.base.compile(method);
        }
        methodOutput.loadObject(localArray);
        methodOutput.swap();
        methodOutput.loadInt(localCounter);
        methodOutput.swap();
        methodOutput.arrayStore(this.to.getBaseType().toASMType());
        methodOutput.iinc(localCounter);
        methodOutput.goTo(start);
        methodOutput.label(end);
        methodOutput.loadObject(localArray);
    }

    @Override
    public ZenType getInputType() {
        return this.from;
    }

    @Override
    public ZenType getResultingType() {
        return this.to;
    }
}

