/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.tiles;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketTileInfo;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.ConnectionType;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.ISingleTick;
import cofh.thermaldynamics.multiblock.MultiBlockFormer;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class DuctUnit<T extends DuctUnit<T, G, C>, G extends MultiBlockGrid<T>, C>
implements IGridTile<T, G>,
ISingleTick {
    public final TileGrid parent;
    public final C[] tileCache = this.createTileCache();
    public final T[] ductCache = this.createDuctCache();
    final Duct duct;
    @Nullable
    protected G grid;
    protected byte nodeMask;
    protected byte inputMask;
    private boolean isValidForForming = true;

    public DuctUnit(TileGrid parent, Duct duct) {
        this.parent = parent;
        this.duct = duct;
    }

    public static String getSideArrayNonNull(Object[] array) {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < 6; ++i) {
            if (array[i] == null) continue;
            builder.append(EnumFacing.field_82609_l[i].toString().substring(0, 1));
        }
        builder.append("]");
        return builder.toString();
    }

    protected abstract C[] createTileCache();

    protected abstract T[] createDuctCache();

    public String toString() {
        return "Duct{" + this.getClass().getSimpleName() + "," + DuctUnit.getSideArrayNonNull(this.tileCache) + ",d=" + DuctUnit.getSideArrayNonNull(this.ductCache) + "}";
    }

    @Nonnull
    public abstract DuctToken<T, G, C> getToken();

    @Override
    @Nullable
    public G getGrid() {
        return this.grid;
    }

    @Override
    public void setGrid(@Nullable G newGrid) {
        this.grid = newGrid;
    }

    @Override
    public abstract G createGrid();

    @Override
    public void setInvalidForForming() {
        this.isValidForForming = false;
    }

    @Override
    public void setValidForForming() {
        this.isValidForForming = true;
    }

    @Override
    public boolean isValidForForming() {
        return this.isValidForForming;
    }

    public T getConnectedSide(int side) {
        return this.ductCache[side];
    }

    public void handleTileSideUpdate(@Nullable TileEntity tile, @Nullable IDuctHolder holder, byte side, @Nonnull ConnectionType type) {
        this.handleTileSideUpdate(tile, holder, side, type, (byte)(side ^ 1));
    }

    protected void handleTileSideUpdate(@Nullable TileEntity tile, @Nullable IDuctHolder holder, byte side, @Nonnull ConnectionType type, byte oppositeSide) {
        T adjDuct;
        this.nodeMask = (byte)(this.nodeMask & ~(1 << side));
        this.inputMask = (byte)(this.inputMask & ~(1 << side));
        this.setSideToNone(side);
        if (tile == null || !type.allowTransfer) {
            if (this.isInputTile(tile, side)) {
                this.inputMask = (byte)(this.inputMask | 1 << side);
                this.nodeMask = (byte)(this.nodeMask | 1 << side);
            }
            return;
        }
        if (holder != null && !holder.isSideBlocked(oppositeSide) && (adjDuct = holder.getDuct(this.getToken())) != null && this.canConnectToOtherDuct((DuctUnit<T, G, C>)adjDuct, side, oppositeSide) && ((DuctUnit)adjDuct).canConnectToOtherDuct(this, oppositeSide, side)) {
            this.ductCache[side] = ((DuctUnit)adjDuct).cast();
            return;
        }
        this.loadSignificantCache(tile, side);
    }

    public abstract boolean canConnectToOtherDuct(DuctUnit<T, G, C> var1, byte var2, byte var3);

    protected void setSideToNone(byte side) {
        this.ductCache[side] = null;
        this.clearCache(side);
    }

    public boolean loadSignificantCache(TileEntity tile, byte side) {
        if (tile == null) {
            this.tileCache[side] = null;
            return false;
        }
        C c = this.cacheTile(tile, side);
        if (c != null) {
            this.tileCache[side] = c;
            if (this.isNode(c)) {
                this.nodeMask = (byte)(this.nodeMask | 1 << side);
            }
            return true;
        }
        if (this.isInputTile(tile, side)) {
            this.inputMask = (byte)(this.inputMask | 1 << side);
            this.nodeMask = (byte)(this.nodeMask | 1 << side);
        }
        this.tileCache[side] = null;
        return false;
    }

    public boolean isInputTile(@Nullable TileEntity tile, byte side) {
        return false;
    }

    public boolean isInput(int side) {
        return (this.inputMask & 1 << side) != 0;
    }

    @Nullable
    public abstract C cacheTile(@Nonnull TileEntity var1, byte var2);

    public boolean isNode(C cache) {
        return true;
    }

    public void clearCache(byte side) {
        this.tileCache[side] = null;
    }

    @OverridingMethodsMustInvokeSuper
    public void onChunkUnload() {
        if (this.grid != null) {
            ((MultiBlockGrid)this.grid).removeBlock(this.cast());
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void invalidate() {
        if (this.grid != null) {
            ((MultiBlockGrid)this.grid).removeBlock(this.cast());
        }
    }

    public void updateSide(TileEntity tile, IDuctHolder holder, byte side) {
        byte nodeState = this.nodeMask;
        this.handleTileSideUpdate(tile, holder, side, this.parent.getConnectionType(side));
        if (this.grid != null && this.nodeMask != nodeState) {
            if (this.nodeMask == 0 || nodeState == 0) {
                ((MultiBlockGrid)this.grid).addBlock(this.cast());
            } else {
                ((MultiBlockGrid)this.grid).onMinorGridChange();
            }
        }
    }

    public void updateAllSides(TileEntity[] tiles, IDuctHolder[] holders) {
        byte nodeState = this.nodeMask;
        this.nodeMask = 0;
        for (byte side = 0; side < 6; side = (byte)(side + 1)) {
            this.handleTileSideUpdate(tiles[side], holders[side], side, this.parent.getConnectionType(side));
        }
        if (this.grid != null && this.nodeMask != nodeState) {
            if (this.nodeMask == 0 || nodeState == 0) {
                ((MultiBlockGrid)this.grid).addBlock(this.cast());
            } else {
                ((MultiBlockGrid)this.grid).onMinorGridChange();
            }
        }
    }

    public final T cast() {
        return (T)this;
    }

    public void formGrid() {
        if (this.grid == null) {
            MultiBlockFormer multiBlockFormer = new MultiBlockFormer();
            multiBlockFormer.formGrid(this.cast());
        }
    }

    @Override
    public World world() {
        return this.parent.func_145831_w();
    }

    @Override
    public BlockPos pos() {
        return this.parent.func_174877_v();
    }

    @Override
    public boolean isNode() {
        return this.nodeMask != 0;
    }

    @Override
    public boolean isSideConnected(byte side) {
        return this.ductCache[side] != null;
    }

    @Override
    public void onNeighborBlockChange() {
        this.parent.onNeighborBlockChange();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean tickPass(int pass) {
        return !this.parent.checkForChunkUnload();
    }

    public void readFromNBT(NBTTagCompound nbt) {
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return nbt;
    }

    @Nullable
    public NBTTagCompound saveToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt = this.writeToNBT(nbt);
        return nbt;
    }

    public byte tickInternalSideCounter(int start) {
        byte a;
        for (a = (byte)start; a < 6; a = (byte)(a + 1)) {
            if (this.tileCache[a] == null) continue;
            return a;
        }
        for (a = 0; a < start; a = (byte)(a + 1)) {
            if (this.tileCache[a] == null) continue;
            return a;
        }
        return 0;
    }

    public void onConnectionRejected(int i) {
        this.ductCache[i] = null;
        this.parent.callBlockUpdate();
    }

    @Override
    public boolean existsYet() {
        World world = this.parent.func_145831_w();
        return world != null && world.func_175667_e(this.parent.func_174877_v()) && world.func_175625_s(this.parent.func_174877_v()) == this.parent;
    }

    @Override
    public boolean isOutdated() {
        return this.parent.func_145837_r();
    }

    @Override
    public void singleTick() {
        if (this.parent.func_145837_r()) {
            return;
        }
        this.formGrid();
    }

    @Nonnull
    public BlockDuct.ConnectionType getRenderConnectionType(int side) {
        if (this.tileCache[side] != null) {
            return this.getConnectionTypeTile(this.tileCache[side], side);
        }
        if (this.ductCache[side] != null) {
            return this.getConnectionTypeDuct(this.ductCache[side], side);
        }
        if (this.isInput(side)) {
            return this.getInputConnection(side);
        }
        return BlockDuct.ConnectionType.NONE;
    }

    @Nonnull
    public BlockDuct.ConnectionType getInputConnection(int side) {
        return BlockDuct.ConnectionType.TILE_CONNECTION;
    }

    @Nonnull
    protected BlockDuct.ConnectionType getConnectionTypeTile(C cacheValue, int side) {
        return BlockDuct.ConnectionType.TILE_CONNECTION;
    }

    @Nonnull
    protected BlockDuct.ConnectionType getConnectionTypeDuct(T duct, int side) {
        return BlockDuct.ConnectionType.DUCT;
    }

    public int getLightValue() {
        return 0;
    }

    public void handleInfoPacket(PacketBase payload, boolean isServer, EntityPlayer thePlayer) {
    }

    public void writeToTilePacket(PacketBase payload) {
    }

    public void handleTilePacket(PacketBase payload) {
    }

    public void onPlaced(EntityLivingBase living, ItemStack stack) {
    }

    public void randomDisplayTick() {
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }

    public void dropAdditional(ArrayList<ItemStack> ret) {
    }

    public PacketTileInfo newPacketTileInfo() {
        PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this.parent);
        packet.addByte(0);
        packet.addByte(this.getToken().getId());
        return packet;
    }

    public ItemStack addNBTToItemStackDrop(ItemStack stack) {
        return stack;
    }

    public Duct getDuctType() {
        return this.duct;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseIcon() {
        return this.getDuctType().iconBaseTexture;
    }

    public boolean isOutput(int side) {
        return this.tileCache[side] != null;
    }

    public boolean onWrench(EntityPlayer player, int side, RayTraceResult rayTrace) {
        return false;
    }

    public boolean openGui(EntityPlayer player) {
        return false;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return null;
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return null;
    }

    public Object getConfigGuiServer(InventoryPlayer inventory) {
        return null;
    }

    public Object getConfigGuiClient(InventoryPlayer inventory) {
        return null;
    }

    public boolean shouldTrackChunk(byte i) {
        return this.isOutput(i) || this.isInput(i);
    }

    @Nonnull
    public Collection<BlockPos> getAdditionalImportantPositions() {
        return ImmutableList.of();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return false;
    }

    public <CAP> CAP getCapability(Capability<CAP> capability, EnumFacing facing) {
        return null;
    }
}

