/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.dependencies;

import com.austinv11.collectiveframework.dependencies.download.BinaryProvider;
import com.austinv11.collectiveframework.dependencies.download.FileType;
import com.austinv11.collectiveframework.dependencies.download.IDownloadProvider;
import com.austinv11.collectiveframework.dependencies.download.NoProviderFoundException;
import com.austinv11.collectiveframework.dependencies.download.PlainTextProvider;
import com.austinv11.collectiveframework.multithreading.SimpleRunnable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DependencyManager {
    private static final List<IDownloadProvider> providers = new ArrayList<IDownloadProvider>();
    private static volatile int numOfDownloaders = 0;

    public static void registerDownloadProvider(IDownloadProvider provider) {
        providers.add(provider);
    }

    public static void loadLibrary(File file) throws MalformedURLException {
        URLClassLoader loader = new URLClassLoader(new URL[]{file.toURI().toURL()}, DependencyManager.class.getClassLoader());
    }

    public static boolean downloadFile(String url, String downloadPath, FileType fileToDownload) throws NoProviderFoundException {
        IDownloadProvider provider = null;
        block0: for (IDownloadProvider p : providers) {
            for (FileType t : p.getCapabilities()) {
                if (!t.toString().equals(fileToDownload.toString())) continue;
                provider = p;
                continue block0;
            }
        }
        if (provider == null) {
            throw new NoProviderFoundException(fileToDownload);
        }
        return provider.downloadFile(url, downloadPath);
    }

    public static Future<Boolean> downloadFileAsync(String url, String downloadPath, FileType fileToDownload) throws NoProviderFoundException {
        IDownloadProvider provider = null;
        block0: for (IDownloadProvider p : providers) {
            for (FileType t : p.getCapabilities()) {
                if (!t.toString().equals(fileToDownload.toString())) continue;
                provider = p;
                continue block0;
            }
        }
        if (provider == null) {
            throw new NoProviderFoundException(fileToDownload);
        }
        return new DownloadFuture(url, downloadPath, provider);
    }

    static {
        DependencyManager.registerDownloadProvider(new PlainTextProvider());
        DependencyManager.registerDownloadProvider(new BinaryProvider());
    }

    protected static class DownloadFuture
    implements Future<Boolean> {
        public DownloadRunnable runnable;
        private boolean isCancelled = false;

        protected DownloadFuture(String url, String downloadPath, IDownloadProvider provider) {
            this.runnable = new DownloadRunnable(url, downloadPath, provider);
            this.runnable.start();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.runnable.disable(true);
            this.isCancelled = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isDone() {
            return this.runnable.isDone;
        }

        @Override
        public Boolean get() throws InterruptedException, ExecutionException {
            return this.runnable.didDownload;
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.runnable.didDownload;
        }

        protected static class DownloadRunnable
        extends SimpleRunnable {
            public boolean isDone = false;
            public boolean didDownload = false;
            private String url;
            private String downloadPath;
            private IDownloadProvider provider;
            private int downloadNum;

            public DownloadRunnable(String url, String downloadPath, IDownloadProvider provider) {
                this.url = url;
                this.downloadPath = downloadPath;
                this.provider = provider;
                this.downloadNum = numOfDownloaders++;
            }

            @Override
            public void run() {
                this.didDownload = this.provider.downloadFile(this.url, this.downloadPath);
                this.isDone = true;
            }

            @Override
            public String getName() {
                return "CollectiveFramework Downloader #" + numOfDownloaders;
            }
        }
    }
}

